/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.albauth.AlbAuthenticationConfiguration;
import de.resolution.albauth.AlbAuthenticationService;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.api.ConfigurationLoadFailedException;
import de.resolution.reconfigure.api.ConfigurationSaveFailedException;
import de.resolution.usersync.builtin.scim.rest.PATCH;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/config")
@Component
public class ConfigRelatedEndpoints {
    public static final String CC_NO_CACHE_VALUE = "no-cache, no-store, must-revalidate";
    public static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    public static final String COULD_NOT_SAVE_CONFIG_BECAUSE = "Could not save config because: ";
    private final PrivilegeChecker privilegeChecker;
    private final AlbAuthenticationService authenticationService;
    private static final Logger logger = LoggerFactory.getLogger(ConfigRelatedEndpoints.class);

    @Inject
    public ConfigRelatedEndpoints(PrivilegeChecker privilegeChecker, AlbAuthenticationService authenticationService) {
        this.privilegeChecker = privilegeChecker;
        this.authenticationService = authenticationService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConfigurationLoadFailedException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok((Object)JSONUtil.asJson(this.authenticationService.getConfiguration())).cacheControl(ccNoCache).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    public Response putConfig(@Context HttpServletRequest request, String jsonString) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        if (jsonString == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ConfigRelatedEndpoints.createMessageForJson("Json config string is null")).cacheControl(ccNoCache).build();
        }
        AlbAuthenticationConfiguration configViaRest = null;
        try {
            configViaRest = JSONUtil.fromJson(jsonString, AlbAuthenticationConfiguration.class);
        }
        catch (JSONUtil.JsonDeserializationFailedException e) {
            logger.error("Could not deserialize config because", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ConfigRelatedEndpoints.createMessageForJson("Could not deserialize config:\n" + e.getMessage())).cacheControl(ccNoCache).build();
        }
        ValidationResult validationResult = this.authenticationService.validate(configViaRest, (String)null);
        if (!validationResult.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ConfigRelatedEndpoints.createMessageForJson("Config is not valid:\n" + JSONUtil.asJson(validationResult))).cacheControl(ccNoCache).build();
        }
        return this.tryUpdateTheConfig(configViaRest, validationResult);
    }

    @DELETE
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    public Response deleteConfig(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        AlbAuthenticationConfiguration empty = this.authenticationService.emptyConfig();
        try {
            this.authenticationService.update(empty, (ValidationResult)null, (String)null, (UserProfile)null);
        }
        catch (ConfigurationSaveFailedException e) {
            logger.error(COULD_NOT_SAVE_CONFIG_BECAUSE, (Throwable)e);
            return Response.serverError().cacheControl(ccNoCache).entity(ConfigRelatedEndpoints.createMessageForJson("Could not save configuration because\n" + e.getMessage())).build();
        }
        return Response.ok().cacheControl(ccNoCache).build();
    }

    @PATCH
    @Consumes(value={"application/json", "application/merge-patch+json", "application/json-patch+json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    public Response patchConfig(@Context HttpServletRequest request, String patchForConfigurationJson) throws InsufficientUserPrivilegeException, ConfigurationLoadFailedException {
        AlbAuthenticationConfiguration patchedConfig;
        JsonNode patchedJson;
        this.privilegeChecker.checkSysAdmin(request);
        if (patchForConfigurationJson == null || patchForConfigurationJson.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ \"message\" : \"configuration patch must not be null or empty\" }").cacheControl(ccNoCache).build();
        }
        JsonNode existingConfigurationJson = JSONUtil.asJsonNode(this.authenticationService.getConfiguration());
        String contentType = request.getContentType();
        try {
            patchedJson = contentType != null && contentType.contains("application/json-patch+json") ? JSONUtil.applyPatch(existingConfigurationJson, JSONUtil.asJsonNode(patchForConfigurationJson)) : JSONUtil.applyMergePatch(existingConfigurationJson, JSONUtil.asJsonNode(patchForConfigurationJson));
        }
        catch (JSONUtil.JsonPatchFailedException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{ \"message\" : \"Patch failed:" + e.getMessage() + "\"}")).build();
        }
        if (existingConfigurationJson.equals(patchedJson)) {
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        }
        try {
            patchedConfig = JSONUtil.fromJson(patchedJson, AlbAuthenticationConfiguration.class);
        }
        catch (Exception e) {
            logger.error("Could not load patchedConfig. Config looks like {}", (Object)patchedJson, (Object)e);
            return Response.serverError().cacheControl(ccNoCache).entity(ConfigRelatedEndpoints.createMessageForJson("ContentType: " + contentType + "Could not deserialize patches config because\n" + e.getMessage() + "\n" + patchedJson)).build();
        }
        ValidationResult validationResult = this.authenticationService.validate(patchedConfig, (String)null);
        if (!validationResult.isValid()) {
            if (logger.isErrorEnabled()) {
                logger.error("Configuration data is not valid: {}", (Object)JSONUtil.asJson(validationResult));
                logger.error("Configuration data is : {}", (Object)patchedJson);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)JSONUtil.asJson(validationResult)).cacheControl(ccNoCache).build();
        }
        return this.tryUpdateTheConfig(patchedConfig, validationResult);
    }

    private Response tryUpdateTheConfig(AlbAuthenticationConfiguration patchedConfig, ValidationResult validationResult) {
        try {
            this.authenticationService.update(patchedConfig, validationResult, (String)null, (UserProfile)null);
        }
        catch (ConfigurationSaveFailedException e) {
            logger.error(COULD_NOT_SAVE_CONFIG_BECAUSE, (Throwable)e);
            return Response.serverError().cacheControl(ccNoCache).entity(ConfigRelatedEndpoints.createMessageForJson("Could not save configuration because\n" + e.getMessage())).build();
        }
        return Response.ok().cacheControl(ccNoCache).build();
    }

    @Nonnull
    private static Map<String, String> createMessageForJson(@Nullable String msg) {
        return Collections.singletonMap("message", msg == null ? "" : msg);
    }
}

