/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth.auditlog;

import com.atlassian.audit.api.AuditService;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.albauth.auditlog.AuditLogService;
import de.resolution.albauth.auditlog.AuditLogUtil;
import de.resolution.albauth.auditlog.NewApiAuditLogService;
import de.resolution.albauth.auditlog.NoOpAuditLogService;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DelegatingAuditLogService
implements AuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingAuditLogService.class);
    private final AuditLogService delegate;

    @Inject
    public DelegatingAuditLogService(@Nonnull AtlasCompatApiFactory atlasCompatApiFactory, UserManager userManager) {
        if (AuditLogUtil.supportsAuditLogApi(atlasCompatApiFactory)) {
            AuditService auditService = (AuditService)ComponentLocator.getComponent(AuditService.class);
            if (auditService == null) {
                logger.error("Failed to load AuditService.class, falling back to NoOp-Implementation!");
                this.delegate = new NoOpAuditLogService();
            } else {
                this.delegate = new NewApiAuditLogService(auditService);
            }
        } else {
            this.delegate = new NoOpAuditLogService();
        }
    }

    @Override
    public void logConfigurationUpdate(@Nonnull String auditRecordSummary, @Nonnull JsonNode beforeConfigJsonNode, @Nonnull JsonNode afterConfigJsonNode) {
        this.delegate.logConfigurationUpdate(auditRecordSummary, beforeConfigJsonNode, afterConfigJsonNode);
    }
}

