/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListUtil {
    private ListUtil() {
    }

    @Nullable
    public static <T> T firstOrNull(@Nullable List<T> stringList) {
        if (stringList == null || stringList.isEmpty()) {
            return null;
        }
        return stringList.get(0);
    }

    @Nonnull
    public static String firstOrEmptyString(@Nullable List<String> stringList) {
        if (stringList == null || stringList.isEmpty()) {
            return "";
        }
        return stringList.get(0);
    }

    public static List<String> readStringArray(@Nullable JsonNode jsonNode) {
        ArrayList<String> ret = new ArrayList<String>();
        if (jsonNode == null) {
            return Collections.emptyList();
        }
        if (jsonNode instanceof ArrayNode) {
            for (JsonNode current : jsonNode) {
                ret.add(current.asText());
            }
        }
        return ret;
    }
}

