/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import de.resolution.commons.util.StringUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JSONUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter objectWriter;
    private static final ObjectWriter objectWriterNonNullNotEmpty;

    private JSONUtil() {
    }

    @Nonnull
    public static JsonNode asJsonNode(@Nonnull String jsonString) {
        try {
            return objectMapper.readTree(jsonString);
        }
        catch (JsonProcessingException e) {
            throw new JsonDeserializationFailedException(e);
        }
    }

    @Nonnull
    public static JsonNode asJsonNode(@Nonnull Object object) {
        return objectMapper.valueToTree(object);
    }

    @Nonnull
    public static <T> T fromJson(@Nonnull String jsonString, @Nonnull Class<T> clazz) {
        try {
            return objectMapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            throw new JsonDeserializationFailedException(e);
        }
    }

    @Nonnull
    public static <T> T fromJson(@Nonnull JsonNode jsonNode, @Nonnull Class<T> clazz) {
        try {
            return objectMapper.treeToValue((TreeNode)jsonNode, clazz);
        }
        catch (IOException e) {
            throw new JsonDeserializationFailedException(e);
        }
    }

    @Nonnull
    public static String asJson(@Nullable Object object) {
        try {
            return objectWriter.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializationFailedException(e);
        }
    }

    @Nonnull
    public static String asJsonWithoutNullOrEmpty(@Nullable Object object) {
        try {
            return objectWriterNonNullNotEmpty.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializationFailedException(e);
        }
    }

    public static boolean isValidJson(@Nullable String jsonString) {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return false;
        }
        try {
            objectMapper.readTree(jsonString);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Nonnull
    public static <K, V> Map<K, V> deserializeMap(@Nullable String jsonStr, @Nonnull Class<K> keyClass, @Nonnull Class<V> valueClass) {
        if (StringUtil.isNullOrEmpty(jsonStr)) {
            return Collections.emptyMap();
        }
        MapType mapType = objectMapper.getTypeFactory().constructMapType(Map.class, keyClass, valueClass);
        try {
            return (Map)objectMapper.readValue(jsonStr, (JavaType)mapType);
        }
        catch (JsonProcessingException e) {
            return Collections.emptyMap();
        }
    }

    @Nonnull
    public static <K> List<K> deserializeList(@Nullable String jsonStr, @Nonnull Class<K> clazz) {
        if (StringUtil.isNullOrEmpty(jsonStr)) {
            return Collections.emptyList();
        }
        CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, clazz);
        try {
            return (List)objectMapper.readValue(jsonStr, (JavaType)type);
        }
        catch (JsonProcessingException e) {
            return Collections.emptyList();
        }
    }

    public static JsonNode applyMergePatch(@Nonnull JsonNode nodeToBePatched, @Nonnull JsonNode nodeWithPatch) {
        try {
            JsonMergePatch mergePatch = JsonMergePatch.fromJson(nodeWithPatch);
            return mergePatch.apply(nodeToBePatched);
        }
        catch (JsonPatchException e) {
            throw new JsonPatchFailedException(e);
        }
    }

    public static JsonNode applyPatch(@Nonnull JsonNode nodeToBePatched, @Nonnull JsonNode nodeWithPatch) {
        try {
            JsonPatch mergePatch = JsonPatch.fromJson(nodeWithPatch);
            return mergePatch.apply(nodeToBePatched);
        }
        catch (JsonPatchException | IOException e) {
            throw new JsonPatchFailedException(e);
        }
    }

    public static JsonNode updateValue(JsonNode jsonNode, String key, String newValue) {
        if (!jsonNode.isObject()) {
            return jsonNode;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        objectNode.put(key, newValue);
        return jsonNode;
    }

    public static JsonNode updateValue(JsonNode jsonNode, String key, int newValue) {
        if (!jsonNode.isObject()) {
            return jsonNode;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        objectNode.put(key, newValue);
        return jsonNode;
    }

    public static JsonNode updateValue(JsonNode jsonNode, String key, long newValue) {
        if (!jsonNode.isObject()) {
            return jsonNode;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        objectNode.put(key, newValue);
        return jsonNode;
    }

    public static String readString(@Nonnull JsonNode node, @Nonnull String key) {
        if (!node.has(key)) {
            return null;
        }
        JsonNode dataNode = node.get(key);
        if (dataNode == null || dataNode.isNull()) {
            return null;
        }
        if (dataNode.isTextual()) {
            return dataNode.textValue();
        }
        return dataNode.toString();
    }

    public static int readInt(@Nonnull JsonNode node, @Nonnull String key) {
        if (!node.has(key)) {
            return 0;
        }
        JsonNode dataNode = node.get(key);
        if (dataNode == null || dataNode.isNull()) {
            return 0;
        }
        return dataNode.asInt();
    }

    public static long readLong(@Nonnull JsonNode node, @Nonnull String key) {
        if (!node.has(key)) {
            return 0L;
        }
        JsonNode dataNode = node.get(key);
        if (dataNode == null || dataNode.isNull()) {
            return 0L;
        }
        return dataNode.asLong();
    }

    public static String readString(@Nonnull String json, @Nonnull String key) {
        return JSONUtil.readString(JSONUtil.asJsonNode(json), key);
    }

    public static String prettify(@Nonnull String json) {
        return JSONUtil.asJsonNode(json).toPrettyString();
    }

    public static boolean pointerAsBoolean(@Nonnull String json, @Nonnull String pointer) {
        return JSONUtil.asJsonNode(json).at(pointer).asBoolean();
    }

    public static String pointerAsText(@Nonnull String json, @Nonnull String pointer) {
        return JSONUtil.asJsonNode(json).at(pointer).asText();
    }

    public static String updateValue(@Nonnull String json, @Nonnull String key, @Nullable String value) {
        JsonNode jsonNode = JSONUtil.asJsonNode(json);
        JSONUtil.updateValue(jsonNode, key, value);
        return jsonNode.toPrettyString();
    }

    static {
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        ObjectMapper omNonNull = new ObjectMapper();
        omNonNull.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        omNonNull.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectWriterNonNullNotEmpty = omNonNull.writer();
    }

    public static class JsonDeserializationFailedException
    extends RuntimeException {
        public JsonDeserializationFailedException(Throwable cause) {
            super("Creating object from JSON failed", cause);
        }
    }

    public static class JsonSerializationFailedException
    extends RuntimeException {
        public JsonSerializationFailedException(Throwable cause) {
            super("Creating JSON failed", cause);
        }
    }

    public static class JsonPatchFailedException
    extends RuntimeException {
        public JsonPatchFailedException(Throwable cause) {
            super("Patching JSON failed", cause);
        }
    }
}

