/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlascompat.jira73;

import com.atlassian.fugue.Either;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskManager;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentService;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.organization.OrganizationService;
import com.atlassian.servicedesk.api.organization.OrganizationServiceDeskUpdateParameters;
import com.atlassian.servicedesk.api.organization.OrganizationsQuery;
import com.atlassian.servicedesk.api.organization.UsersOrganizationUpdateParameters;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import de.resolution.atlascompat.api.exception.AtlasCompatApiException;
import de.resolution.atlascompat.jira.JiraServiceDeskApiBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraServiceDesk33Api
extends JiraServiceDeskApiBase {
    private static final Logger logger = LoggerFactory.getLogger(JiraServiceDesk33Api.class);
    private final UserManager userManager = this.getComponent(UserManager.class);
    private final IssueManager issueManager = this.getComponent(IssueManager.class);
    private final ProjectManager projectManager;
    private final ServiceDeskCommentService serviceDeskCommentService = this.getComponent(ServiceDeskCommentService.class);
    private final ServiceDeskPermissionService serviceDeskPermissionService = this.getComponent(ServiceDeskPermissionService.class);
    private final ServiceDeskManager serviceDeskManager = this.getComponent(ServiceDeskManager.class);
    private final OrganizationService organizationService = this.getComponent(OrganizationService.class);

    public JiraServiceDesk33Api() throws AtlasCompatApiException {
        super(Arrays.asList(UserManager.class, IssueManager.class, ServiceDeskPermissionService.class, ServiceDeskCommentService.class, ServiceDeskManager.class, OrganizationService.class, ProjectManager.class));
        this.projectManager = this.getComponent(ProjectManager.class);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    public <T> T getComponent(Class<T> clazz) {
        try {
            return (T)ComponentAccessor.getOSGiComponentInstanceOfType(clazz);
        }
        catch (NoClassDefFoundError e) {
            logger.error("Component {} not found", (Object)clazz.getName());
            return null;
        }
    }

    @Override
    public boolean isCustomer(String userKey, Long issueId) {
        ApplicationUser user = this.userManager.getUserByKey(userKey);
        if (user == null) {
            logger.error("Got a null user for a supposedly existing user with userKey {}", (Object)userKey);
            return false;
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        boolean isCustomer = false;
        Either userIsCostumer = this.serviceDeskPermissionService.isCustomer(user, (Issue)issue);
        if (userIsCostumer.isRight()) {
            isCustomer = (Boolean)userIsCostumer.right().get();
        }
        logger.debug("User '{}' is customer = {}", (Object)user.getUsername(), (Object)isCustomer);
        return isCustomer;
    }

    @Override
    public boolean isPublicComment(String userKey, Long commentId) {
        ApplicationUser user = this.userManager.getUserByKey(userKey);
        if (user == null) {
            logger.error("Got a null user for a supposedly existing user with userKey {}", (Object)userKey);
            return false;
        }
        boolean isJsdPublic = false;
        Either serviceDeskCommentFromJiraComment = this.serviceDeskCommentService.getServiceDeskCommentById(user, commentId);
        if (serviceDeskCommentFromJiraComment.isRight()) {
            isJsdPublic = ((ServiceDeskComment)serviceDeskCommentFromJiraComment.right().get()).isPublic();
        }
        return isJsdPublic;
    }

    @Override
    public boolean isOrganizationPresent(String organizationName, String adminUserKey) throws AtlasCompatApiException {
        ApplicationUser adminUser = this.userManager.getUserByKey(adminUserKey);
        if (adminUser == null) {
            throw new AtlasCompatApiException("Could not find adminUser with key " + adminUserKey);
        }
        return this.findOrganizationByName(organizationName, adminUser) != null;
    }

    @Override
    public boolean isOrganizationApiSupported() {
        return true;
    }

    @Override
    public boolean assignUserToOrganization(@Nonnull String userKey, @Nonnull String adminUserKey, @Nonnull String organizationName, boolean createIfUnknown) throws AtlasCompatApiException {
        UsersOrganizationUpdateParameters updateParameters;
        Either anErrorUnitEither;
        ApplicationUser applicationUser = this.userManager.getUserByKey(userKey);
        ApplicationUser adminUser = this.userManager.getUserByKey(adminUserKey);
        if (applicationUser == null) {
            throw new AtlasCompatApiException("Could not find applicationUser with key " + userKey);
        }
        if (adminUser == null) {
            throw new AtlasCompatApiException("Could not find adminUser with key " + adminUserKey);
        }
        CustomerOrganization customerOrganization = this.findOrganizationByName(organizationName, adminUser);
        if (customerOrganization == null) {
            if (createIfUnknown) {
                int customerOrganizationCreatedId = this.createOrganization(organizationName, adminUserKey);
                Either anErrorCustomerOrganizationEither = this.organizationService.getById(adminUser, Integer.valueOf(customerOrganizationCreatedId));
                if (anErrorCustomerOrganizationEither.isRight()) {
                    customerOrganization = (CustomerOrganization)anErrorCustomerOrganizationEither.right().get();
                }
                if (anErrorCustomerOrganizationEither.isLeft()) {
                    throw new AtlasCompatApiException("Could not retrieve newly created organization " + organizationName + " with Id " + customerOrganizationCreatedId);
                }
            }
            if (customerOrganization == null) {
                throw new AtlasCompatApiException("Could not find organization " + organizationName + ", createIfUnknown = " + createIfUnknown);
            }
        }
        if ((anErrorUnitEither = this.organizationService.addUsersToOrganization(adminUser, updateParameters = this.organizationService.newUsersOrganizationUpdateParametersBuilder().organization(customerOrganization).users(Collections.singleton(applicationUser)).build())).isLeft()) {
            throw new AtlasCompatApiException("Assigning " + applicationUser.getName() + " to " + organizationName + " failed: " + anErrorUnitEither.left().map(AnError::getMessage));
        }
        return anErrorUnitEither.isRight();
    }

    @Nullable
    private CustomerOrganization findOrganizationByName(@Nonnull String organizationName, @Nonnull ApplicationUser adminUser) {
        PagedRequestImpl pagedRequest = new PagedRequestImpl();
        PagedResponse pagedResponse = null;
        CustomerOrganization organization = null;
        do {
            pagedRequest.nextPage();
            OrganizationsQuery query = this.organizationService.newOrganizationsQueryBuilder().pagedRequest((PagedRequest)pagedRequest).build();
            Either either = this.organizationService.getOrganizations(adminUser, query);
            if (!either.isRight()) continue;
            pagedResponse = (PagedResponse)either.right().get();
            organization = this.findByName(organizationName, (PagedResponse<CustomerOrganization>)pagedResponse);
        } while (organization == null && pagedResponse != null && pagedResponse.hasNextPage());
        return organization;
    }

    @Nullable
    private CustomerOrganization findByName(@Nonnull String organizationName, @Nonnull PagedResponse<CustomerOrganization> pagedResponse) {
        for (CustomerOrganization organization : pagedResponse) {
            if (!organization.getName().equals(organizationName)) continue;
            return organization;
        }
        return null;
    }

    @Override
    public int createOrganization(@Nonnull String organizationName, @Nonnull String adminUserKey) throws AtlasCompatApiException {
        ApplicationUser adminUser = this.userManager.getUserByKey(adminUserKey);
        if (adminUser == null) {
            throw new AtlasCompatApiException("createOrganization: Could not fetch admin user with key " + adminUserKey);
        }
        Either anErrorCustomerOrganizationEither = this.organizationService.createOrganization(adminUser, this.organizationService.newCreateBuilder().name(organizationName).build());
        if (anErrorCustomerOrganizationEither.isLeft()) {
            throw new AtlasCompatApiException("Creating Organization " + organizationName + " failed: " + anErrorCustomerOrganizationEither.left().map(AnError::getMessage));
        }
        if (anErrorCustomerOrganizationEither.isRight()) {
            try {
                this.addOrganizationToAllServicedesks(adminUser, (CustomerOrganization)anErrorCustomerOrganizationEither.right().get(), this.organizationService);
            }
            catch (AtlasCompatApiException e) {
                throw new AtlasCompatApiException(e);
            }
            CustomerOrganization customerOrganization = (CustomerOrganization)anErrorCustomerOrganizationEither.right().get();
            return customerOrganization.getId();
        }
        return -1;
    }

    private void addOrganizationToAllServicedesks(@Nonnull ApplicationUser adminUser, @Nonnull CustomerOrganization customerOrganization, @Nonnull OrganizationService organizationService) throws AtlasCompatApiException {
        List projects = this.projectManager.getProjects();
        for (Project project : projects) {
            try {
                if (!project.getProjectTypeKey().getKey().equals("service_desk") || this.isArchivedProject(project)) continue;
                Integer serviceDeskId = ((ServiceDesk)this.serviceDeskManager.getServiceDeskForProject(project).right().get()).getId();
                logger.info("Found Jira ServiceDesk {} with ServiceDeskId {}, now adding new organization to it.", (Object)project.getKey(), (Object)serviceDeskId);
                OrganizationServiceDeskUpdateParameters organizationServiceDeskUpdateParameters = organizationService.newOrganizationServiceDeskUpdateParametersBuilder().organization(customerOrganization).serviceDeskId(serviceDeskId).build();
                organizationService.addOrganizationToServiceDesk(adminUser, organizationServiceDeskUpdateParameters);
            }
            catch (Exception e) {
                throw new AtlasCompatApiException("Exception in addOrganizationToAllServicedesks(...)", e);
            }
        }
    }

    private boolean isArchivedProject(@Nonnull Project project) {
        Object returnValue;
        Method methodToInvoke;
        Class<Project> projectClass = Project.class;
        String methodName = "isArchived";
        try {
            methodToInvoke = projectClass.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        methodToInvoke.setAccessible(true);
        try {
            returnValue = methodToInvoke.invoke((Object)project, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
        if (returnValue instanceof Boolean) {
            return (Boolean)returnValue;
        }
        return false;
    }

    @Override
    public Map<Integer, String> getPortalIdsAndNames() {
        logger.warn("getPortalIdsAndNames() is not implemented here, returning empty map.");
        return Collections.emptyMap();
    }

    private class PagedRequestImpl
    implements PagedRequest {
        private int start = 0;
        private static final int LIMIT = 20;
        private boolean nextPageCalled = false;

        private PagedRequestImpl() {
        }

        void nextPage() {
            if (!this.nextPageCalled) {
                this.nextPageCalled = true;
            } else {
                this.start += 20;
            }
        }

        public int getStart() {
            return this.start;
        }

        public int getLimit() {
            return 20;
        }
    }
}

