/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.resolution.atlasauth.impl.AuthenticationAttribute;
import de.resolution.atlasauth.impl.DirectoryAdapter;
import de.resolution.atlasauth.impl.RemoteDirectoryAdapter;
import de.resolution.atlasauth.impl.SyncRequiredException;
import de.resolution.atlasauth.impl.UserAuthException;
import java.security.Principal;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
@BitbucketComponent
public class DirectoryAdapterImpl
implements DirectoryAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryAdapterImpl.class);
    private final TransactionTemplate transactionTemplate;
    protected final DirectoryManager directoryManager;
    private final RemoteDirectoryAdapter remoteDirectoryAdapter;
    private final CrowdDirectoryService crowdDirectoryService;

    @Autowired
    public DirectoryAdapterImpl(RemoteDirectoryAdapter remoteDirectoryAdapter, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport DirectoryManager directoryManager, @ComponentImport CrowdDirectoryService crowdDirectoryService) {
        this.transactionTemplate = transactionTemplate;
        this.directoryManager = directoryManager;
        this.remoteDirectoryAdapter = remoteDirectoryAdapter;
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Override
    public Principal findUser(@Nonnull AuthenticationAttribute authenticationAttribute, @Nonnull String authenticationAttributeValue, boolean fetchFromRemoteDirectory, boolean triggerUpdateOnCrowdDirectories) throws UserAuthException {
        PrincipalAndException resultFromTransaction = (PrincipalAndException)this.transactionTemplate.execute(() -> {
            List<Directory> directories = this.getAllDirectories();
            Object user = null;
            UserAuthException exceptionInTransaction = null;
            if (authenticationAttribute == AuthenticationAttribute.USERNAME) {
                this.publishJiraBeforeUserAuthenticateEvent(authenticationAttributeValue);
            }
            for (Directory dir : directories) {
                if (dir.isActive()) {
                    long id = dir.getId();
                    try {
                        try {
                            if (authenticationAttribute == AuthenticationAttribute.USERNAME) {
                                user = this.directoryManager.findUserByName(id, authenticationAttributeValue);
                            } else if (authenticationAttribute == AuthenticationAttribute.ADDITIONALID) {
                                Property<String> property = new Property<String>(){

                                    public String getPropertyName() {
                                        return "ATTR_ADDITIONAL_ID";
                                    }

                                    public Class<String> getPropertyType() {
                                        return String.class;
                                    }
                                };
                                TermRestriction termRestriction = new TermRestriction((Property)property, MatchMode.EXACTLY_MATCHES, (Object)authenticationAttributeValue);
                                UserQuery eq = new UserQuery(User.class, (SearchRestriction)termRestriction, 0, 2);
                                List users = this.directoryManager.searchUsers(id, (EntityQuery)eq);
                                if (users == null || users.isEmpty()) {
                                    throw new UserNotFoundException("User was not found locally in directory " + dir.getName() + ".");
                                }
                                if (users.size() > 1) {
                                    throw new UserAuthException("Multiple users with additionalId " + authenticationAttributeValue + " found in directory " + dir.getName() + ".");
                                }
                                user = (Principal)users.get(0);
                            } else if (authenticationAttribute == AuthenticationAttribute.EMAIL) {
                                UserQuery eq = new UserQuery(User.class, (SearchRestriction)new TermRestriction(UserTermKeys.EMAIL, MatchMode.EXACTLY_MATCHES, (Object)authenticationAttributeValue), 0, 2);
                                List users = this.directoryManager.searchUsers(id, (EntityQuery)eq);
                                if (users == null || users.isEmpty()) {
                                    throw new UserNotFoundException("User was not found locally in directory " + dir.getName() + ".");
                                }
                                if (users.size() > 1) {
                                    throw new UserAuthException("Multiple users with email address " + authenticationAttributeValue + " found in directory " + dir.getName() + ".");
                                }
                                user = (Principal)users.get(0);
                            } else {
                                throw new UserAuthException("Authentication attribute " + (Object)((Object)authenticationAttribute) + " is not supported.");
                            }
                            logger.debug("Found user {} in directory {}", (Object)user.getName(), (Object)dir.getName());
                            this.remoteDirectoryAdapter.assignDirectoryDefaultGroups((Principal)user, dir);
                        }
                        catch (UserNotFoundException e) {
                            logger.debug("User was not found locally in {}.", (Object)dir.getName(), (Object)e);
                            user = this.remoteDirectoryAdapter.findRemoteUser(authenticationAttribute, authenticationAttributeValue, dir, fetchFromRemoteDirectory, triggerUpdateOnCrowdDirectories);
                        }
                    }
                    catch (UserAuthException e) {
                        exceptionInTransaction = e;
                    }
                    catch (Exception e) {
                        exceptionInTransaction = new UserAuthException(e);
                    }
                    if (user == null) continue;
                    try {
                        this.remoteDirectoryAdapter.updateRemoteUser(user.getName(), dir, fetchFromRemoteDirectory, triggerUpdateOnCrowdDirectories);
                    }
                    catch (SyncRequiredException se) {
                        exceptionInTransaction = se;
                    }
                    if (authenticationAttribute == AuthenticationAttribute.USERNAME) break;
                    this.publishJiraBeforeUserAuthenticateEvent(user.getName());
                    break;
                }
                logger.debug("Skipping inactive directory {}", (Object)dir.getName());
            }
            PrincipalAndException result = new PrincipalAndException();
            result.ex = exceptionInTransaction;
            result.principal = user;
            return result;
        });
        if (resultFromTransaction.ex == null) {
            return resultFromTransaction.principal;
        }
        throw resultFromTransaction.ex;
    }

    @Override
    public List<Directory> getAllDirectories() {
        return this.crowdDirectoryService.findAllDirectories();
    }

    @Override
    public void publishJiraBeforeUserAuthenticateEvent(@NotNull String username) {
    }

    private class PrincipalAndException {
        public Principal principal;
        public UserAuthException ex;

        private PrincipalAndException() {
        }
    }
}

