/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth.auditlog;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.albauth.auditlog.AuditLogService;
import de.resolution.albauth.auditlog.AuditLogUtil;
import de.resolution.commons.util.DiffUtil;
import de.resolution.commons.util.JSONUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewApiAuditLogService
implements AuditLogService {
    public static final String AUDIT_TYPE_CATEGORY_TOKEN_MANAGEMENT = "Token Management";
    public static final String AUDIT_TYPE_CATEGORY_TOKEN_AUTH = "Token Authentication";
    private static final Logger logger = LoggerFactory.getLogger(NewApiAuditLogService.class);
    private final AuditService auditService;
    private final Collection<String> pathsToIgnore = Arrays.asList("\\/multiMetadataStatus\\/lastUpdated", "\\/multiMetadataStatus\\/lastUpdatedUTC", "\\/idpConfigurations\\/[0-9]+\\/lastMetadataReload", "\\/multiMetadataStatus");
    private final Collection<String> pathsToRedact = Collections.singletonList("\\/privateKeyPEM");

    public NewApiAuditLogService(@Nonnull AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public void logConfigurationUpdate(@Nonnull String auditRecordSummary, @Nonnull JsonNode beforeConfigJsonNode, @Nonnull JsonNode afterConfigJsonNode) {
        List<DiffUtil.Change> changes;
        try {
            changes = DiffUtil.diff(beforeConfigJsonNode, afterConfigJsonNode);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to calculate diff", (Throwable)e);
                logger.warn("Old: {}", (Object)JSONUtil.asJson(beforeConfigJsonNode));
                logger.warn("New: {}", (Object)JSONUtil.asJson(afterConfigJsonNode));
            }
            changes = Collections.singletonList(new DiffUtil.Change("", "Calculating diff failed: " + e.getMessage(), null));
        }
        List<ChangedValue> changedValues = AuditLogUtil.toChangedValues(changes, this.pathsToIgnore, this.pathsToRedact);
        if (changedValues.isEmpty()) {
            logger.debug("No configuration change detected");
            return;
        }
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.ECOSYSTEM, (CoverageLevel)CoverageLevel.BASE, (String)"AWS ALB & Amazon Cognito Authentication", (String)auditRecordSummary).build();
        AuditResource affectedObject = AuditResource.builder((String)"Configuration", (String)"Configuration").build();
        AuditEvent event = AuditEvent.builder((AuditType)auditType).affectedObject(affectedObject).changedValues(changedValues).build();
        this.auditService.audit(event);
    }
}

