/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth.activeobjects;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.albauth.activeobjects.AoConfiguration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AoConfigurationActiveObjectsProxy {
    private static final Logger logger = LoggerFactory.getLogger(AoConfigurationActiveObjectsProxy.class);
    private static final String LAST_MODIFIED_BY = "LAST_MODIFIED_BY";
    private static final String LAST_UPDATED = "LAST_UPDATED";
    private static final String CONFIGURATION_STRING = "CONFIGURATION_STRING";
    private static final String ID_DESC = "\"ID\" DESC";
    private static final String VERSION = "VERSION";
    private final ActiveObjects activeObjects;

    @Inject
    public AoConfigurationActiveObjectsProxy(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void storeConfig(@Nonnull String lastModifiedBy, long lastUpdated, int configVersion, @Nonnull String configJson) {
        this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.create(AoConfiguration.class, new DBParam[]{new DBParam(LAST_MODIFIED_BY, (Object)lastModifiedBy), new DBParam(LAST_UPDATED, (Object)lastUpdated), new DBParam(VERSION, (Object)configVersion), new DBParam(CONFIGURATION_STRING, (Object)configJson)});
            return null;
        });
    }

    @Nullable
    public String retrieveLastConfig() {
        return (String)this.activeObjects.executeInTransaction(() -> {
            try {
                AoConfiguration[] configArr = (AoConfiguration[])this.activeObjects.find(AoConfiguration.class, Query.select().where("\"VERSION\" <= ?", new Object[]{2}).order(ID_DESC).limit(1));
                if (configArr == null || configArr.length == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Cannot find the config in the config table");
                    }
                    return null;
                }
                AoConfiguration config = configArr[0];
                if (config == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Retrieved config is null for some reason");
                    }
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Got id={}, with timestamp={}", (Object)config.getId(), (Object)config.getLastUpdated());
                }
                return configArr[0].getConfigurationString();
            }
            catch (Exception e) {
                logger.error("Got general AO exception during config string loading", (Throwable)e);
                return null;
            }
        });
    }
}

