/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.resolution.albauth.AlbAuthenticationConfiguration;
import de.resolution.albauth.AlbAuthenticationResult;
import de.resolution.albauth.AlbAuthenticationService;
import de.resolution.albauth.ErrorPageTemplateHelper;
import de.resolution.atlasauth.api.AuthenticationResult;
import de.resolution.commons.util.JSONUtil;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class AlbAuthenticationFilter
implements Filter {
    private static final String ALREADY_FILTERED = AlbAuthenticationFilter.class.getName() + "_already_filtered";
    protected static final String DO_SD_LOGOUT = AlbAuthenticationFilter.class.getName() + "_do_sd_logout";
    private final AlbAuthenticationService authenticationService;
    private static final Logger logger = LoggerFactory.getLogger(AlbAuthenticationFilter.class);
    private static final Logger invalidIpLogger = LoggerFactory.getLogger((String)"de.resolution.albauth.invalidip");
    private static final Logger nonAuthURLLogger = LoggerFactory.getLogger((String)"de.resolution.albauth.nonauthurl");
    private static final Logger noUserLogger = LoggerFactory.getLogger((String)"de.resolution.albauth.nouser");
    private static final Logger alreadyAuthorizedLogger = LoggerFactory.getLogger((String)"de.resolution.albauth.alreadyauthorized");
    private static final Logger failedLogger = LoggerFactory.getLogger((String)"de.resolution.albauth.fail");
    private static final Logger errorLogger = LoggerFactory.getLogger((String)"de.resolution.albauth.error");
    private static final Logger successLogger = LoggerFactory.getLogger((String)"de.resolution.albauth.success");
    private static final Logger logoutLogger = LoggerFactory.getLogger((String)"de.resolution.albauth.logout");
    private final TemplateRenderer templateRenderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public AlbAuthenticationFilter(AlbAuthenticationService albAuthenticationService, TemplateRenderer templateRenderer, ApplicationProperties applicationProperties) {
        this.authenticationService = albAuthenticationService;
        this.templateRenderer = templateRenderer;
        this.applicationProperties = applicationProperties;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(ALREADY_FILTERED) != null) {
            chain.doFilter(req, res);
            return;
        }
        req.setAttribute(ALREADY_FILTERED, (Object)"yes");
        try {
            HttpServletRequest servletRequest = (HttpServletRequest)req;
            HttpServletResponse servletResponse = (HttpServletResponse)res;
            AlbAuthenticationConfiguration config = this.authenticationService.getConfiguration();
            AlbAuthenticationResult authenticationResult = this.authenticationService.injectAuthentication(servletRequest, servletResponse);
            block1 : switch (authenticationResult.getReason()) {
                case NONAUTHURL: {
                    if (!nonAuthURLLogger.isTraceEnabled()) break;
                    nonAuthURLLogger.debug("No authentication required for URL: {}", (Object)JSONUtil.asJson(authenticationResult));
                    break;
                }
                case INVALIDIP: {
                    if (!invalidIpLogger.isTraceEnabled()) break;
                    invalidIpLogger.debug("Source IP not authorized: {}", (Object)JSONUtil.asJson(authenticationResult));
                    break;
                }
                case NOUSER: {
                    if (!noUserLogger.isTraceEnabled()) break;
                    noUserLogger.debug("No user in claim: {}", (Object)JSONUtil.asJson(authenticationResult));
                    break;
                }
                default: {
                    switch (authenticationResult.getOutcome()) {
                        case SUCCESS: {
                            if (!successLogger.isDebugEnabled()) break block1;
                            successLogger.debug("Authentication successful: {}", (Object)JSONUtil.asJson(authenticationResult));
                            break block1;
                        }
                        case FAILED: {
                            if (!failedLogger.isDebugEnabled()) break block1;
                            failedLogger.debug("Authentication failed: {}", (Object)JSONUtil.asJson(authenticationResult));
                            break block1;
                        }
                        case ERROR: {
                            if (!errorLogger.isDebugEnabled()) break block1;
                            errorLogger.debug("Error during authentication: {}", (Object)JSONUtil.asJson(authenticationResult));
                            break block1;
                        }
                        case ALREADY_AUTHORIZED: {
                            if (!alreadyAuthorizedLogger.isDebugEnabled()) break block1;
                            alreadyAuthorizedLogger.debug("User is already authorized: {}", (Object)JSONUtil.asJson(authenticationResult));
                            break block1;
                        }
                        case LOGOUT: {
                            logoutLogger.trace("User tries logout");
                            this.doLogout(servletRequest, servletResponse, config);
                            return;
                        }
                        case SD_LOGOUT_STEP_1: {
                            logoutLogger.trace("SD tries logout - step 1");
                            HttpSession session = servletRequest.getSession(false);
                            if (session != null) {
                                session.setAttribute(DO_SD_LOGOUT, (Object)"yes");
                            } else {
                                logoutLogger.error("User tries SD logout but there is no session?!");
                            }
                            return;
                        }
                        case SD_LOGOUT_STEP_2: {
                            logoutLogger.trace("SD tries logout - step 2");
                            this.doLogout(servletRequest, servletResponse, config);
                            return;
                        }
                        default: {
                            if (!logger.isDebugEnabled()) break block1;
                            logger.debug("Unexpected AuthenticationResult: {}", (Object)JSONUtil.asJson(authenticationResult));
                        }
                    }
                }
            }
            if (this.shouldDisplayErrorPage(config.isShowErrorPage(), authenticationResult)) {
                this.sendError(servletRequest, servletResponse, authenticationResult.getMessage(), config.getErrorPageTemplate());
                return;
            }
            if (!authenticationResult.isResponseCommitted()) {
                chain.doFilter(req, res);
            }
        }
        catch (Exception e) {
            logger.warn("injectAuthentication failed", (Throwable)e);
            chain.doFilter(req, res);
        }
    }

    private void doLogout(HttpServletRequest req, HttpServletResponse servletResponse, AlbAuthenticationConfiguration config) throws IOException {
        if (config.isRemoveAwsCookieOnLogout()) {
            Cookie c = new Cookie("AWSELBAuthSessionCookie-0", "-1");
            c.setHttpOnly(true);
            c.setSecure(true);
            c.setPath("/");
            servletResponse.addCookie(c);
            logoutLogger.trace("Deleting AWSELBAuthSessionCookie-0 Cookie");
        } else {
            logoutLogger.trace("AWS Cookie should not be deleted");
        }
        if (this.authenticationService.logout(req, servletResponse)) {
            logoutLogger.trace("Invalidating users session was successful");
        } else {
            logoutLogger.trace("Invalidating user's session was NOT successful. Check possible log message before this message");
        }
        if (config.isRedirectOnLogout()) {
            if (config.getRedirectTargetOnLogout() != null) {
                servletResponse.sendRedirect(config.getRedirectTargetOnLogout());
            } else {
                logger.error("Cannot redirect to logout target because no url is set.");
            }
        } else {
            logoutLogger.trace("User should NOT be redirected after logout. Thus logout may not working because the IdP session may still exists");
        }
    }

    private boolean shouldDisplayErrorPage(boolean isDisplayErrorPage, @Nonnull AlbAuthenticationResult authenticationResult) {
        return isDisplayErrorPage && (authenticationResult.getOutcome() == AuthenticationResult.Outcome.FAILED || authenticationResult.getOutcome() == AuthenticationResult.Outcome.ERROR);
    }

    private void sendError(@Nonnull HttpServletRequest servletRequest, @Nonnull HttpServletResponse servletResponse, @Nullable String errorMessage, @Nullable String errorTemplate) throws IOException {
        HttpSession session = servletRequest.getSession();
        session.setAttribute("errorPageTemplate", (Object)ErrorPageTemplateHelper.generateErrorTemplate(errorMessage, errorTemplate, this.templateRenderer));
        servletResponse.sendRedirect(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/plugins/servlet/de.resolution.albauth/error");
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

