/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.frontenddefinition;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.reconfigure.frontenddefinition.DynamicFragmentProvider;
import de.resolution.reconfigure.frontenddefinition.FrontendDefinitionLoadException;
import de.resolution.reconfigure.frontenddefinition.JavascriptFunctionModel;
import de.resolution.reconfigure.frontenddefinition.StringLoader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class FrontendDefinitionLoader {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public static final Pattern INCLUDE_PATTERN = Pattern.compile("\\{[\\s]*\"includeFragment\"[\\s]*:[\\s]*\"(.*)\"[\\s]*}");
    public static final Pattern INCLUDE_DYNAMIC_PATTERN = Pattern.compile("\\{[\\s]*\"includeDynamicFragment\"[\\s]*:[\\s]*\"(.*)\"[\\s]*}");
    public static final Pattern INCLUDE_STRING = Pattern.compile("\\{[\\s]*\"includeFragmentAsString\"[\\s]*:[\\s]*\"(.*)\"[\\s]*}");
    public static final Pattern INCLUDE_JAVASCRIPT_FUNCTION = Pattern.compile("\\{[\\s]*\"includeJavascriptFunction\"[\\s]*:[\\s]*\"(.*)\"[\\s]*}");
    public static final Pattern JAVASCRIPT_FUNCTION = Pattern.compile("^\\s*function\\s+([a-zA-Z][a-zA-Z0-9_]*)\\s*\\(([a-zA-Z0-9_, ]*)\\)\\s*\\{\\s*(.*)\\s*}\\s*$", 32);

    private FrontendDefinitionLoader() {
    }

    public static String loadFrontendDefinition(String filename, StringLoader stringLoader, @Nullable DynamicFragmentProvider dynamicFragmentProvider) {
        return FrontendDefinitionLoader.loadFrontendDefinition(filename, stringLoader, dynamicFragmentProvider, Collections.emptyMap());
    }

    public static String loadFrontendDefinition(String filename, StringLoader stringLoader, @Nullable DynamicFragmentProvider dynamicFragmentProvider, Map<String, String> hashReplacements) {
        String data = stringLoader.load(filename);
        if (dynamicFragmentProvider == null) {
            dynamicFragmentProvider = new DynamicFragmentProvider.NullDynamicFragmentProvider();
        }
        return FrontendDefinitionLoader.doLoadFrontendDefinition(data, stringLoader, new HashSet<String>(), dynamicFragmentProvider, new HashSet<String>(), hashReplacements);
    }

    private static String doLoadFrontendDefinition(String data, StringLoader stringLoader, Set<String> seenFilenames, DynamicFragmentProvider dynamicFragmentProvider, Set<String> seenDynamicIdentifiers, Map<String, String> hashReplacements) {
        data = FrontendDefinitionLoader.replaceHashReplacements(data, hashReplacements);
        Matcher includeMatcher = INCLUDE_PATTERN.matcher(data);
        StringBuffer sbForInclude = new StringBuffer();
        boolean foundIncludes = false;
        while (includeMatcher.find()) {
            foundIncludes = true;
            if (includeMatcher.groupCount() != 1) {
                throw new FrontendDefinitionLoadException("no identifier found");
            }
            String currentIdentifier = includeMatcher.group(1);
            if (seenFilenames.contains(currentIdentifier)) {
                includeMatcher.appendReplacement(sbForInclude, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment("Already seen filename " + currentIdentifier)));
                continue;
            }
            try {
                String currentData = stringLoader.load(currentIdentifier);
                if (currentData == null) {
                    includeMatcher.appendReplacement(sbForInclude, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment("Failed to load file " + currentIdentifier)));
                    continue;
                }
                HashSet<String> currentlySeenFilenames = new HashSet<String>(seenFilenames);
                currentlySeenFilenames.add(currentIdentifier);
                String dataToReplace = FrontendDefinitionLoader.doLoadFrontendDefinition(currentData, stringLoader, currentlySeenFilenames, dynamicFragmentProvider, seenDynamicIdentifiers, hashReplacements);
                includeMatcher.appendReplacement(sbForInclude, Matcher.quoteReplacement(dataToReplace));
            }
            catch (Exception e) {
                includeMatcher.appendReplacement(sbForInclude, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment(e.getMessage())));
            }
        }
        includeMatcher.appendTail(sbForInclude);
        String dataAfterInclude = foundIncludes ? sbForInclude.toString() : data;
        Matcher includeDynamicMatcher = INCLUDE_DYNAMIC_PATTERN.matcher(dataAfterInclude);
        StringBuffer sbForDynamic = new StringBuffer();
        boolean foundDynamic = false;
        while (includeDynamicMatcher.find()) {
            foundDynamic = true;
            if (includeDynamicMatcher.groupCount() != 1) {
                throw new FrontendDefinitionLoadException("no identifier found");
            }
            String currentIdentifier = includeDynamicMatcher.group(1);
            if (seenDynamicIdentifiers.contains(currentIdentifier)) {
                includeDynamicMatcher.appendReplacement(sbForInclude, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment("Already seen fragment identifier " + currentIdentifier)));
                continue;
            }
            String currentData = dynamicFragmentProvider.provideFragment(currentIdentifier);
            if (currentData == null) {
                includeDynamicMatcher.appendReplacement(sbForDynamic, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment("Failed to load dynamic fragment " + currentIdentifier)));
                continue;
            }
            HashSet<String> currentlySeenDynamicIdentifiers = new HashSet<String>(seenDynamicIdentifiers);
            currentlySeenDynamicIdentifiers.add(currentIdentifier);
            String dataToReplace = FrontendDefinitionLoader.doLoadFrontendDefinition(currentData, stringLoader, seenFilenames, dynamicFragmentProvider, currentlySeenDynamicIdentifiers, hashReplacements);
            includeDynamicMatcher.appendReplacement(sbForDynamic, Matcher.quoteReplacement(dataToReplace));
        }
        includeDynamicMatcher.appendTail(sbForDynamic);
        String dataAfterDynamic = foundDynamic ? sbForDynamic.toString() : dataAfterInclude;
        Matcher includeStringMatcher = INCLUDE_STRING.matcher(dataAfterDynamic);
        StringBuffer sbForString = new StringBuffer();
        boolean foundString = false;
        while (includeStringMatcher.find()) {
            foundString = true;
            if (includeStringMatcher.groupCount() != 1) {
                throw new FrontendDefinitionLoadException("no identifier found for string");
            }
            String currentIdentifier = includeStringMatcher.group(1);
            if (seenFilenames.contains(currentIdentifier)) {
                includeStringMatcher.appendReplacement(sbForString, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment("Already seen filename " + currentIdentifier)));
                continue;
            }
            try {
                String currentData = stringLoader.load(currentIdentifier);
                if (currentData == null) {
                    includeStringMatcher.appendReplacement(sbForString, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment("Failed to load file with string " + currentIdentifier)));
                    continue;
                }
                includeStringMatcher.appendReplacement(sbForString, Matcher.quoteReplacement(objectMapper.writeValueAsString(currentData)));
            }
            catch (Exception e) {
                includeStringMatcher.appendReplacement(sbForString, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment(e.getMessage())));
            }
        }
        includeStringMatcher.appendTail(sbForString);
        String dataAfterString = foundString ? sbForString.toString() : dataAfterDynamic;
        Matcher includeJavascriptFunctionMatcher = INCLUDE_JAVASCRIPT_FUNCTION.matcher(dataAfterString);
        StringBuffer sbForJavascriptFunction = new StringBuffer();
        boolean foundJavascriptFunction = false;
        while (includeJavascriptFunctionMatcher.find()) {
            foundJavascriptFunction = true;
            if (includeJavascriptFunctionMatcher.groupCount() != 1) {
                throw new FrontendDefinitionLoadException("no identifier found for javascriptFunction");
            }
            String currentIdentifier = includeJavascriptFunctionMatcher.group(1);
            if (seenFilenames.contains(currentIdentifier)) {
                includeJavascriptFunctionMatcher.appendReplacement(sbForJavascriptFunction, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment("Already seen filename " + currentIdentifier)));
                continue;
            }
            try {
                String currentData = stringLoader.load(currentIdentifier);
                if (currentData == null) {
                    includeJavascriptFunctionMatcher.appendReplacement(sbForJavascriptFunction, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment("Failed to load file with javascriptFunction " + currentIdentifier)));
                    continue;
                }
                includeJavascriptFunctionMatcher.appendReplacement(sbForJavascriptFunction, Matcher.quoteReplacement(FrontendDefinitionLoader.parseJavascriptFunctionFile(currentData)));
            }
            catch (Exception e) {
                includeJavascriptFunctionMatcher.appendReplacement(sbForJavascriptFunction, Matcher.quoteReplacement(FrontendDefinitionLoader.createMessageFragment(e.getMessage())));
            }
        }
        includeJavascriptFunctionMatcher.appendTail(sbForJavascriptFunction);
        return foundJavascriptFunction ? sbForJavascriptFunction.toString() : dataAfterString;
    }

    private static String parseJavascriptFunctionFile(String fileContent) throws IOException {
        Matcher matcher = JAVASCRIPT_FUNCTION.matcher(fileContent);
        if (!matcher.matches()) {
            return FrontendDefinitionLoader.createMessageFragment("File does not match Javascript function file format required for automatic parsing. Please check the refapp or docs.");
        }
        String name = matcher.group(1).trim();
        String[] args2 = matcher.group(2).split("\\s*,\\s*");
        String code = matcher.group(3).trim();
        JavascriptFunctionModel javascriptFunctionModel = new JavascriptFunctionModel(name, args2, code);
        return objectMapper.writeValueAsString(javascriptFunctionModel);
    }

    private static String replaceHashReplacements(String data, Map<String, String> hashReplacements) {
        for (Map.Entry<String, String> entry : hashReplacements.entrySet()) {
            String key = "#" + entry.getKey() + "#";
            data = data.replace(key, entry.getValue());
        }
        return data;
    }

    private static String createMessageFragment(String content) {
        return "{ \"type\": \"paragraph\",\n \"content\": \"" + content + "\" }";
    }
}

