/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringUtil {
    private StringUtil() {
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    @Nullable
    public static String sanitize(@Nullable String stringToSanitize) {
        if (stringToSanitize == null) {
            return null;
        }
        return stringToSanitize.replaceAll("[\n\r\t]", "_");
    }

    @Nullable
    public static String nullOrToLowerCase(@Nullable String str) {
        if (str != null) {
            return str.toLowerCase();
        }
        return null;
    }

    @Nonnull
    public static String truncateStacktrace(@Nonnull Throwable throwable, int headCount, int tailCount) {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String[] lines = sw.toString().split("\n");
        StringBuilder truncated = new StringBuilder();
        for (i = 0; i < Math.min(headCount, lines.length); ++i) {
            truncated.append(lines[i]).append("\n");
        }
        if (lines.length > headCount + tailCount) {
            truncated.append("\n... ").append(lines.length - headCount - tailCount).append(" more\n");
        }
        for (i = Math.max(headCount, lines.length - tailCount); i < lines.length; ++i) {
            truncated.append(lines[i]).append("\n");
        }
        return truncated.toString();
    }

    @Nonnull
    public static String stackTraceToString(@Nonnull Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }
}

