/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.communardo;

import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.resolution.atlasuser.api.exception.AtlasUserRuntimeException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.atlasuser.impl.user.communardo.CommunardoUserProfileAdapter;
import de.resolution.atlasuser.impl.user.communardo.CommunardoUserProfileAdapterImpl;
import de.resolution.atlasuser.impl.user.communardo.NoOpCommunardoUserProfileAdapter;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelegatingCommunardoProfileAdapter
implements CommunardoUserProfileAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingCommunardoProfileAdapter.class);
    private final NoOpCommunardoUserProfileAdapter noOpCommunardoUserProfileAdapter = new NoOpCommunardoUserProfileAdapter();
    private TransactionTemplate transactionTemplate;
    private ServiceTracker<?, ?> dataMgrTracker;
    private ServiceTracker<?, ?> mgrTracker;
    private CommunardoUserProfileAdapter delegate = this.noOpCommunardoUserProfileAdapter;

    protected void init(@Nullable OsgiContainerManager osgiContainerManager, TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
        if (osgiContainerManager == null) {
            throw new AtlasUserRuntimeException("Could not load OsgiContainerManager");
        }
        this.dataMgrTracker = osgiContainerManager.getServiceTracker("de.communardo.atlassian.plugins.userprofile.external.api.service.UppProfileElementDataManager");
        this.mgrTracker = osgiContainerManager.getServiceTracker("de.communardo.atlassian.plugins.userprofile.external.api.service.UppProfileElementManager");
        if (this.dataMgrTracker == null || this.mgrTracker == null) {
            throw new AtlasUserRuntimeException("Service Tracker for UppProfileElementManager or UppProfileElementDataManager is null");
        }
        this.updateDelegate(null);
    }

    private void updateDelegate(@Nullable AtlasUserResultBuilder atlasUserResultBuilder) {
        if (this.delegate instanceof CommunardoUserProfileAdapterImpl && (this.mgrTracker.size() == 0 || this.dataMgrTracker.size() == 0)) {
            logger.warn("Communardo User Profile Plugin seems not available, switching to NoOp-implementation.");
            if (atlasUserResultBuilder != null) {
                atlasUserResultBuilder.addMessage("CommunardoUserProfileAdapter is not available, falling back to NoOp-implementation.");
            }
            this.delegate = this.noOpCommunardoUserProfileAdapter;
        } else if (this.delegate instanceof NoOpCommunardoUserProfileAdapter && this.mgrTracker.size() > 0 && this.dataMgrTracker.size() > 0) {
            logger.info("Communardo User Profile Plugin seems available, switching to real implementation");
            try {
                this.delegate = new CommunardoUserProfileAdapterImpl(this.transactionTemplate, this.mgrTracker, this.dataMgrTracker);
            }
            catch (NoClassDefFoundError e) {
                logger.error("#### Failed to load CommunardoUserProfileAdapter, falling back to NoOp-implementation, see https://wiki.resolution.de/go/UppReinstall");
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to load CommunardoUserProfileAdapter", (Throwable)e);
                }
                if (atlasUserResultBuilder != null) {
                    atlasUserResultBuilder.addMessage("NoClassDefFoundError loading CommunardoUserProfileAdapter, falling back to NoOp-Implementation");
                }
                this.delegate = this.noOpCommunardoUserProfileAdapter;
            }
        } else {
            logger.debug("No need to change the delegate");
        }
    }

    @Override
    public AtlasUserBuilder readProfileAttributes(@Nonnull String userKey, @Nonnull AtlasUserBuilder atlasUserBuilder) {
        this.updateDelegate(null);
        return this.delegate.readProfileAttributes(userKey, atlasUserBuilder);
    }

    @Override
    public AtlasUserResultBuilder updateProfileAttributes(@Nonnull String userKey, @Nonnull AtlasUser atlasUser, @Nonnull AtlasUserResultBuilder atlasUserResultBuilder, @Nullable AtlasUserBuilder simulatedResultingUserBuilder) {
        this.updateDelegate(atlasUserResultBuilder);
        return this.delegate.updateProfileAttributes(userKey, atlasUser, atlasUserResultBuilder, simulatedResultingUserBuilder);
    }

    @Override
    public Map<Integer, String> getAvailableAttributes() {
        this.updateDelegate(null);
        return this.delegate.getAvailableAttributes();
    }
}

