/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.bitbucket;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import de.resolution.atlasuser.api.user.ApplicationAccessAdapter;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
public class BitbucketApplicationAccessAdapter
implements ApplicationAccessAdapter {
    private final PermissionService permissionService;

    @Autowired
    public BitbucketApplicationAccessAdapter(@BitbucketComponent PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    @Nonnull
    public Set<String> getAvailableApplicationKeys() {
        return Collections.singleton("stash");
    }

    @Override
    @Nonnull
    public Set<String> getGroupsGivingAccess(String applicationKey) {
        if (Objects.equals("stash", applicationKey) || Objects.equals("ANY_APPLICATION", applicationKey)) {
            PageRequestImpl pageRequest = new PageRequestImpl(0, 0x100000);
            Page page = this.permissionService.getGrantedGroups(Permission.LICENSED_USER, (PageRequest)pageRequest);
            return page.stream().collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    @Nonnull
    public Set<String> getUsersWithDirectAccess(String applicationKey) {
        if (Objects.equals("stash", applicationKey) || Objects.equals("ANY_APPLICATION", applicationKey)) {
            PageRequestImpl pageRequest = new PageRequestImpl(0, 0x100000);
            Page page = this.permissionService.getGrantedUsers(Permission.LICENSED_USER, (PageRequest)pageRequest);
            return page.stream().map(Person::getName).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

