/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.exception.AtlasUserRuntimeException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.DiffUtil;
import de.resolution.atlasuser.impl.ExceptionInfoImpl;
import de.resolution.atlasuser.impl.user.ImmutableAtlasUser;
import de.resolution.atlasuser.impl.user.ImmutableAtlasUserReference;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class ImmutableAtlasUserResult
implements AtlasUserResult {
    private final AtlasUserReference reference;
    private final boolean modified;
    private final long timestamp;
    private final boolean simulated;
    private final AtlasUserResult.Operation operation;
    private final AtlasUser inputUser;
    private final AtlasUser initialUser;
    private final AtlasUser resultingUser;
    private final JsonNode diff;
    private final AtlasUserResult.ErrorType errorType;
    private final List<String> messages;
    private final ExceptionInfo exceptionInfo;
    private final ImmutableAtlasUserResult removeInOtherResult;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    static ImmutableAtlasUserResult from(AtlasUserResult other) {
        if (other == null) {
            return null;
        }
        if (other instanceof ImmutableAtlasUserResult) {
            return (ImmutableAtlasUserResult)other;
        }
        return new ImmutableAtlasUserResult(other.getReference(), other.isSimulated(), other.getOperation(), other.getInputUser().orElse(null), other.getInitialUser().orElse(null), other.getResultingUser().orElse(null), other.getErrorType(), other.getMessages().orElse(null), other.getExceptionInfo().orElse(null), ImmutableAtlasUserResult.from(other.getRemoveInOtherResult().orElse(null)));
    }

    ImmutableAtlasUserResult(@Nonnull AtlasUserReference reference, boolean simulated, @Nonnull AtlasUserResult.Operation operation, @Nullable AtlasUser inputUser, @Nullable AtlasUser initialUser, @Nullable AtlasUser resultingUser, @Nonnull AtlasUserResult.ErrorType errorType, @Nullable List<String> messages, @Nullable ExceptionInfo exceptionInfo, @Nullable ImmutableAtlasUserResult removeInOtherResult) {
        this.reference = reference;
        this.simulated = simulated;
        this.inputUser = inputUser;
        this.initialUser = initialUser;
        this.resultingUser = resultingUser;
        this.operation = operation;
        this.errorType = errorType;
        this.messages = messages;
        this.exceptionInfo = exceptionInfo;
        this.removeInOtherResult = removeInOtherResult;
        this.timestamp = System.currentTimeMillis();
        this.modified = AtlasUserResult.isModified(operation);
        this.diff = DiffUtil.diff(initialUser, resultingUser);
    }

    @JsonCreator
    public ImmutableAtlasUserResult(@JsonProperty(value="reference") @Nonnull ImmutableAtlasUserReference reference, @JsonProperty(value="simulated") @Nullable Boolean simulatedParam, @JsonProperty(value="operation") @Nonnull AtlasUserResult.Operation operation, @JsonProperty(value="inputUser") @Nullable ImmutableAtlasUser inputUser, @JsonProperty(value="initialUser") @Nullable ImmutableAtlasUser initialUser, @JsonProperty(value="resultingUser") @Nullable ImmutableAtlasUser resultingUser, @JsonProperty(value="errorType") @Nonnull AtlasUserResult.ErrorType errorType, @JsonProperty(value="messages") @Nullable List<String> messages, @JsonProperty(value="exceptionInfo") @Nullable ExceptionInfoImpl exceptionInfo, @JsonProperty(value="modified") boolean modified, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="removeInOtherResult") @Nullable ImmutableAtlasUserResult removeInOtherResult) {
        this.simulated = simulatedParam != null ? simulatedParam : false;
        this.operation = operation;
        this.errorType = errorType;
        this.reference = reference;
        this.inputUser = inputUser;
        this.initialUser = initialUser;
        this.resultingUser = resultingUser;
        this.messages = messages;
        this.exceptionInfo = exceptionInfo;
        this.modified = modified;
        this.timestamp = timestamp;
        this.removeInOtherResult = removeInOtherResult;
        this.diff = DiffUtil.diff(initialUser, resultingUser);
    }

    public static ImmutableAtlasUserResult fromJson(String json) {
        try {
            return objectMapper.readValue(json, ImmutableAtlasUserResult.class);
        }
        catch (IOException e) {
            throw new AtlasUserRuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public AtlasUserReference getReference() {
        return this.reference;
    }

    @Override
    @Nonnull
    public AtlasUserResult.Operation getOperation() {
        return this.operation;
    }

    @Override
    @Nonnull
    public Optional<AtlasUser> getInputUser() {
        return Optional.ofNullable(this.inputUser);
    }

    @Override
    @Nonnull
    public Optional<AtlasUser> getInitialUser() {
        return Optional.ofNullable(this.initialUser);
    }

    @Override
    @Nonnull
    public Optional<AtlasUser> getResultingUser() {
        return Optional.ofNullable(this.resultingUser);
    }

    @Override
    @Nonnull
    public Optional<ExceptionInfo> getExceptionInfo() {
        return Optional.ofNullable(this.exceptionInfo);
    }

    @Override
    @Nonnull
    public Optional<List<String>> getMessages() {
        return Optional.ofNullable(this.messages);
    }

    @Override
    @Nonnull
    public AtlasUserResult.ErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    @Nonnull
    public Optional<AtlasUserResult> getRemoveInOtherResult() {
        return Optional.ofNullable(this.removeInOtherResult);
    }

    @Override
    public boolean isSimulated() {
        return this.simulated;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    @JsonIgnore
    public boolean isNotFound() {
        return this.errorType == AtlasUserResult.ErrorType.NOT_FOUND;
    }

    @Override
    @JsonIgnore
    public boolean isSuccess() {
        return this.operation != AtlasUserResult.Operation.FAILED;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Nonnull
    public Optional<JsonNode> getDiff() {
        return Optional.ofNullable(this.diff);
    }
}

