/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.group;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.NestedGroupsNotSupportedException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.InvalidSearchFilterException;
import de.resolution.atlasuser.api.group.AtlasGroup;
import de.resolution.atlasuser.api.group.AtlasGroupAdapter;
import de.resolution.atlasuser.api.group.AtlasGroupReference;
import de.resolution.atlasuser.api.group.AtlasGroupResult;
import de.resolution.atlasuser.api.group.GroupSearchResult;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.api.user.SearchFilter;
import de.resolution.atlasuser.api.user.SortBy;
import de.resolution.atlasuser.api.user.UserSearchResult;
import de.resolution.atlasuser.impl.SimpleCancelHandle;
import de.resolution.atlasuser.impl.group.AtlasGroupBuilder;
import de.resolution.atlasuser.impl.group.AtlasGroupResultBuilder;
import de.resolution.atlasuser.impl.group.CrowdApiAtlasGroupCreator;
import de.resolution.commons.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={AtlasGroupAdapter.class})
public class CrowdApiAtlasGroupAdapter
implements AtlasGroupAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CrowdApiAtlasGroupAdapter.class);
    protected static final List<String> SPECIAL_ATTRIBUTES = Arrays.asList("ATTR_GROUPNAME", "ATTR_CREATE_GROUPS_WITH_TAGS");
    private final CrowdApiAtlasGroupCreator crowdApiAtlasGroupCreator;
    private final AtlasUserAdapter atlasUserAdapter;
    private final DirectoryAdapter directoryAdapter;
    private final DirectoryManager directoryManager;

    @Autowired
    public CrowdApiAtlasGroupAdapter(CrowdApiAtlasGroupCreator crowdApiAtlasGroupCreator, AtlasUserAdapter atlasUserAdapter, DirectoryAdapter directoryAdapter, @ComponentImport DirectoryManager directoryManager) {
        this.crowdApiAtlasGroupCreator = crowdApiAtlasGroupCreator;
        this.atlasUserAdapter = atlasUserAdapter;
        this.directoryAdapter = directoryAdapter;
        this.directoryManager = directoryManager;
    }

    @Override
    @Nonnull
    public AtlasGroupResult read(@Nonnull AtlasGroupReference reference) {
        AtlasGroupResultBuilder resultBuilder = AtlasGroupResult.builder(reference);
        try {
            GroupWithAttributes group = this.directoryManager.findGroupWithAttributesByName(reference.getDirectoryId(), reference.getGroupName());
            resultBuilder.resultingGroup(CrowdApiAtlasGroupAdapter.buildAtlasGroup(group));
        }
        catch (GroupNotFoundException e) {
            resultBuilder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e));
        }
        return resultBuilder.build();
    }

    @Override
    @Nonnull
    public AtlasGroupResult create(@Nonnull AtlasGroup atlasGroup) {
        return this.crowdApiAtlasGroupCreator.create(atlasGroup);
    }

    @Override
    @Nonnull
    public AtlasGroupResult update(@Nonnull AtlasGroup atlasGroup) {
        AtlasGroupResultBuilder resultBuilder = AtlasGroupResult.builder(atlasGroup.getReference()).inputGroup(atlasGroup);
        try {
            this.findGroup(atlasGroup.getReference());
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        catch (GroupNotFoundException e) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).errorString(String.format("%s does not exist", atlasGroup.getReference())).build();
        }
        try {
            GroupWithAttributes initialGroup = this.findGroup(atlasGroup.getReference());
            resultBuilder.initialGroup(CrowdApiAtlasGroupAdapter.buildAtlasGroup(initialGroup));
            resultBuilder = this.crowdApiAtlasGroupCreator.updateCrowdAttributes(initialGroup, atlasGroup, Collections.emptySet(), resultBuilder);
            GroupWithAttributes reloadedGroup = this.findGroup(atlasGroup.getReference());
            resultBuilder.resultingGroup(CrowdApiAtlasGroupAdapter.buildAtlasGroup(reloadedGroup));
            resultBuilder.operation(AtlasGroupResult.Operation.UPDATED);
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException e) {
            resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e));
        }
        return resultBuilder.build();
    }

    @Override
    @Nonnull
    public AtlasGroupResult createOrUpdate(@Nonnull AtlasGroup atlasGroup) {
        AtlasGroupResult read = this.read(atlasGroup.getReference());
        if (read.isSuccess() && read.getResultingGroup().isPresent()) {
            return this.update(atlasGroup);
        }
        return this.create(atlasGroup);
    }

    @Nonnull
    private GroupWithAttributes findGroup(AtlasGroupReference groupReference) throws DirectoryNotFoundException, OperationFailedException, GroupNotFoundException {
        return this.directoryManager.findGroupWithAttributesByName(groupReference.getDirectoryId(), groupReference.getGroupName());
    }

    @Override
    @Nonnull
    public AtlasGroupResult delete(@Nonnull AtlasGroupReference reference) {
        AtlasGroupResultBuilder resultBuilder = AtlasGroupResult.builder(reference);
        try {
            this.findGroup(reference);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        catch (GroupNotFoundException e) {
            return resultBuilder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).errorString(String.format("%s does not exist", reference)).build();
        }
        try {
            this.directoryManager.removeGroup(reference.getDirectoryId(), reference.getGroupName());
            resultBuilder.operation(AtlasGroupResult.Operation.DELETED);
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException | ReadOnlyGroupException | DirectoryPermissionException e) {
            resultBuilder.exceptionInfo(ExceptionInfo.from(e));
        }
        return resultBuilder.build();
    }

    @Override
    public boolean groupExists(AtlasGroupReference groupReference) throws AtlasUserOperationFailedException {
        try {
            this.findGroup(groupReference);
            return true;
        }
        catch (DirectoryNotFoundException | GroupNotFoundException e) {
            return false;
        }
        catch (OperationFailedException e) {
            throw new AtlasUserOperationFailedException(e);
        }
    }

    @Nonnull
    public static AtlasGroup buildAtlasGroup(@Nonnull GroupWithAttributes group) {
        AtlasGroupBuilder builder = AtlasGroup.builder().findBy(AtlasGroupReference.create(group.getName(), group.getDirectoryId()));
        builder.groupName(group.getName());
        for (String key : group.getKeys()) {
            Set values2 = group.getValues(key);
            if (values2 == null || values2.isEmpty()) continue;
            builder.with(key, values2);
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public GroupSearchResult search(int startIndex, int count, long directoryId, @Nullable SearchRestriction searchRestriction, @Nullable Set<String> requiredAttributes, @Nullable Set<String> mustNotContainAttributes) throws AtlasUserOperationFailedException {
        List totalGroupsInDirectory;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (count <= 0) {
            count = 1000;
        }
        EntityQuery groupQuery = searchRestriction != null ? QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group(), (SearchRestriction)searchRestriction, (int)0, (int)Integer.MAX_VALUE) : QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            totalGroupsInDirectory = this.directoryManager.searchGroups(directoryId, groupQuery);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new AtlasUserOperationFailedException(e);
        }
        List allTheGroupsBeforeFiltering = totalGroupsInDirectory.stream().sorted().map(groupName -> this.read(AtlasGroupReference.create(groupName, directoryId))).filter(atlasGroupResult -> atlasGroupResult.getResultingGroup().isPresent()).map(atlasGroupResult -> atlasGroupResult.getResultingGroup().get()).collect(Collectors.toList());
        if (!CollectionUtil.isNullOrEmpty(requiredAttributes)) {
            allTheGroupsBeforeFiltering = allTheGroupsBeforeFiltering.stream().filter(atlasGroup -> atlasGroup.getAttributeKeys().containsAll(requiredAttributes)).collect(Collectors.toList());
        }
        if (!CollectionUtil.isNullOrEmpty(mustNotContainAttributes)) {
            allTheGroupsBeforeFiltering = allTheGroupsBeforeFiltering.stream().filter(atlasGroup -> !atlasGroup.getAttributeKeys().containsAll(mustNotContainAttributes)).collect(Collectors.toList());
        }
        List<AtlasGroup> atlasGroups = allTheGroupsBeforeFiltering.stream().skip(startIndex).limit(count).collect(Collectors.toList());
        return new GroupSearchResult(startIndex, totalGroupsInDirectory.size() != allTheGroupsBeforeFiltering.size() ? allTheGroupsBeforeFiltering.size() : totalGroupsInDirectory.size(), atlasGroups);
    }

    @Override
    @Nonnull
    public UserSearchResult getDirectMemberships(@Nonnull AtlasGroupReference groupReference) throws AtlasUserOperationFailedException, de.resolution.atlasuser.api.exception.DirectoryNotFoundException, InvalidSearchFilterException {
        SearchFilter searchFilter = SearchFilter.builder().inGroups(groupReference.getGroupName()).directoryId(groupReference.getDirectoryId()).build();
        return this.atlasUserAdapter.search(searchFilter, SortBy.name(), new SimpleCancelHandle());
    }

    @Override
    public boolean isUserInGroup(@Nonnull AtlasUserReference userReference, @Nonnull AtlasGroupReference groupReference) {
        String username;
        if ("ATTR_NAME".equals(userReference.getFindByAttributeName())) {
            username = userReference.getFindByAttributeValue();
        } else {
            AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(userReference);
            Optional<AtlasUser> optionalResultingUser = atlasUserResult.getResultingUser();
            if (atlasUserResult.getOperation() != AtlasUserResult.Operation.FAILED && optionalResultingUser.isPresent()) {
                AtlasUser atlasUser = optionalResultingUser.get();
                username = atlasUser.getName();
            } else {
                logger.debug("Checking group relation failed, user {} not found", (Object)userReference);
                return false;
            }
        }
        try {
            return this.directoryManager.isUserDirectGroupMember(groupReference.getDirectoryId(), username, groupReference.getGroupName());
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            logger.debug("Checking group relation failed", e);
            return false;
        }
    }

    @Override
    @Nonnull
    public AtlasGroupResult addUserToGroup(@Nonnull AtlasUserReference userReference, @Nonnull AtlasGroupReference groupReference) {
        AtlasGroupResultBuilder builder = new AtlasGroupResultBuilder(groupReference);
        AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(userReference);
        Optional<AtlasUser> optionalResultingUser = atlasUserResult.getResultingUser();
        if (atlasUserResult.getOperation() == AtlasUserResult.Operation.FAILED || !optionalResultingUser.isPresent()) {
            return builder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).addMessage("User <" + userReference.getFindByAttributeName() + ":" + userReference.getFindByAttributeValue() + "> does not exist").build();
        }
        String username = optionalResultingUser.get().getName();
        try {
            this.findGroup(groupReference);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        catch (GroupNotFoundException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).addMessage("Group does not exist").build();
        }
        try {
            this.directoryManager.addUserToGroup(groupReference.getDirectoryId(), username, groupReference.getGroupName());
        }
        catch (MembershipAlreadyExistsException e) {
            return builder.operation(AtlasGroupResult.Operation.NOT_MODIFIED).addMessage(e.getMessage()).build();
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        AtlasGroupResult reloadedGroup = this.read(groupReference);
        Optional<AtlasGroup> reloadedOptionalResultingGroup = reloadedGroup.getResultingGroup();
        if (!reloadedGroup.isSuccess() || !reloadedOptionalResultingGroup.isPresent()) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).addMessage("Could not reload group after assigning user").build();
        }
        builder.operation(AtlasGroupResult.Operation.MEMBER_ADDED);
        builder.resultingGroup(reloadedOptionalResultingGroup.get());
        return builder.build();
    }

    @Override
    @Nonnull
    public AtlasGroupResult removeUserFromGroup(@Nonnull AtlasUserReference userReference, @Nonnull AtlasGroupReference groupReference) {
        AtlasGroupResultBuilder builder = new AtlasGroupResultBuilder(groupReference);
        AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(userReference);
        Optional<AtlasUser> optionalResultingUser = atlasUserResult.getResultingUser();
        if (atlasUserResult.getOperation() == AtlasUserResult.Operation.FAILED || !optionalResultingUser.isPresent()) {
            return builder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).addMessage("User does not exist").build();
        }
        String username = optionalResultingUser.get().getName();
        try {
            this.findGroup(groupReference);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        catch (GroupNotFoundException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).addMessage("Group does not exist").build();
        }
        try {
            this.directoryManager.removeUserFromGroup(groupReference.getDirectoryId(), username, groupReference.getGroupName());
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | MembershipNotFoundException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        AtlasGroupResult reloadedGroup = this.read(groupReference);
        Optional<AtlasGroup> reloadedOptionalResultingGroup = reloadedGroup.getResultingGroup();
        if (!reloadedGroup.isSuccess() || !reloadedOptionalResultingGroup.isPresent()) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).addMessage("Could not reload group after assigning user").build();
        }
        builder.operation(AtlasGroupResult.Operation.MEMBER_REMOVED);
        builder.resultingGroup(reloadedOptionalResultingGroup.get());
        return builder.build();
    }

    @Override
    @Nonnull
    public GroupSearchResult getSubGroupsOf(@Nonnull AtlasGroupReference parentGroupReference) {
        long directoryId = parentGroupReference.getDirectoryId();
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(parentGroupReference.getGroupName()).returningAtMost(Integer.MAX_VALUE);
        try {
            List groups2 = this.directoryManager.searchNestedGroupRelationships(directoryId, query);
            List<AtlasGroup> atlasGroups = groups2.stream().sorted().map(group -> AtlasGroup.builder().findBy(AtlasGroupReference.create(group.getName(), directoryId)).groupName(group.getName()).build()).collect(Collectors.toList());
            return new GroupSearchResult(0, groups2.size(), atlasGroups);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return new GroupSearchResult((Exception)e);
        }
    }

    @Override
    @Nonnull
    public AtlasGroupResult addGroupToGroup(@Nonnull AtlasGroupReference childGroupReference, @Nonnull AtlasGroupReference parentGroupReference) {
        return this.modifyGroupRelation(childGroupReference, parentGroupReference, NestedGroupOperation.ADD_CHILD_GROUP);
    }

    @Override
    @Nonnull
    public AtlasGroupResult removeGroupFromGroup(@Nonnull AtlasGroupReference childGroupReference, @Nonnull AtlasGroupReference parentGroupReference) {
        return this.modifyGroupRelation(childGroupReference, parentGroupReference, NestedGroupOperation.REMOVE_CHILD_GROUP);
    }

    @Nonnull
    private AtlasGroupResult modifyGroupRelation(@Nonnull AtlasGroupReference childGroupReference, @Nonnull AtlasGroupReference parentGroupReference, @Nonnull NestedGroupOperation operation) {
        AtlasGroupResultBuilder builder = new AtlasGroupResultBuilder(parentGroupReference);
        if (!this.directoryAdapter.isUseNestedGroups(parentGroupReference.getDirectoryId())) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).addMessage("Directory " + parentGroupReference + " does not support nested groups").build();
        }
        try {
            this.findGroup(parentGroupReference);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        catch (GroupNotFoundException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).addMessage("Group " + parentGroupReference.getGroupName() + " does not exist").build();
        }
        try {
            this.findGroup(childGroupReference);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        catch (GroupNotFoundException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.NOT_FOUND).addMessage("Group " + childGroupReference.getGroupName() + " does not exist").build();
        }
        try {
            switch (operation) {
                case ADD_CHILD_GROUP: {
                    this.directoryManager.addGroupToGroup(childGroupReference.getDirectoryId(), childGroupReference.getGroupName(), parentGroupReference.getGroupName());
                    break;
                }
                case REMOVE_CHILD_GROUP: {
                    this.directoryManager.removeGroupFromGroup(parentGroupReference.getDirectoryId(), childGroupReference.getGroupName(), parentGroupReference.getGroupName());
                    break;
                }
                default: {
                    return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).errorString("Operation not supported").build();
                }
            }
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | InvalidMembershipException | MembershipAlreadyExistsException | MembershipNotFoundException | NestedGroupsNotSupportedException | OperationFailedException | ReadOnlyGroupException | DirectoryPermissionException e) {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).build();
        }
        AtlasGroupResult reloadedGroup = this.read(parentGroupReference);
        Optional<AtlasGroup> reloadedOptionalResultingGroup = reloadedGroup.getResultingGroup();
        if (reloadedGroup.isSuccess() && reloadedOptionalResultingGroup.isPresent()) {
            switch (operation) {
                case ADD_CHILD_GROUP: {
                    builder.operation(AtlasGroupResult.Operation.MEMBER_ADDED);
                    break;
                }
                case REMOVE_CHILD_GROUP: {
                    builder.operation(AtlasGroupResult.Operation.MEMBER_REMOVED);
                    break;
                }
                default: {
                    return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).errorString("Operation not supported").build();
                }
            }
        } else {
            return builder.errorType(AtlasGroupResult.ErrorType.OPERATION_FAILED).addMessage("Could not reload group after modifying child group").build();
        }
        builder.resultingGroup(reloadedOptionalResultingGroup.get());
        return builder.build();
    }

    private static enum NestedGroupOperation {
        ADD_CHILD_GROUP,
        REMOVE_CHILD_GROUP;

    }
}

