/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.api.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.resolution.atlasuser.impl.user.ImmutableAtlasUserReference;
import java.io.Serializable;
import javax.annotation.Nonnull;

public interface AtlasUserReference
extends Serializable {
    @Nonnull
    public String getFindByAttributeName();

    @Nonnull
    public String getFindByAttributeValue();

    public long getDirectoryId();

    @JsonIgnore
    default public boolean isFindById() {
        return this.getFindByAttributeName().equals("ATTR_ID");
    }

    @JsonIgnore
    default public boolean isFindByName() {
        return this.getFindByAttributeName().equals("ATTR_NAME");
    }

    @JsonIgnore
    default public boolean isFindByEmail() {
        return this.getFindByAttributeName().equals("ATTR_EMAIL");
    }

    @Nonnull
    public static AtlasUserReference create(@Nonnull String findByAttributeName, @Nonnull Object findByAttributeValue, long directoryId) {
        return new ImmutableAtlasUserReference(findByAttributeName, String.valueOf(findByAttributeValue), directoryId);
    }

    @Nonnull
    public static AtlasUserReference byUsername(@Nonnull String username, long directoryId) {
        return AtlasUserReference.create("ATTR_NAME", username, directoryId);
    }
}

