/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl.confluence;

import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import de.resolution.atlasauth.impl.AbstractAuthenticatorHook;
import de.resolution.atlasauth.impl.AuthenticatorHookException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent(value="authenticatorHook")
public class ConfluenceAuthenticatorHook
extends AbstractAuthenticatorHook {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceAuthenticatorHook.class);
    private final DefaultAuthenticator authenticator;
    private final LoginManager loginManager;
    private final CrowdService crowdService;
    private final DirectoryManager directoryManager;

    @Autowired
    public ConfluenceAuthenticatorHook(@ConfluenceImport LoginManager loginManager, @ConfluenceImport CrowdService crowdService, @ConfluenceImport DirectoryManager directoryManager) {
        logger.debug("Creating ConfluenceAuthenticatorHook...");
        this.loginManager = loginManager;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
        Authenticator originalAuthenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (!(originalAuthenticator instanceof DefaultAuthenticator)) {
            this.authenticator = null;
            throw new AuthenticatorHookException("This authenticator of type " + originalAuthenticator.getClass().getCanonicalName() + "is not a DefaultAuthenticator.");
        }
        this.authenticator = (DefaultAuthenticator)originalAuthenticator;
    }

    @Override
    public boolean doAuthoriseUserAndEstablishSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Principal principal, boolean sdCustomerLogin) throws AuthenticatorHookException {
        Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
        if (principal == null) {
            logger.error("Principal must not be null!");
            return false;
        }
        User confluenceUser = this.crowdService.getUser(principal.getName());
        if (confluenceUser == null) {
            throw new AuthenticatorHookException("ConfluenceUser is null");
        }
        if (!this.crowdService.getUser(principal.getName()).isActive()) {
            throw new AuthenticatorHookException("User is not enabled");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Principal name is: %s, class is: %s", principal.getName(), principal.getClass().getCanonicalName()));
        }
        try {
            String DIRECT_LOGIN = "com.atlassian.confluence.login.direct";
            httpServletRequest.setAttribute("com.atlassian.confluence.login.direct", (Object)true);
            String methodName = "authoriseUserAndEstablishSession";
            Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Principal.class};
            Object[] parameters = new Object[]{httpServletRequest, httpServletResponse, principal};
            Method methodToInvoke = authenticatorClass.getDeclaredMethod(methodName, parameterTypes);
            methodToInvoke.setAccessible(true);
            Object returnValue = methodToInvoke.invoke((Object)this.authenticator, parameters);
            if (returnValue instanceof Boolean) {
                boolean authenticated = (Boolean)returnValue;
                if (logger.isDebugEnabled()) {
                    logger.debug("authoriseUserAndEstablishSession returned {}", (Object)authenticated);
                }
                if (authenticated) {
                    this.loginManager.onSuccessfulLoginAttempt(principal.getName(), httpServletRequest);
                    Map<String, Set<String>> attrMap = Collections.singletonMap("lastAuthenticated", Collections.singleton(String.valueOf(new Date().getTime())));
                    try {
                        this.directoryManager.storeUserAttributes(confluenceUser.getDirectoryId(), confluenceUser.getName(), attrMap);
                    }
                    catch (Exception e) {
                        logger.warn("Setting lastAuthenticatedAttribute failed for {}", (Object)principal.getName(), (Object)e);
                    }
                }
                return authenticated;
            }
            throw new AuthenticatorHookException("Authenticator method did not return a boolean, but a " + returnValue.getClass().getCanonicalName());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new AuthenticatorHookException(e);
        }
        catch (InvocationTargetException e) {
            throw new AuthenticatorHookException(e.getCause());
        }
    }

    @Override
    protected DefaultAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

