/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.exception.InvalidOperationException;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.task.api.Task;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.boundedregex.RegexAndReplacement;
import de.resolution.commons.util.boundedregex.RegexAndReplacementResult;
import de.resolution.commons.validate.api.ValidationResultWithId;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.PrivilegeCheckerImpl;
import de.resolution.reconfigure.api.RestfulTableResultEntity;
import de.resolution.reconfigure.cronexpressionrest.CronExpressionValidator;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.usersync.api.CollectionAndTotal;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorFactoryRegistry;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.NotificationService;
import de.resolution.usersync.api.RequiredGroupChecker;
import de.resolution.usersync.api.SupportInformationGenerator;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.SyncUserResultRepository;
import de.resolution.usersync.api.UserSyncService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.api.exception.GeneralSyncException;
import de.resolution.usersync.api.exception.SyncAlreadyRunningException;
import de.resolution.usersync.api.exception.UserFindFailedException;
import de.resolution.usersync.auditlog.UserSyncAuditLogService;
import de.resolution.usersync.builtin.scim.rest.PATCH;
import de.resolution.usersync.impl.HostApplicationAttributeProvider;
import de.resolution.usersync.impl.SyncStatusAoProxy;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.rest.entities.ConnectorConfigurationEntity;
import de.resolution.usersync.rest.entities.ConnectorEntity;
import de.resolution.usersync.rest.entities.CountEntity;
import de.resolution.usersync.rest.entities.CreateConnectorEntity;
import de.resolution.usersync.rest.entities.DirectorySelection;
import de.resolution.usersync.rest.entities.PreviewRequiredGroupsEntity;
import de.resolution.usersync.rest.entities.ReducedSyncStatus;
import de.resolution.usersync.rest.entities.SyncSingleUserEntity;
import de.resolution.usersync.rest.entities.SyncStatusEntity;
import de.resolution.usersync.rest.entities.TransformationsAndTestValue;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.util.UserSyncUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="userSyncRestResource")
@Path(value="/usersync")
public class UserSyncRestResource {
    private static final Logger logger = LoggerFactory.getLogger(UserSyncRestResource.class);
    private static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final ConnectorFactoryRegistry connectorFactoryRegistry;
    private final UserSyncService userSyncService;
    private final ConnectorService connectorService;
    private final NotificationService notificationService;
    private final SyncStatusRepository syncStatusRepository;
    private final SyncUserResultRepository syncUserResultRepository;
    private final PrivilegeChecker privilegeChecker;
    private final HostApplicationAttributeProvider hostApplicationAttributeProvider;
    private final SupportInformationGenerator supportInformationGenerator;
    private final CronExpressionValidator cronExpressionValidator;
    private final UserSyncAuditLogService userSyncAuditLogService;

    @Inject
    public UserSyncRestResource(ConnectorFactoryRegistry connectorFactoryRegistry, UserSyncService userSyncService, ConnectorService connectorService, NotificationService notificationService, SyncStatusRepository syncStatusRepository, SyncUserResultRepository syncUserResultRepository, PrivilegeChecker privilegeChecker, HostApplicationAttributeProvider hostApplicationAttributeProvider, SupportInformationGenerator supportInformationGenerator, CronExpressionValidator cronExpressionValidator, UserSyncAuditLogService userSyncAuditLogService) {
        this.connectorFactoryRegistry = connectorFactoryRegistry;
        this.userSyncService = userSyncService;
        this.connectorService = connectorService;
        this.notificationService = notificationService;
        this.syncStatusRepository = syncStatusRepository;
        this.syncUserResultRepository = syncUserResultRepository;
        this.privilegeChecker = privilegeChecker;
        this.hostApplicationAttributeProvider = hostApplicationAttributeProvider;
        this.supportInformationGenerator = supportInformationGenerator;
        this.cronExpressionValidator = cronExpressionValidator;
        this.userSyncAuditLogService = userSyncAuditLogService;
    }

    @GET
    public Response rootTo404() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
    }

    @Produces(value={"application/json"})
    @GET
    @ReadOnlyAccessAllowed
    @Path(value="/factories")
    public Response listFactories(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok().entity((Object)JSONUtil.asJson(this.connectorFactoryRegistry.getRegisteredConnectorFactoryEntities())).cacheControl(ccNoCache).build();
    }

    @Produces(value={"application/json"})
    @GET
    @ReadOnlyAccessAllowed
    @Path(value="/connector")
    public Response listConnectors(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok().entity((Object)JSONUtil.asJson(this.connectorService.getConnectors().stream().map(connectorAndValidationResult -> new ConnectorEntity((Connector<?>)connectorAndValidationResult.getConnector(), connectorAndValidationResult.getValidationResult(), this.hostApplicationAttributeProvider.getHostApplicationAttributes(), this.syncStatusRepository.getLast(connectorAndValidationResult.getUniqueId()), new DirectorySelection(this.connectorService.getAllDirectories(), connectorAndValidationResult.getConnector().isIncludeAllDirectories()), this.notificationService.getAll("CON" + connectorAndValidationResult.getUniqueId()), this.cronExpressionValidator)).collect(Collectors.toList()))).cacheControl(ccNoCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/connector/list")
    public Response listConnectorsForFrontend(@QueryParam(value="page") @DefaultValue(value="0") int page, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        List connectorEntityList = this.connectorService.getConnectors().stream().map(connectorAndValidationResult -> new ConnectorEntity((Connector<?>)connectorAndValidationResult.getConnector(), connectorAndValidationResult.getValidationResult(), this.hostApplicationAttributeProvider.getHostApplicationAttributes(), this.syncStatusRepository.getLast(connectorAndValidationResult.getUniqueId()), new DirectorySelection(this.connectorService.getAllDirectories(), connectorAndValidationResult.getConnector().isIncludeAllDirectories()), this.notificationService.getAll("CON" + connectorAndValidationResult.getUniqueId()), this.cronExpressionValidator)).collect(Collectors.toList());
        return this.cutToPage(connectorEntityList, page, limit);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/orphaneddirectories")
    public Response listOrphanedDirectoriesForFrontend(@QueryParam(value="page") @DefaultValue(value="0") int page, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return this.cutToPage(this.connectorService.getOrphanedDirectories(), page, limit);
    }

    private <T> Response cutToPage(List<T> resultList, int page, int limit) {
        int upperLimit;
        int effectiveLimit;
        int effectivePage = Math.max(page, 0);
        long lowerLimitLong = (long)effectivePage * (long)(effectiveLimit = Math.max(limit, 0));
        int lowerLimit = lowerLimitLong < Integer.MAX_VALUE ? (int)lowerLimitLong : Integer.MAX_VALUE;
        long upperLimitLong = lowerLimitLong + (long)effectiveLimit;
        int n = upperLimit = upperLimitLong < Integer.MAX_VALUE ? (int)upperLimitLong : Integer.MAX_VALUE;
        if (upperLimit >= resultList.size()) {
            upperLimit = resultList.size();
        }
        if (upperLimit < lowerLimit) {
            upperLimit = lowerLimit;
        }
        List<T> listPage = resultList.subList(lowerLimit, upperLimit);
        return new RestfulTableResultEntity<T>(listPage, resultList.size()).toResponse();
    }

    @Produces(value={"application/json"})
    @GET
    @ReadOnlyAccessAllowed
    @Path(value="/connector/{id}")
    public Response getConnector(@PathParam(value="id") String id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConnectorFactoryNotAvailableException, ConnectorNotFoundException, ConfigurationFailedException {
        this.privilegeChecker.checkSysAdmin(request);
        ConnectorAndValidationResult connectorAndValidationResult = this.connectorService.getConnectorByUniqueId(id);
        Map<String, String> hostApplicationAttributes = this.hostApplicationAttributeProvider.getHostApplicationAttributes();
        DirectorySelection directorySelection = new DirectorySelection(this.connectorService.getAllDirectories(), connectorAndValidationResult.getConnector().isIncludeAllDirectories());
        ConnectorEntity entity = new ConnectorEntity((Connector<?>)connectorAndValidationResult.getConnector(), connectorAndValidationResult.getValidationResult(), hostApplicationAttributes, this.syncStatusRepository.getLast(id), directorySelection, this.notificationService.getAll("CON" + connectorAndValidationResult.getUniqueId()), this.cronExpressionValidator);
        return Response.ok().entity((Object)JSONUtil.asJson(entity)).cacheControl(ccNoCache).build();
    }

    @Produces(value={"application/json"})
    @GET
    @ReadOnlyAccessAllowed
    @Path(value="/connector/{connectorId}/syncstatus")
    public Response listSyncStatusForConnector(@PathParam(value="connectorId") String connectorId, @QueryParam(value="page") @DefaultValue(value="0") int page, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        int total = this.syncStatusRepository.countForConnector(connectorId);
        List statusList = this.syncStatusRepository.getAllForConnector(connectorId, page * limit, limit).stream().map(ReducedSyncStatus::new).collect(Collectors.toList());
        return new RestfulTableResultEntity(statusList, total).toResponse();
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @ReadOnlyAccessAllowed
    @Path(value="/connector")
    public Response createConnector(String jsonString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConnectorFactoryNotAvailableException, ConfigurationFailedException {
        this.privilegeChecker.checkSysAdmin(request);
        CreateConnectorEntity createConnectorEntity = JSONUtil.fromJson(jsonString, CreateConnectorEntity.class);
        if (createConnectorEntity.getConnectorClassName() == null || createConnectorEntity.getConnectorClassName().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(ccNoCache).build();
        }
        Object connector = this.connectorService.create(createConnectorEntity.getConnectorClassName());
        ConnectorEntity entity = new ConnectorEntity((Connector<?>)connector, this.connectorService.validate(connector), this.hostApplicationAttributeProvider.getHostApplicationAttributes(), null, new DirectorySelection(this.connectorService.getAllDirectories(), connector.isIncludeAllDirectories()), this.notificationService.getAll("CON" + connector.getUniqueId()), this.cronExpressionValidator);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)JSONUtil.asJson(entity)).cacheControl(ccNoCache).build();
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PUT
    @ReadOnlyAccessAllowed
    @Path(value="/connector/{id}")
    public Response configureConnector(@PathParam(value="id") String id, String json, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConnectorFactoryNotAvailableException, ConnectorNotFoundException, ConfigurationFailedException {
        this.privilegeChecker.checkSysAdmin(request);
        ConnectorConfigurationEntity configEntity = JSONUtil.fromJson(json, ConnectorConfigurationEntity.class);
        String jsonString = configEntity.configurationJson;
        if (jsonString != null && !jsonString.isEmpty()) {
            ConnectorAndValidationResult connectorAndValidationResult = this.connectorService.configure(id, jsonString);
            return Response.ok().entity((Object)JSONUtil.asJson(new ConnectorEntity((Connector<?>)connectorAndValidationResult.getConnector(), connectorAndValidationResult.getValidationResult(), this.hostApplicationAttributeProvider.getHostApplicationAttributes(), this.syncStatusRepository.getLast(id), new DirectorySelection(this.connectorService.getAllDirectories(), connectorAndValidationResult.getConnector().isIncludeAllDirectories()), this.notificationService.getAll("CON" + connectorAndValidationResult.getUniqueId()), this.cronExpressionValidator))).cacheControl(ccNoCache).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ \"message\" : \"configuration must not be null or empty\" }").cacheControl(ccNoCache).build();
    }

    @Consumes(value={"application/json", "application/merge-patch+json", "application/json-patch+json"})
    @Produces(value={"application/json"})
    @PATCH
    @ReadOnlyAccessAllowed
    @Path(value="/connector/{id}")
    public Response patchConnectorConfiguration(@PathParam(value="id") String id, String patchForConfigurationJson, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConnectorFactoryNotAvailableException, ConnectorNotFoundException, ConfigurationFailedException {
        JsonNode patchedJson;
        JsonNode existingConfigurationJson;
        this.privilegeChecker.checkSysAdmin(request);
        if (patchForConfigurationJson == null || patchForConfigurationJson.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ \"message\" : \"configuration patch must not be null or empty\" }").cacheControl(ccNoCache).build();
        }
        try {
            ConnectorAndValidationResult existingConnectorAndValidationResult = this.connectorService.getConnectorByUniqueId(id);
            existingConfigurationJson = JSONUtil.asJsonNode(existingConnectorAndValidationResult.getConnector().getConfiguration());
        }
        catch (ConnectorNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String contentType = request.getContentType();
        try {
            patchedJson = contentType != null && contentType.contains("application/json-patch+json") ? JSONUtil.applyPatch(existingConfigurationJson, JSONUtil.asJsonNode(patchForConfigurationJson)) : JSONUtil.applyMergePatch(existingConfigurationJson, JSONUtil.asJsonNode(patchForConfigurationJson));
        }
        catch (JSONUtil.JsonPatchFailedException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{ \"message\" : \"Patch failed:" + e.getMessage() + "\"}")).build();
        }
        ConnectorAndValidationResult connectorAndValidationResult = this.connectorService.configure(id, patchedJson.toString());
        ValidationResultWithId validationResult = connectorAndValidationResult.getValidationResult();
        if (!validationResult.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)JSONUtil.asJson(validationResult)).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)JSONUtil.asJson(new ConnectorEntity((Connector<?>)connectorAndValidationResult.getConnector(), connectorAndValidationResult.getValidationResult(), this.hostApplicationAttributeProvider.getHostApplicationAttributes(), this.syncStatusRepository.getLast(id), new DirectorySelection(this.connectorService.getAllDirectories(), connectorAndValidationResult.getConnector().isIncludeAllDirectories()), this.notificationService.getAll("CON" + connectorAndValidationResult.getUniqueId()), this.cronExpressionValidator))).cacheControl(ccNoCache).build();
    }

    @DELETE
    @Path(value="/connector/{id}")
    public Response deleteConnector(@PathParam(value="id") String id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        if (this.connectorService.delete(id)) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
    }

    @Produces(value={"application/json"})
    @POST
    @ReadOnlyAccessAllowed
    @Path(value="/connector/{id}/sync")
    public Response startSync(@PathParam(value="id") String id, @QueryParam(value="simulate") boolean simulate, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConnectorNotAvailableException, SyncAlreadyRunningException, ConfigurationFailedException, ConnectorFactoryNotAvailableException, ConnectorNotFoundException {
        this.privilegeChecker.checkSysAdmin(request);
        SyncStatus syncStatus = this.userSyncService.sync(id, simulate);
        return Response.ok().entity((Object)JSONUtil.asJson(new SyncStatusEntity(syncStatus))).cacheControl(ccNoCache).build();
    }

    @GET
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Path(value="/connector/{connectorId}/loaduser")
    public Response loadUserData(@PathParam(value="connectorId") String connectorId, @QueryParam(value="id") String identifier, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConfigurationFailedException, ConnectorNotFoundException, ConnectorFactoryNotAvailableException, TransformationFailedException, UserFindFailedException {
        this.privilegeChecker.checkSysAdmin(request);
        Object connector = this.connectorService.getConnectorByUniqueId(connectorId).getConnector();
        MapStructuredData userData = connector.loadUserAttributesFromBackend(identifier, StructuredData.create());
        if (userData == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("No user found for id {}", (Object)StringUtil.sanitize(identifier));
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().entity((Object)JSONUtil.asJson(userData)).build();
    }

    @POST
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/connector/{connectorUID}/syncsingle")
    public Response syncSingle(@PathParam(value="connectorUID") String connectorId, String singleSyncDataJson, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConfigurationFailedException, ConnectorNotFoundException, ConnectorNotAvailableException, ConnectorFactoryNotAvailableException {
        PrivilegeCheckerImpl.Role role = this.connectorService.getConnectorByUniqueId(connectorId).getConnector().getConfiguration().getSyncSingleUserRestPermission();
        if (role == PrivilegeCheckerImpl.Role.ADMIN) {
            this.privilegeChecker.checkAdmin(request);
        } else {
            this.privilegeChecker.checkSysAdmin(request);
        }
        MapStructuredData additionalData = StructuredData.create();
        String overridingPrimaryAttribute = null;
        boolean simulate = false;
        String identifier = "";
        if (singleSyncDataJson != null && !singleSyncDataJson.trim().isEmpty()) {
            try {
                SyncSingleUserEntity syncEntity = JSONUtil.fromJson(singleSyncDataJson, SyncSingleUserEntity.class);
                additionalData = syncEntity.getAdditionalData();
                identifier = syncEntity.getIdentifier();
                simulate = syncEntity.isSimulate();
                if (syncEntity.isOverridePrimaryAttributeWithUsername()) {
                    overridingPrimaryAttribute = "ATTR_NAME";
                } else {
                    overridingPrimaryAttribute = syncEntity.getOverridingPrimaryAttribute();
                    if (overridingPrimaryAttribute != null && overridingPrimaryAttribute.trim().isEmpty()) {
                        overridingPrimaryAttribute = null;
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Reading additional data from {} failed", (Object)singleSyncDataJson, (Object)e);
                return Response.ok().entity((Object)JSONUtil.asJson(SyncSingleUserResult.createFailure("Reading Data failed, check logs for details: " + e.getMessage()))).cacheControl(ccNoCache).build();
            }
        }
        SyncSingleUserResult result = this.userSyncService.syncSingleUser(identifier, additionalData, null, overridingPrimaryAttribute, connectorId, simulate);
        return Response.ok().entity((Object)JSONUtil.asJson(result)).cacheControl(ccNoCache).build();
    }

    @Produces(value={"application/json"})
    @GET
    @ReadOnlyAccessAllowed
    @Path(value="/syncstatus")
    public Response getAllSyncStatus(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok().entity((Object)JSONUtil.asJson(this.syncStatusRepository.getAll().stream().map(ReducedSyncStatus::new).collect(Collectors.toList()))).cacheControl(ccNoCache).build();
    }

    @Produces(value={"application/json"})
    @GET
    @ReadOnlyAccessAllowed
    @Path(value="/syncstatus/{id}")
    public Response getSyncStatus(@PathParam(value="id") int id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        Optional<SyncStatusAoProxy> statusOpt = this.syncStatusRepository.get(id);
        if (statusOpt.isPresent()) {
            return Response.ok().entity((Object)JSONUtil.asJson(new SyncStatusEntity(statusOpt.get()))).cacheControl(ccNoCache).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
    }

    @Produces(value={"application/json"})
    @GET
    @ReadOnlyAccessAllowed
    @Path(value="/syncstatus/{id}/resultlist")
    public Response getSyncUserResultsForFrontend(@PathParam(value="id") int id, @QueryParam(value="operations") List<AtlasUserResult.Operation> includedOperations, @QueryParam(value="search") String search, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="10") @QueryParam(value="limit") int limit, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        if (!this.syncStatusRepository.get(id).isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        int effectivePage = page >= 0 ? page : 0;
        int effectiveLimit = limit > 0 ? limit : 10;
        long offsetAsLong = (long)effectivePage * (long)effectiveLimit;
        int offset = offsetAsLong < Integer.MAX_VALUE ? (int)offsetAsLong : Integer.MAX_VALUE;
        CollectionAndTotal<SyncUserResult> syncUserResultList = this.syncUserResultRepository.fetchResults(id, includedOperations, StringUtil.nullOrToLowerCase(search), offset, limit);
        return Response.ok().entity((Object)JSONUtil.asJson(syncUserResultList)).cacheControl(ccNoCache).build();
    }

    @Produces(value={"application/json"})
    @GET
    @ReadOnlyAccessAllowed
    @Path(value="/syncstatus/{id}/results")
    public Response getSyncUserResults(@QueryParam(value="operations") List<AtlasUserResult.Operation> includedOperations, @DefaultValue(value="0") @QueryParam(value="start") int startIndex, @DefaultValue(value="10") @QueryParam(value="count") int count, @PathParam(value="id") int id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        Optional<SyncStatusAoProxy> statusOpt = this.syncStatusRepository.get(id);
        if (statusOpt.isPresent()) {
            int resultCount;
            SyncStatus syncStatus = statusOpt.get();
            String warningMessage = null;
            if (count < 0 && (resultCount = ((SyncStatus)statusOpt.get()).getResultCount()) == Integer.MAX_VALUE) {
                warningMessage = "Result list is limited to 2147483647 of " + resultCount + " results";
            }
            List<AtlasUserResult.Operation> operations = !CollectionUtil.isNullOrEmpty(includedOperations) ? includedOperations.stream().filter(Objects::nonNull).collect(Collectors.toList()) : Arrays.asList(AtlasUserResult.Operation.values());
            Collection<SyncUserResult> syncUserResultList = this.syncUserResultRepository.fetchResults(id, operations, startIndex, count).getContent();
            SyncStatusEntity syncStatusWithResults = new SyncStatusEntity(syncStatus, syncUserResultList, warningMessage, this.supportInformationGenerator.generate(syncStatus.getConnectorUID(), true));
            return Response.ok().entity((Object)JSONUtil.asJson(syncStatusWithResults)).cacheControl(ccNoCache).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
    }

    @Produces(value={"application/octet-stream"})
    @GET
    @ReadOnlyAccessAllowed
    @Path(value="/syncstatus/{id}/resultfile")
    public Response getFile(@PathParam(value="id") int id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        Optional<SyncStatusAoProxy> statusOpt = this.syncStatusRepository.get(id);
        if (statusOpt.isPresent()) {
            SyncStatus syncStatus = statusOpt.get();
            String resultFilePath = syncStatus.getResultFilePath();
            if (resultFilePath == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No ResultFile in status").cacheControl(ccNoCache).build();
            }
            File file = new File(resultFilePath);
            if (!file.canRead()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not read " + resultFilePath)).cacheControl(ccNoCache).build();
            }
            return Response.ok((Object)file, (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\"")).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Status not found").cacheControl(ccNoCache).build();
    }

    @DELETE
    @ReadOnlyAccessAllowed
    @Path(value="/syncstatus/{id}")
    public Response deleteSyncStatus(@PathParam(value="id") int id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        if (this.syncStatusRepository.delete(id)) {
            return Response.noContent().cacheControl(ccNoCache).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
    }

    @POST
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Path(value="/syncstatus/{id}/cancel")
    public Response cancelSync(@PathParam(value="id") int id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        Optional<SyncStatusAoProxy> statusOpt = this.syncStatusRepository.get(id);
        if (statusOpt.isPresent()) {
            SyncStatus status = statusOpt.get();
            if (status.getStatus() == Task.Status.RUNNING) {
                status.setStatus(Task.Status.CANCELLING);
                if (!status.isSimulate()) {
                    this.userSyncAuditLogService.syncCanceled(status, this.connectorService);
                }
            }
            return Response.ok().entity((Object)JSONUtil.asJson(new SyncStatusEntity(status))).cacheControl(ccNoCache).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
    }

    @DELETE
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Path(value="/syncstatus/cleanup/{olderThan}")
    public Response cleanup(@PathParam(value="olderThan") long olderThan, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok().entity((Object)JSONUtil.asJson(new CountEntity(this.syncStatusRepository.cleanup(olderThan)))).cacheControl(ccNoCache).build();
    }

    @DELETE
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Path(value="/syncstatus/cleanuplegacy/{olderThan}")
    public Response cleanupLegacy(@PathParam(value="olderThan") long olderThan, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok().entity((Object)new CountEntity(this.syncStatusRepository.cleanupLegacy(olderThan))).cacheControl(ccNoCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/orphaneddirectory")
    public Response listOrphanedDirectories(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok((Object)JSONUtil.asJson(this.connectorService.getOrphanedDirectories())).cacheControl(ccNoCache).build();
    }

    @DELETE
    @ReadOnlyAccessAllowed
    @Path(value="/orphaneddirectory/{id}")
    public Response deleteOrphanedDirectory(@PathParam(value="id") int id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        try {
            this.connectorService.deleteOrphanedDirectory(id);
            return Response.noContent().cacheControl(ccNoCache).build();
        }
        catch (InvalidOperationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).cacheControl(ccNoCache).build();
        }
        catch (DirectoryNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
        }
        catch (AtlasUserOperationFailedException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e).cacheControl(ccNoCache).build();
        }
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @ReadOnlyAccessAllowed
    @Path(value="/testtransformations")
    public Response testTransformations(String jsonString, @Context HttpServletRequest request) {
        TransformationsAndTestValue transformationsAndTestValue = JSONUtil.fromJson(jsonString, TransformationsAndTestValue.class);
        RegexAndReplacementResult checkResult = RegexAndReplacement.checkValid(transformationsAndTestValue.transformations);
        if (checkResult.isOk()) {
            RegexAndReplacementResult result = RegexAndReplacement.apply(transformationsAndTestValue.testValue, transformationsAndTestValue.transformations);
            return Response.ok().entity((Object)JSONUtil.asJson(result)).cacheControl(ccNoCache).build();
        }
        return Response.ok().entity((Object)JSONUtil.asJson(checkResult)).cacheControl(ccNoCache).build();
    }

    @POST
    @ReadOnlyAccessAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{connectorid}/previewrequiredgroups")
    public Response fetchRequiredGroups(String jsonString, @PathParam(value="connectorid") String connectorId, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConnectorFactoryNotAvailableException, ConfigurationFailedException, GeneralSyncException {
        Map<String, String> groupIdsAndNames;
        this.privilegeChecker.checkSysAdmin(request);
        PreviewRequiredGroupsEntity previewRequiredGroupsEntity = JSONUtil.fromJson(jsonString, PreviewRequiredGroupsEntity.class);
        try {
            RequiredGroupCheckerHolder requiredGroupCheckerHolder = RequiredGroupChecker.create(previewRequiredGroupsEntity);
            groupIdsAndNames = this.connectorService.fetchRequiredConnectorGroups(connectorId, requiredGroupCheckerHolder);
        }
        catch (ConnectorNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().entity((Object)JSONUtil.asJson(UserSyncUtils.asKeyValueList(groupIdsAndNames))).build();
    }
}

