/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.TransformationResults;
import de.resolution.usersync.util.UserSyncUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"success", "operation", "transformationResults", "atlasUserResult"})
public class ImmutableSyncUserResult
implements SyncUserResult {
    private final AtlasUserResult atlasUserResult;
    private final TransformationResults transformationResults;
    private final String message;
    private final int id;

    public ImmutableSyncUserResult(@Nullable TransformationResults transformationResults, @Nullable AtlasUserResult atlasUserResult, @Nullable String message, @Nullable Integer id) {
        this.transformationResults = transformationResults;
        this.atlasUserResult = atlasUserResult;
        this.message = message;
        this.id = id == null ? -1 : id;
    }

    public ImmutableSyncUserResult(SyncUserResult other, int id) {
        this(other.getTransformationResults(), other.getAtlasUserResult(), other.getMessage(), id);
    }

    @Override
    @Nullable
    public AtlasUserResult getAtlasUserResult() {
        return this.atlasUserResult;
    }

    @Override
    @Nullable
    public TransformationResults getTransformationResults() {
        return this.transformationResults;
    }

    @Override
    public boolean isSuccess() {
        if (this.atlasUserResult != null) {
            return UserSyncUtils.checkSuccess(this.atlasUserResult);
        }
        if (this.transformationResults != null) {
            return this.transformationResults.isDropAll();
        }
        return false;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public AtlasUserResult.Operation getOperation() {
        if (this.transformationResults != null && this.transformationResults.isDropAll()) {
            return AtlasUserResult.Operation.FILTERED;
        }
        if (this.atlasUserResult == null) {
            return AtlasUserResult.Operation.NONE;
        }
        return this.atlasUserResult.getOperation();
    }
}

