/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.testconnector;

import de.resolution.atlasuser.api.CancelHandle;
import de.resolution.commons.data.ListStructuredData;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.util.ClasspathUtil;
import de.resolution.commons.util.JSONUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class TestUserCreator {
    private static final Random random = new SecureRandom();
    public static final List<String> GROUPS = Collections.unmodifiableList(JSONUtil.fromJson(ClasspathUtil.readFromClasspath("/testdata/rockbands.json"), List.class));
    public static final List<String> FIRST_NAMES = Collections.unmodifiableList(JSONUtil.fromJson(ClasspathUtil.readFromClasspath("/testdata/firstnames.json"), List.class));
    public static final List<String> LAST_NAMES = Collections.unmodifiableList(JSONUtil.fromJson(ClasspathUtil.readFromClasspath("/testdata/lastnames.json"), List.class));

    private TestUserCreator() {
    }

    public static ListStructuredData createFakeUsers(int count, int groupCount, String emailDomain, CancelHandle cancelHandle) {
        HashSet<String> existingNames = new HashSet<String>();
        ListStructuredData fakeUserList = StructuredData.create(new ArrayList()).asList();
        List<String> groupNames = TestUserCreator.createFakeGroups(groupCount);
        for (int i = 0; i < count; ++i) {
            MapStructuredData fakeUser = TestUserCreator.createFakeUser(existingNames, groupNames, emailDomain, cancelHandle);
            existingNames.add(fakeUser.get("USERID").asString());
            fakeUserList.add(fakeUser);
        }
        return fakeUserList;
    }

    public static MapStructuredData createFakeUser(Collection<String> existingUsernames, List<String> groupNames, String emailDomain, CancelHandle cancelHandle) {
        String uniqueId = UUID.randomUUID().toString();
        String firstname = FIRST_NAMES.get(random.nextInt(FIRST_NAMES.size()));
        String lastname = LAST_NAMES.get(random.nextInt(LAST_NAMES.size()));
        String initialUsername = (firstname + "." + lastname).toLowerCase().replace("+", "").replace(",", "").replace("\\", "").replace("<", "").replace(">", "").replace("'", "").replace("\"", "");
        MapStructuredData connectorAttributes = StructuredData.create();
        int suffix = 1;
        String username = initialUsername;
        while (existingUsernames.contains(username)) {
            if (cancelHandle.isCancelled()) {
                return connectorAttributes;
            }
            username = initialUsername + suffix;
            ++suffix;
        }
        String email = username + "@" + emailDomain;
        String fullName = firstname + " " + lastname;
        ArrayList<String> groups2 = new ArrayList<String>();
        for (String group : groupNames) {
            if (!random.nextBoolean()) continue;
            groups2.add(group);
        }
        connectorAttributes.put((Object)"USERID", username);
        connectorAttributes.put((Object)"Unique_ID", uniqueId);
        connectorAttributes.put((Object)"EMAIL", email);
        connectorAttributes.put((Object)"FULLNAME", fullName);
        connectorAttributes.put((Object)"GROUPS", groups2);
        return connectorAttributes;
    }

    public static List<String> createFakeGroups(int count) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            ret.add(GROUPS.get(random.nextInt(GROUPS.size())));
        }
        return ret;
    }
}

