/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.testconnector;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.atlasuser.api.CancelHandle;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.ListStructuredData;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.data.StructuredDataException;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.IdentifierForSingleUserSync;
import de.resolution.usersync.api.SharedHomeProvider;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.builtin.testconnector.TestConnectorConfiguration;
import de.resolution.usersync.builtin.testconnector.TestUserCreator;
import de.resolution.usersync.spi.AbstractConnector;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public class TestConnector
extends AbstractConnector<TestConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(TestConnector.class);
    public static final String TESTCONNECTOR_ATTRIBUTE_ID = "Unique_ID";
    private final SharedHomeProvider sharedHomeProvider;
    public static final String TRIGGER_RUNTIME_EXCEPTION = "RIP";
    public static final String RUNTIME_EXCEPTION_MESSAGE = "So Long, and Thanks for All the Fish";
    private ListStructuredData testUsers;
    private boolean createdNewTestUsers = false;
    private static final Script GROUPS_EXPRESSION = StructuredData.prepareFind("GROUPS");

    TestConnector(ConnectorService connectorService, AtlasUserAdapter atlasUserAdapter, TestConnectorConfiguration configuration, SharedHomeProvider sharedHomeProvider, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/TestConnector.json");
        this.sharedHomeProvider = sharedHomeProvider;
        this.loadTestData();
    }

    private void loadTestData() {
        CancelHandle ch = CancelHandle.create();
        if (((TestConnectorConfiguration)this.configuration).getTestData() == null || ((TestConnectorConfiguration)this.configuration).getTestData().isEmpty() || ((TestConnectorConfiguration)this.configuration).getTestData().trim().equals("null")) {
            this.testUsers = TestUserCreator.createFakeUsers(((TestConnectorConfiguration)this.configuration).getCount(), ((TestConnectorConfiguration)this.configuration).getGroupCount(), ((TestConnectorConfiguration)this.configuration).getEmailDomain(), ch);
            this.createdNewTestUsers = true;
            logger.info("Created new testdata");
        } else {
            StructuredData users = StructuredData.parseJson(((TestConnectorConfiguration)this.configuration).getTestData());
            this.testUsers = users.isList() ? users.asList() : StructuredData.create(Collections.singletonList(users)).asList();
            this.createdNewTestUsers = false;
        }
    }

    @Override
    public void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        if (this.createdNewTestUsers) {
            try {
                File outfile = new File(this.sharedHomeProvider.getSharedHome(), "testusers" + syncStatusFacade.getId() + ".json");
                ObjectMapper om = new ObjectMapper();
                om.writerWithDefaultPrettyPrinter().writeValue(outfile, (Object)this.testUsers);
                syncStatusFacade.add("Wrote testusers to " + outfile.getAbsolutePath(), SyncStatusFacade.LogLevel.INFO, logger);
                syncStatusFacade.setResultFilePath(outfile.getAbsolutePath());
            }
            catch (IOException e) {
                syncStatusFacade.add("Writing users to the home-directory failed", e, SyncStatusFacade.LogLevel.ERROR, logger);
            }
        }
        int processedUsers = 0;
        for (StructuredData userAttributes : this.testUsers) {
            Instant end;
            long duration;
            syncStatusFacade.checkCancel();
            Instant start = Instant.now();
            List<String> groups2 = Collections.emptyList();
            StructuredData groupData = userAttributes.findOrEmpty(GROUPS_EXPRESSION);
            if (groupData.isList()) {
                groups2 = userAttributes.findOrEmpty(GROUPS_EXPRESSION).asStringList();
            }
            if (((TestConnectorConfiguration)this.configuration).getRequiredConnectorGroups().isEmpty() || TestConnector.matchesRequiredConnectorGroups(((TestConnectorConfiguration)this.configuration).getRequiredConnectorGroups(), groups2)) {
                syncFunction.accept(Objects.requireNonNull(userAttributes.asMap()));
            }
            if ((duration = Duration.between(start, end = Instant.now()).toMillis()) < ((TestConnectorConfiguration)this.configuration).getMinimalTimePerUser()) {
                try {
                    Thread.sleep(((TestConnectorConfiguration)this.configuration).getMinimalTimePerUser() - duration);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    syncStatusFacade.checkCancel();
                }
            }
            if (processedUsers % 100 == 0) {
                this.trackMemoryUsage(syncStatusFacade, "after processing " + processedUsers + " users");
            }
            ++processedUsers;
        }
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        List<String> actualGroups;
        if (Objects.equals(identifier, TRIGGER_RUNTIME_EXCEPTION)) {
            throw new StructuredDataException(RUNTIME_EXCEPTION_MESSAGE);
        }
        Script findExpresson = StructuredData.prepareFind("findAll{ it?.USERID?.first() == \"" + identifier + "\" || it?.Unique_ID?.first() == \"" + identifier + "\" }");
        StructuredData foundData = this.testUsers.findOrEmpty(findExpresson);
        if (!foundData.isList()) {
            return FindUserResult.notFound();
        }
        ListStructuredData found = foundData.asList();
        if (found.isEmpty()) {
            return FindUserResult.notFound();
        }
        if (found.size() > 1) {
            return FindUserResult.notUnique();
        }
        MapStructuredData foundUser = found.get(0).asMap();
        StructuredData actualGroupData = foundUser.get("GROUPS");
        List<Object> list = actualGroups = actualGroupData == null ? Collections.emptyList() : actualGroupData.asStringList();
        if (((TestConnectorConfiguration)this.configuration).isIgnoreRequiredConnectorGroupsOnSingleUserSync() || TestConnector.matchesRequiredConnectorGroups(((TestConnectorConfiguration)this.configuration).getRequiredConnectorGroups(), actualGroups)) {
            return FindUserResult.found(foundUser);
        }
        return FindUserResult.preFiltered(foundUser);
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Testconnector";
    }

    @Override
    public List<String> getConnectorAttributes() {
        return Arrays.asList(TESTCONNECTOR_ATTRIBUTE_ID, "USERID", "FULLNAME", "EMAIL", "ATTRIB1", "ATTRIB2", "ATTRIB3", "GROUPS");
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    @Override
    public boolean isCanSyncSingleUser() {
        return true;
    }

    @Override
    @Nonnull
    public Class<TestConnectorConfiguration> getConfigurationClass() {
        return TestConnectorConfiguration.class;
    }

    @Override
    public boolean isCanOverrideDefaultConnectTimeoutForOkHttp() {
        return true;
    }

    @Override
    public boolean isSelectableDirectory() {
        return true;
    }

    @Override
    public ValidationResult checkIdentifierForSingleUserSync(IdentifierForSingleUserSync identifier, @Nonnull ValidationResult result) {
        String identifierString = identifier.getIdentifier();
        if (identifierString.trim().isEmpty()) {
            result.addError("Enter a non-empty value");
        }
        return result;
    }
}

