/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.keycloak;

import de.resolution.commons.util.Elvis;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.usersync.builtin.keycloak.KeycloakConnector;
import de.resolution.usersync.builtin.keycloak.KeycloakConnectorConfiguration;
import de.resolution.usersync.spi.AbstractOAuthConnectorConfiguration;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KeycloakConnectorConfigurationImpl
extends AbstractOAuthConnectorConfiguration
implements KeycloakConnectorConfiguration {
    public static final AttributeTransformationConfig ACTIVE_TRANSFORMATION = new AttributeTransformationConfig(Source.createSingle("enabled"), new Target(Target.Type.SYSTEM, "ATTR_ACTIVE"), false, true);
    private static final String DEFAULT_FIND_BY_ATTRIBUTE_NAME = "keycloak_ID";
    private static final List<AttributeTransformationConfig> DEFAULT_TRANSFORMATION_CONFIGS = new ArrayList<AttributeTransformationConfig>();
    @Nonnull
    private String baseUrl = "";
    @Nonnull
    private String realm = "";
    private int batchSize = 100;
    private boolean fetchNestedGroups = false;

    public KeycloakConnectorConfigurationImpl() {
    }

    public KeycloakConnectorConfigurationImpl(KeycloakConnectorConfiguration other) {
        super(other);
        this.setBaseUrl(other.getBaseUrl());
        this.setRealm(other.getRealm());
        this.setBatchSize(other.getBatchSize());
        this.setFetchNestedGroups(other.isFetchNestedGroups());
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(@Nullable String baseUrl) {
        this.baseUrl = Elvis.ifNull(baseUrl, "");
    }

    @Override
    @Nonnull
    public String getRealm() {
        return this.realm;
    }

    public void setRealm(@Nullable String realm) {
        this.realm = Elvis.ifNull(realm, "");
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public boolean isFetchNestedGroups() {
        return this.fetchNestedGroups;
    }

    public void setFetchNestedGroups(boolean fetchNestedGroups) {
        this.fetchNestedGroups = fetchNestedGroups;
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs() {
        return DEFAULT_TRANSFORMATION_CONFIGS;
    }

    @Override
    @Nonnull
    public String getDefaultFindByAttributeName() {
        return DEFAULT_FIND_BY_ATTRIBUTE_NAME;
    }

    @Override
    @Nonnull
    public ConnectorConfiguration sanitize() {
        KeycloakConnectorConfigurationImpl ret = new KeycloakConnectorConfigurationImpl(this);
        ret.setClientSecret("<<SENSITIVE DATA REMOVED>>");
        return ret;
    }

    @Override
    public Class<? extends Connector<? extends ConnectorConfiguration>> tellConnectorClass() {
        return KeycloakConnector.class;
    }

    static {
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle("id"), new Target(Target.Type.CROWD, DEFAULT_FIND_BY_ATTRIBUTE_NAME), true, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle("username"), new Target(Target.Type.SYSTEM, "ATTR_NAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createFieldCombiner("{firstName} {lastName}"), new Target(Target.Type.SYSTEM, "ATTR_FULLNAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle("email"), new Target(Target.Type.SYSTEM, "ATTR_EMAIL"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(ACTIVE_TRANSFORMATION);
        DEFAULT_TRANSFORMATION_CONFIGS.add(GROUP_TRANSFORMATION);
    }
}

