/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.azure;

import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.Tuple;
import de.resolution.usersync.api.SyncStatusFacade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AzureUserResult {
    private static final Logger logger = LoggerFactory.getLogger(AzureUserResult.class);
    private static final String VALUE = "value";
    private static final String ODATA_TYPE = "@odata.type";
    private static final String ODATA_NEXT_LINK = "@odata.nextLink";
    @Nullable
    private final String nextPageUrl;
    @Nonnull
    private List<JsonNode> users = Collections.emptyList();

    AzureUserResult(@Nonnull ResponseWrapper responseWrapper, @Nonnull Set<String> seenUserIdentifiers, @Nonnull SyncStatusFacade syncStatusFacade) {
        JsonNode body = responseWrapper.getBodyAsJsonNode();
        this.nextPageUrl = body.path(ODATA_NEXT_LINK).asText();
        JsonNode valueNode = body.path(VALUE);
        if (valueNode != null && valueNode.isArray()) {
            this.users = this.parseUsers(valueNode, seenUserIdentifiers, syncStatusFacade);
        }
    }

    @Nonnull
    private List<JsonNode> parseUsers(@Nonnull JsonNode usersArray, @Nonnull Set<String> seenUserIdentifiers, @Nonnull SyncStatusFacade syncStatusFacade) {
        ArrayList<JsonNode> filteredUsers = new ArrayList<JsonNode>();
        for (JsonNode user : usersArray) {
            if (!this.shouldProcessUser(user, seenUserIdentifiers, syncStatusFacade)) continue;
            filteredUsers.add(user);
        }
        return filteredUsers;
    }

    private boolean shouldProcessUser(@Nonnull JsonNode user, @Nonnull Set<String> seenUserIdentifiers, @Nonnull SyncStatusFacade syncStatusFacade) {
        String id = user.path("id").asText();
        if (StringUtil.isNullOrEmpty(id)) {
            syncStatusFacade.failPartially("id is null or empty, that's unexpected here.", logger);
            return false;
        }
        if (seenUserIdentifiers.contains(id)) {
            logger.debug("Skipping already synced user {}", (Object)id);
            return false;
        }
        String type = user.path(ODATA_TYPE).asText();
        if (type != null && !type.isEmpty() && !Objects.equals("#microsoft.graph.user", type)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Object with id {} is of type {}, but #microsoft.graph.user was expected.", (Object)id, (Object)type);
            }
            return false;
        }
        return true;
    }

    @Nonnull
    List<Tuple<String, StructuredData>> getUsers() {
        return this.users.stream().map(user -> new Tuple<String, StructuredData>(user.path("id").asText(), StructuredData.parseJson(JSONUtil.asJson(user)))).collect(Collectors.toList());
    }

    @Nonnull
    List<String> getUserIds() {
        return this.users.stream().map(user -> user.path("id").asText()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    String getNextPageUrl() {
        return this.nextPageUrl;
    }
}

