/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonRawValue;
import de.resolution.usersync.api.SyncStatus;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;

@JsonAutoDetect
public class ConnectorSupportInformation {
    private final String uniqueId;
    private final String configurationJson;
    private final String connectorClass;
    private final boolean connectorAvailable;
    private final long lastUpdated;
    private final long generated;
    private final boolean sanitized;
    private final SyncStatus lastSyncStatus;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");

    public ConnectorSupportInformation(String uniqueId, String configurationJson, boolean sanitized, String connectorClass, boolean connectorAvailable, long lastUpdated, @Nullable SyncStatus syncStatus) {
        this.uniqueId = uniqueId;
        this.configurationJson = configurationJson;
        this.sanitized = sanitized;
        this.connectorClass = connectorClass;
        this.connectorAvailable = connectorAvailable;
        this.lastUpdated = lastUpdated;
        this.generated = System.currentTimeMillis();
        this.lastSyncStatus = syncStatus;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    @JsonRawValue
    public String getConfigurationJson() {
        return this.configurationJson;
    }

    public String getConnectorClass() {
        return this.connectorClass;
    }

    public boolean isConnectorAvailable() {
        return this.connectorAvailable;
    }

    public boolean isSanitized() {
        return this.sanitized;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public String getLastUpdatedDateString() {
        return this.dateFormat.format(new Date(this.generated));
    }

    public long getGenerated() {
        return this.generated;
    }

    public String getGeneratedDateString() {
        return this.dateFormat.format(new Date(this.generated));
    }

    public SyncStatus getLastSyncStatus() {
        return this.lastSyncStatus;
    }
}

