/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.resolution.retransform.api.AttributeTransformationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TransformationResultImpl
implements AttributeTransformationResult {
    private final boolean drop;
    private final boolean dropAll;
    @Nonnull
    private final List<String> values;
    @Nullable
    private final String message;

    public TransformationResultImpl(List<String> values2, boolean drop, boolean dropAll) {
        this(values2, drop, dropAll, null);
    }

    public TransformationResultImpl(List<String> values2, boolean drop, boolean dropAll, @Nullable String message) {
        this.values = values2 == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(values2));
        this.drop = drop;
        this.dropAll = dropAll;
        this.message = message;
    }

    @Override
    @Nonnull
    public List<String> getValues() {
        return this.values;
    }

    @Override
    @Nullable
    public String getFirstValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    @Override
    public boolean isDrop() {
        return this.drop;
    }

    @Override
    public boolean isDropAll() {
        return this.dropAll;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AttributeTransformationResult)) {
            return false;
        }
        if (!Objects.equals(this.message, ((AttributeTransformationResult)other).getMessage())) {
            return false;
        }
        AttributeTransformationResult otherResult = (AttributeTransformationResult)other;
        return this.drop == otherResult.isDrop() && this.dropAll == otherResult.isDropAll() && this.values.equals(otherResult.getValues());
    }

    public int hashCode() {
        return Objects.hash(this.drop, this.dropAll, this.values, this.message);
    }
}

