/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.impl;

import de.resolution.commons.data.StructuredData;
import de.resolution.commons.util.boundedregex.RegexAndReplacement;
import de.resolution.commons.util.boundedregex.RegexAndReplacementResult;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.retransform.config.Transformations;
import de.resolution.retransform.impl.TransformationResultImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PostTransformingAttributeTransformer
implements AttributeTransformer {
    @Nonnull
    private final AttributeTransformer attributeTransformer;
    @Nonnull
    private final Transformations postTransformations;
    @Nullable
    private final List<String> dropAllIfValuesDontMatchAnyOfThese;
    @Nullable
    private final List<String> removeValuesNotMatchingAnyOfThese;
    @Nullable
    private final List<String> removeValuesMatchingAnyOfThese;
    @Nullable
    private final List<String> addTheseStaticValues;

    public PostTransformingAttributeTransformer(@Nonnull AttributeTransformer attributeTransformer, @Nonnull Transformations postTransformations, @Nullable List<String> dropAllIfValuesDontMatchAnyOfThese, @Nullable List<String> removeValuesNotMatchingAnyOfThese, @Nullable List<String> removeValuesMatchingAnyOfThese, @Nullable List<String> addTheseStaticValues) {
        this.attributeTransformer = attributeTransformer;
        this.postTransformations = postTransformations;
        this.dropAllIfValuesDontMatchAnyOfThese = dropAllIfValuesDontMatchAnyOfThese;
        this.removeValuesNotMatchingAnyOfThese = removeValuesNotMatchingAnyOfThese;
        this.removeValuesMatchingAnyOfThese = removeValuesMatchingAnyOfThese;
        this.addTheseStaticValues = addTheseStaticValues;
    }

    @Override
    @Nonnull
    public AttributeTransformationResult transform(@Nonnull StructuredData data) throws TransformationFailedException {
        AttributeTransformationResult result = this.attributeTransformer.transform(data);
        if (result.isDropAll()) {
            return result;
        }
        List<String> values2 = new ArrayList<String>(result.getValues());
        boolean drop = result.isDrop();
        if (this.postTransformations.isToLowerCase()) {
            values2 = values2.stream().map(String::toLowerCase).collect(Collectors.toList());
        }
        if (this.postTransformations.getRegexAndReplacement().isEnabled()) {
            List<RegexAndReplacement> regexAndReplacements = this.postTransformations.getRegexAndReplacement().getItems();
            Transformations.DropOption dropOption = this.postTransformations.getRegexAndReplacement().getDropOption();
            ArrayList<String> valuesAfterRegex = new ArrayList<String>();
            for (String current : values2) {
                RegexAndReplacementResult regexAndReplacementResult = RegexAndReplacement.apply(current, regexAndReplacements);
                if (regexAndReplacementResult.isMatched()) {
                    valuesAfterRegex.add(regexAndReplacementResult.getResult());
                    continue;
                }
                switch (dropOption) {
                    case DROP_USER_IF_NOT_APPLIED: {
                        return new TransformationResultImpl(values2, false, true);
                    }
                    case DROP_ATTRIBUTE_IF_NOT_APPLIED: {
                        return new TransformationResultImpl(values2, true, false);
                    }
                    case DROP_VALUE_IF_NOT_APPLIED: {
                        break;
                    }
                    case NONE: {
                        valuesAfterRegex.add(current);
                    }
                }
            }
            values2 = valuesAfterRegex;
        }
        if (this.postTransformations.getSplitAttribute().isEnabled()) {
            String separator = this.postTransformations.getSplitAttribute().getSeparator();
            if (separator == null) {
                throw new TransformationFailedException("Separator must not be null if Split Attribute is enabled");
            }
            ArrayList<String> valuesAfterSplit = new ArrayList<String>();
            for (String current : values2) {
                valuesAfterSplit.addAll(Arrays.asList(current.split(separator)));
            }
            values2 = valuesAfterSplit;
        }
        if (this.postTransformations.getAddConstant().isEnabled()) {
            values2.addAll(this.postTransformations.getAddConstant().getValues());
        }
        if (this.dropAllIfValuesDontMatchAnyOfThese != null && !this.dropAllIfValuesDontMatchAnyOfThese.isEmpty()) {
            boolean matched = false;
            for (String stringToMatch : this.dropAllIfValuesDontMatchAnyOfThese) {
                if (!values2.stream().anyMatch(value -> value.matches(stringToMatch))) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return new TransformationResultImpl(values2, false, true);
            }
        }
        if (this.removeValuesNotMatchingAnyOfThese != null && !this.removeValuesNotMatchingAnyOfThese.isEmpty()) {
            values2 = values2.stream().filter(value -> this.removeValuesNotMatchingAnyOfThese.stream().anyMatch(value::matches)).collect(Collectors.toList());
        }
        if (this.removeValuesMatchingAnyOfThese != null && !this.removeValuesMatchingAnyOfThese.isEmpty()) {
            values2 = values2.stream().filter(value -> this.removeValuesMatchingAnyOfThese.stream().noneMatch(value::matches)).collect(Collectors.toList());
        }
        if (this.addTheseStaticValues != null && !this.addTheseStaticValues.isEmpty()) {
            drop = false;
            values2 = new ArrayList<String>(values2);
            values2.addAll(this.addTheseStaticValues);
        }
        return new TransformationResultImpl(values2, drop, false);
    }

    @Override
    @Nonnull
    public ValidationResult validate() {
        return this.attributeTransformer.validate();
    }

    @Nonnull
    public AttributeTransformer getInnerAttributeTransformer() {
        return this.attributeTransformer;
    }
}

