/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.impl;

import de.resolution.commons.data.StructuredData;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.retransform.impl.AbstractKeyBasedAttributeTransformer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FirstAttributeTransformer
extends AbstractKeyBasedAttributeTransformer {
    private final List<String> keys;

    public FirstAttributeTransformer(@Nonnull List<String> keys2, boolean splitKey, @Nullable String defaultTopLevelKey) {
        super(splitKey, defaultTopLevelKey);
        this.keys = keys2;
    }

    @Override
    @Nonnull
    public AttributeTransformationResult transform(@Nonnull StructuredData data) throws TransformationFailedException {
        try {
            for (String key : this.keys) {
                StructuredData readData;
                AbstractKeyBasedAttributeTransformer.ReadResult readResult = FirstAttributeTransformer.read(key, data, super.getDefaultTopLevelKey(), super.isSplitKey());
                if (!readResult.isKeyPresent() || readResult.getData() == null || readResult.getData().isEmpty() || this.isListAndContainsEmptyStringsOnly(readData = readResult.getData())) continue;
                return FirstAttributeTransformer.createAttributeTransformationResult(readResult);
            }
            return AttributeTransformationResult.createDrop("No value for any of the keys");
        }
        catch (Exception e) {
            throw new TransformationFailedException(e);
        }
    }

    private boolean isListAndContainsEmptyStringsOnly(@Nonnull StructuredData readData) {
        return readData.isList() && readData.asStringList().stream().allMatch(String::isEmpty);
    }
}

