/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.impl;

import de.resolution.commons.data.StructuredData;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.retransform.impl.AbstractKeyBasedAttributeTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldCombinerTransformer
extends AbstractKeyBasedAttributeTransformer {
    @Nonnull
    private final String fieldCombinerExpression;
    private static final char OPEN_BRACE = '{';
    private static final char CLOSING_BRACE = '}';

    public FieldCombinerTransformer(@Nonnull String fieldCombinerExpression, boolean splitKey, @Nonnull String defaultTopLevelKey) {
        super(splitKey, defaultTopLevelKey);
        this.fieldCombinerExpression = fieldCombinerExpression;
    }

    @Override
    @Nonnull
    public AttributeTransformationResult transform(@Nonnull StructuredData data) throws TransformationFailedException {
        try {
            if (!this.fieldCombinerExpression.contains(Character.toString('{'))) {
                return this.transformSingleKey(this.fieldCombinerExpression, data);
            }
            String replaced = FieldCombinerTransformer.replaceFields(this.fieldCombinerExpression, data, this.getDefaultTopLevelKey(), this.isSplitKey());
            return AttributeTransformationResult.create(Collections.singletonList(replaced), false, false, null);
        }
        catch (Exception e) {
            throw new TransformationFailedException(e);
        }
    }

    @Override
    @Nonnull
    public ValidationResult validate() {
        ValidationResult validationResult = super.validate();
        try {
            FieldCombinerTransformer.readKeysFromExpression(this.fieldCombinerExpression);
        }
        catch (InvalidExpressionException e) {
            validationResult.addError(e.getMessage());
        }
        return validationResult;
    }

    @Nonnull
    public static String replaceFields(@Nonnull String fieldCombinerExpression, @Nonnull StructuredData data, @Nullable String defaultTopLevelKey, boolean splitKey) {
        List<String> keyList = FieldCombinerTransformer.readKeysFromExpression(fieldCombinerExpression);
        String resultString = fieldCombinerExpression.replace("{}", "");
        for (String key : keyList) {
            AbstractKeyBasedAttributeTransformer.ReadResult readResult = FieldCombinerTransformer.read(key, data, defaultTopLevelKey, splitKey);
            StructuredData resultData = readResult.getData();
            String value = !readResult.isKeyPresent() || resultData == null || resultData.isEmpty() ? "" : (resultData.isList() ? (resultData.asList().isEmpty() ? "" : resultData.asList().get(0).asString()) : resultData.asString());
            resultString = FieldCombinerTransformer.replaceField(resultString, key, value);
        }
        return resultString;
    }

    @Nonnull
    public static String replaceField(@Nonnull String expressionToBeReplaced, @Nonnull String key, @Nullable String value) {
        if (value == null) {
            value = "";
        }
        String toBeReplaced = "{" + key + "}";
        return expressionToBeReplaced.replace(toBeReplaced, value);
    }

    @Nonnull
    public static List<String> readKeysFromExpression(@Nonnull String fieldCombinerExpression) {
        if (fieldCombinerExpression == null) {
            throw new InvalidExpressionException("Expression must not be null");
        }
        if (fieldCombinerExpression.isEmpty()) {
            throw new InvalidExpressionException("Expression must not be empty");
        }
        ArrayList<String> keyList = new ArrayList<String>();
        int maxIndex = fieldCombinerExpression.length() - 1;
        int index = 0;
        StringBuilder currentKeyBuilder = new StringBuilder();
        boolean activeOpenBrace = false;
        do {
            char currentChar = fieldCombinerExpression.charAt(index);
            if (activeOpenBrace) {
                if (currentChar == '}') {
                    keyList.add(currentKeyBuilder.toString());
                    currentKeyBuilder = new StringBuilder();
                    activeOpenBrace = false;
                    continue;
                }
                if (currentChar == '{') {
                    throw new InvalidExpressionException(index, currentChar);
                }
                currentKeyBuilder.append(currentChar);
                continue;
            }
            if (currentChar == '}') {
                throw new InvalidExpressionException(index, currentChar);
            }
            if (currentChar != '{') continue;
            activeOpenBrace = true;
        } while (index++ < maxIndex);
        if (activeOpenBrace) {
            throw new InvalidExpressionException("Missing closing } at end of expression");
        }
        return keyList;
    }

    public static class InvalidExpressionException
    extends RuntimeException {
        private final char unexpectedChar;
        private final int index;

        public InvalidExpressionException(int index, char character) {
            super("Unexpected character " + character + " at index " + index);
            this.unexpectedChar = character;
            this.index = index;
        }

        public InvalidExpressionException(@Nonnull String message) {
            super(message);
            this.unexpectedChar = '\u0000';
            this.index = -1;
        }

        public char getUnexpectedChar() {
            return this.unexpectedChar;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

