/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.frontend;

import de.resolution.retransform.frontend.PluginProperties;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(ResourceLoader.class);
    private static final Bundle bundle = FrameworkUtil.getBundle(ResourceLoader.class);
    private static final Path resourcePath;

    private ResourceLoader() {
    }

    public static Set<String> listFilesFromFileSystem(String pathString) {
        HashSet<String> filenames = new HashSet<String>();
        if (resourcePath != null) {
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(resourcePath.resolve(pathString));){
                for (Path path : dirStream) {
                    String relativePath = resourcePath.relativize(path).toString();
                    logger.warn("Found {} in filesystem", (Object)relativePath);
                    filenames.add(relativePath);
                }
            }
            catch (NoSuchFileException e) {
                logger.debug("NoSuchFileException: {}", (Object)e.getMessage());
            }
            catch (IOException e) {
                logger.warn("Loading files from filesystem-path {} failed!", (Object)pathString, (Object)e);
            }
        }
        return filenames;
    }

    public static List<String> listFiles(String path) {
        Set<String> filenameSet = resourcePath == null ? new HashSet<String>() : ResourceLoader.listFilesFromFileSystem(path);
        Enumeration pathEnumeration = bundle.getEntryPaths(path);
        if (pathEnumeration == null) {
            throw new ResourceNotFoundException(path);
        }
        while (pathEnumeration.hasMoreElements()) {
            String filename = (String)pathEnumeration.nextElement();
            if (filename.endsWith("/")) continue;
            filenameSet.add(filename);
        }
        return new ArrayList<String>(filenameSet);
    }

    public static String loadFromFileSystem(String filename) {
        if (resourcePath != null) {
            Path pathToFile = resourcePath.resolve(filename);
            if (Files.exists(pathToFile, new LinkOption[0]) && Files.isReadable(pathToFile)) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Loading {} from filesystem", (Object)pathToFile.toAbsolutePath());
                }
                Scanner scanner = new Scanner(Files.newInputStream(pathToFile, new OpenOption[0]));
                try {
                    scanner.useDelimiter("\\A");
                    String string = scanner.hasNext() ? scanner.next() : "";
                    scanner.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.warn("Unexpected Exception reading {}, returning null", (Object)filename, (Object)e);
                        return null;
                    }
                }
            }
            logger.debug("{} does not exist is not readable, returning null", (Object)filename);
            return null;
        }
        return null;
    }

    public static String load(String filename) {
        String fromFile = ResourceLoader.loadFromFileSystem(filename);
        if (fromFile != null) {
            return fromFile;
        }
        URL entryUrl = bundle.getEntry(filename);
        if (entryUrl == null) {
            throw new ResourceNotFoundException(filename);
        }
        Scanner scanner = new Scanner(entryUrl.openStream());
        try {
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new LoadingFailedException(filename, e);
            }
        }
    }

    public static boolean exists(String filename) {
        return bundle.getEntry(filename) != null;
    }

    public static String stripPath(String filename) {
        return new File(filename).getName();
    }

    public static String stripExtension(String filename) {
        return filename.replaceAll("\\.[^.]*$", "");
    }

    public static String stripPathAndExtension(String filename) {
        return ResourceLoader.stripExtension(ResourceLoader.stripPath(filename));
    }

    public static boolean isLoadFromFilesystem() {
        return resourcePath != null;
    }

    static {
        String resourcePathString = PluginProperties.get("resourcePath");
        if (resourcePathString != null && !resourcePathString.isEmpty()) {
            resourcePath = Paths.get(resourcePathString, new String[0]);
            logger.warn("Trying to find resources on filesystem path {}, THIS SHOULD NOT BE ENABLED ON A PRODUCTION-SYSTEM!", (Object)resourcePathString);
        } else {
            resourcePath = null;
        }
    }

    public static class ResourceNotFoundException
    extends LoadingFailedException {
        public ResourceNotFoundException(String path) {
            super("Resource was not found at " + path);
        }
    }

    public static class LoadingFailedException
    extends RuntimeException {
        public LoadingFailedException(String path, Throwable cause) {
            super("Loading resource from " + path + " failed", cause);
        }

        public LoadingFailedException(String message) {
            super(message);
        }
    }
}

