/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.frontend;

import de.resolution.atlasuser.impl.user.communardo.CommunardoUserProfileAdapter;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.retransform.frontend.AttributeMappingOptionGroup;
import de.resolution.retransform.frontend.AttributeMappingTemplate;
import de.resolution.retransform.frontend.AttributeMappingTemplateMap;
import de.resolution.retransform.frontend.TargetTypeMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeMappingUtils {
    private static final Logger logger = LoggerFactory.getLogger(AttributeMappingUtils.class);

    private AttributeMappingUtils() {
    }

    public static Map<String, Object> getMatchingPresetsForAnalytics(@Nonnull List<AttributeTransformationConfig> attributeTransformationConfigs, @Nonnull String idpOrConnectorType, @Nonnull AttributeMappingTemplateMap allPresets) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        TargetTypeMap idpPresets = (TargetTypeMap)allPresets.get(idpOrConnectorType);
        if (idpPresets == null) {
            return ret;
        }
        for (AttributeTransformationConfig existingConfig : attributeTransformationConfigs) {
            String type = existingConfig.getTarget().getType().toString();
            String name = existingConfig.getTarget().getName();
            List<AttributeMappingTemplate> attributeMappingTemplates = AttributeMappingUtils.extractAttributeMappingTemplatesFromTargetTypeMap(idpPresets, type, name);
            if (existingConfig.getSource().getType().equals((Object)Source.Type.UNMAPPED)) continue;
            List matchingPresets = attributeMappingTemplates.stream().filter(attributeMappingTemplate -> attributeMappingTemplate.getValue().equals(existingConfig)).collect(Collectors.toList());
            if (matchingPresets.isEmpty()) {
                ret.put((Object)((Object)existingConfig.getTarget().getType()) + "." + existingConfig.getTarget().getName(), "custom:" + (Object)((Object)existingConfig.getSource().getType()));
                continue;
            }
            if (matchingPresets.size() == 1) {
                ret.put((Object)((Object)existingConfig.getTarget().getType()) + "." + existingConfig.getTarget().getName(), ((AttributeMappingTemplate)matchingPresets.get(0)).getId());
                continue;
            }
            if (logger.isWarnEnabled()) {
                logger.warn("Found {} presets for {} instead of only one", (Object)matchingPresets.size(), (Object)(idpOrConnectorType + "." + (Object)((Object)existingConfig.getTarget().getType()) + "." + existingConfig.getTarget().getName()));
            }
            ret.put((Object)((Object)existingConfig.getTarget().getType()) + "." + existingConfig.getTarget().getName(), ((AttributeMappingTemplate)matchingPresets.get(0)).getId());
        }
        return ret;
    }

    @Nonnull
    private static List<AttributeMappingTemplate> extractAttributeMappingTemplatesFromTargetTypeMap(@Nonnull TargetTypeMap idpPresets, @Nonnull String type, @Nonnull String name) {
        AttributeMappingTemplateMap.TargetNameMap targetNameMap = (AttributeMappingTemplateMap.TargetNameMap)idpPresets.get(type);
        if (targetNameMap == null) {
            return Collections.emptyList();
        }
        List attributeMappingTemplates = (List)targetNameMap.get(name);
        if (attributeMappingTemplates == null) {
            return Collections.emptyList();
        }
        return attributeMappingTemplates;
    }

    @Nonnull
    public static List<AttributeMappingOptionGroup.AttributeMappingOption> createCommunardoAttributeOptions(@Nonnull CommunardoUserProfileAdapter communardoUserProfileAdapter) {
        Map<Integer, String> communardoAttributes = communardoUserProfileAdapter.getAvailableAttributes();
        if (!communardoAttributes.isEmpty()) {
            ArrayList<AttributeMappingOptionGroup.AttributeMappingOption> communardoOptions = new ArrayList<AttributeMappingOptionGroup.AttributeMappingOption>();
            for (Map.Entry<Integer, String> entry : communardoAttributes.entrySet()) {
                communardoOptions.add(new AttributeMappingOptionGroup.AttributeMappingOption(entry.getValue(), new Target(Target.Type.SYSTEM, "COMMUNARDO_UP." + entry.getKey())));
            }
            return communardoOptions;
        }
        return Collections.emptyList();
    }
}

