/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.retransform.config.Transformations;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AttributeTransformationConfig {
    @Nonnull
    private final Target target;
    @Nonnull
    private final Source source;
    @Nonnull
    private final Transformations transformations;
    private final boolean readOnly;
    private final boolean required;

    public AttributeTransformationConfig(Source source2, Target target) {
        this(source2, target, null, false, false);
    }

    public AttributeTransformationConfig(Source source2, Target target, boolean readOnly, boolean required) {
        this(source2, target, null, readOnly, required);
    }

    @JsonCreator
    public AttributeTransformationConfig(@Nonnull @JsonProperty(value="source") Source source2, @Nonnull @JsonProperty(value="target") Target target, @Nullable @JsonProperty(value="transformations") Transformations transformations, @JsonProperty(value="readOnly") boolean readOnly, @JsonProperty(value="required") boolean required) {
        this.source = source2;
        this.target = target;
        this.transformations = transformations == null ? new Transformations(false, null, null, null) : transformations;
        this.readOnly = readOnly;
        this.required = required;
    }

    @Nonnull
    public Source getSource() {
        return this.source;
    }

    @Nonnull
    public Target getTarget() {
        return this.target;
    }

    @Nonnull
    public Transformations getTransformations() {
        return this.transformations;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public static AttributeTransformationConfig create(String sourceKey, Target.Type type, String targetName) {
        Source source2 = Source.createSingle(sourceKey);
        Target target = new Target(type, targetName);
        return new AttributeTransformationConfig(source2, target);
    }

    public static AttributeTransformationConfig create(String sourceKey) {
        Source source2 = Source.createSingle(sourceKey);
        return new AttributeTransformationConfig(source2, Target.createEmpty());
    }

    public static AttributeTransformationConfig create(Source source2) {
        return new AttributeTransformationConfig(source2, Target.createEmpty());
    }

    public static AttributeTransformationConfig create(Source source2, Target target) {
        return new AttributeTransformationConfig(source2, target, false, false);
    }

    public static AttributeTransformationConfig createRequired(Source source2, Target target) {
        return new AttributeTransformationConfig(source2, target, false, true);
    }

    public static AttributeTransformationConfig createRequired(Source source2, Target target, Transformations transformations) {
        return new AttributeTransformationConfig(source2, target, transformations, false, true);
    }

    public static AttributeTransformationConfig createRequired(Target target) {
        return new AttributeTransformationConfig(Source.createUnmapped(), target, false, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeTransformationConfig that = (AttributeTransformationConfig)o;
        return this.target.equals(that.target) && this.source.equals(that.source) && this.transformations.equals(that.transformations);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.source, this.transformations);
    }
}

