/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.regex.tester;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.commons.util.boundedregex.BoundedRegex;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.WebSudoRequiredException;
import de.resolution.reconfigure.api.Configuration;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.regex.tester.RegexMatchTestResult;
import de.resolution.reconfigure.regex.tester.RegexNameId;
import de.resolution.reconfigure.regex.tester.RegexNameIdTestData;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/regexnameid")
public class RegexNameIdTestRestResource<C extends Configuration> {
    private final PrivilegeChecker privilegeChecker;
    private final ConfigurationService<C> configurationService;
    private static final String CC_NO_CACHE_VALUE = "no-cache, no-store, must-revalidate";
    private static final CacheControl CC_NO_CACHE = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private static final Logger logger = LoggerFactory.getLogger(RegexNameIdTestRestResource.class);
    private static final int REGEX_TIMEOUT = 2000;
    private static final int NO_MATCHED_ID = -1;

    @Autowired
    public RegexNameIdTestRestResource(ConfigurationService<C> configurationService, PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
        this.configurationService = configurationService;
    }

    @PUT
    @Path(value="/checknameid/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response check(RegexNameIdTestData testData, @Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        if (request == null) {
            logger.warn("Request must not be null");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(CC_NO_CACHE).build();
        }
        if (testData.input == null || testData.input.trim().isEmpty()) {
            logger.warn("Input string must not be null or empty");
            return Response.ok((Object)new RegexMatchTestResult(false, "Input is empty", -1, -1)).cacheControl(CC_NO_CACHE).build();
        }
        RegexMatchTestResult response = this.selectIdByName(testData.input, testData.nameId, 2000L);
        logger.debug("Checking regex: {}, {}", (Object)response.matched, (Object)response.message);
        return Response.ok((Object)response).cacheControl(CC_NO_CACHE).build();
    }

    public RegexMatchTestResult selectIdByName(String input, List<RegexNameId> nameIdList, long timeout2) {
        if (input == null || input.trim().isEmpty()) {
            logger.warn("Input string must not be null or empty");
            return new RegexMatchTestResult(false, "Input is empty", -1, -1);
        }
        int id = -1;
        int arrayIndex = -1;
        boolean matched = false;
        String message = "No Match";
        int i = 0;
        for (RegexNameId current : nameIdList) {
            try {
                if (BoundedRegex.matches(current.name, input, timeout2)) {
                    matched = true;
                    message = "Match with Id: " + current.id;
                    id = current.id;
                    arrayIndex = i;
                    break;
                }
            }
            catch (TimeoutExceededException | PatternSyntaxException e) {
                message = "Pattern Syntax Error:" + e.getMessage();
                id = -1;
                arrayIndex = -1;
            }
            ++i;
        }
        logger.debug("Regex result: {}, {}", (Object)matched, (Object)message);
        return new RegexMatchTestResult(matched, message, id, arrayIndex);
    }
}

