/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util;

import de.resolution.commons.util.Tuple;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.java.ao.Query;

public class QueryUtil {
    private QueryUtil() {
    }

    @Nonnull
    public static Query create(@Nonnull WherePart wherePart) {
        Tuple<String, List<Object>> fragmentAndValues = wherePart.createFragmentAndValues();
        if (fragmentAndValues.left().isEmpty()) {
            return Query.select();
        }
        return Query.select().where(fragmentAndValues.left(), fragmentAndValues.right().toArray());
    }

    @Nullable
    public static String containing(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return value;
        }
        return "%" + value + "%";
    }

    @Nullable
    public static String startingWith(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return value;
        }
        return value + "%";
    }

    @Nullable
    public static String endingWith(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return value;
        }
        return "%" + value;
    }

    @Nonnull
    public static WherePart any(@Nonnull String fragment, @Nullable List<?> values2) {
        if (values2 == null) {
            return QueryUtil.or(Collections.emptyList());
        }
        List<WherePart> builders = values2.stream().filter(Objects::nonNull).filter(value -> !(value instanceof String) || !((String)value).isEmpty()).map(value -> QueryUtil.where(fragment, value)).collect(Collectors.toList());
        return QueryUtil.or(builders);
    }

    @Nonnull
    public static WherePart and(@Nullable List<WherePart> whereParts) {
        return new WherePart(" AND ", null, whereParts);
    }

    @Nonnull
    public static WherePart and(WherePart ... whereParts) {
        List<WherePart> list = whereParts == null ? Collections.emptyList() : Arrays.asList(whereParts);
        return QueryUtil.and(list);
    }

    @Nonnull
    public static WherePart or(@Nullable List<WherePart> whereParts) {
        return new WherePart(" OR ", null, whereParts);
    }

    @Nonnull
    public static WherePart or(WherePart ... whereParts) {
        List<WherePart> list = whereParts == null ? Collections.emptyList() : Arrays.asList(whereParts);
        return QueryUtil.or(list);
    }

    @Nonnull
    public static WherePart where(@Nonnull String fragment) {
        return QueryUtil.where(true, fragment, Collections.emptyList());
    }

    @Nonnull
    public static WherePart where(boolean condition, @Nonnull String fragment) {
        return QueryUtil.where(condition, fragment, Collections.emptyList());
    }

    @Nonnull
    public static WherePart where(@Nonnull String fragment, @Nullable List<Object> values2) {
        return QueryUtil.where(true, fragment, values2);
    }

    @Nonnull
    public static WherePart where(@Nonnull String fragment, Object ... values2) {
        return QueryUtil.where(true, fragment, values2 == null ? null : Arrays.asList(values2));
    }

    @Nonnull
    public static WherePart where(boolean condition, @Nonnull String fragment, @Nullable List<Object> values2) {
        if (!condition || values2 == null || values2.contains(null)) {
            return new WherePart();
        }
        return new WherePart(fragment, values2);
    }

    @Nonnull
    public static WherePart where(boolean condition, @Nonnull String fragment, Object ... values2) {
        return QueryUtil.where(condition, fragment, values2 == null ? null : Arrays.asList(values2));
    }

    public static class WherePart {
        private final String concatWith;
        private final List<Tuple<String, List<Object>>> fragmentAndValueList;
        private final List<WherePart> whereParts;
        private static final String NOT_RELEVANT_IN_THIS_CASE = "";

        private WherePart() {
            this(NOT_RELEVANT_IN_THIS_CASE, null, null);
        }

        private WherePart(@Nonnull String fragment, @Nonnull List<Object> values2) {
            this(NOT_RELEVANT_IN_THIS_CASE, Collections.singletonList(new Tuple<String, List<Object>>(fragment, values2)), null);
        }

        private WherePart(@Nonnull String concatWith, @Nullable List<Tuple<String, List<Object>>> fragmentsAndValues, @Nullable List<WherePart> whereParts) {
            this.concatWith = concatWith;
            this.fragmentAndValueList = fragmentsAndValues != null ? fragmentsAndValues : Collections.emptyList();
            this.whereParts = whereParts != null ? whereParts : Collections.emptyList();
        }

        @Nonnull
        public Tuple<String, List<Object>> createFragmentAndValues() {
            List fragments = this.fragmentAndValueList.stream().map(Tuple::left).filter(fragment -> !fragment.isEmpty()).collect(Collectors.toList());
            List values2 = this.fragmentAndValueList.stream().filter(fv -> !((String)fv.left()).isEmpty()).map(Tuple::right).flatMap(Collection::stream).collect(Collectors.toList());
            List fromBuilders = this.whereParts.stream().filter(Objects::nonNull).map(WherePart::createFragmentAndValues).filter(fv -> !((String)fv.left()).isEmpty()).collect(Collectors.toList());
            fragments.addAll(fromBuilders.stream().filter(Objects::nonNull).map(Tuple::left).collect(Collectors.toList()));
            values2.addAll(fromBuilders.stream().filter(Objects::nonNull).map(Tuple::right).flatMap(Collection::stream).collect(Collectors.toList()));
            if (fragments.isEmpty()) {
                return new Tuple<String, List<Object>>(NOT_RELEVANT_IN_THIS_CASE, Collections.emptyList());
            }
            if (fragments.size() == 1) {
                return new Tuple<String, List<Object>>((String)fragments.get(0), values2);
            }
            return new Tuple<String, List<Object>>("(" + String.join((CharSequence)this.concatWith, fragments) + ")", values2);
        }
    }
}

