/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.mindrot.jbcrypt.BCrypt;

public class PasswordUtil {
    private static Stream<Character> getRandomAlphabets(int count, boolean upperCase) {
        SecureRandom random = new SecureRandom();
        IntStream characters = upperCase ? random.ints(count, 65, 90) : random.ints(count, 97, 122);
        return characters.mapToObj(data -> Character.valueOf((char)data));
    }

    private static Stream<Character> getRandomNumbers(int count) {
        IntStream numbers = new SecureRandom().ints(count, 48, 57);
        return numbers.mapToObj(data -> Character.valueOf((char)data));
    }

    @Nonnull
    public static String generateSecureRandomToken() {
        return PasswordUtil.generateSecureRandomToken(6, 12, 12);
    }

    @Nonnull
    public static String generateSecureRandomToken(int numberCount, int uppercaseCharacterCount, int lowercaseCharacterCount) {
        Stream<Character> pwdStream = Stream.concat(PasswordUtil.getRandomNumbers(numberCount), Stream.concat(PasswordUtil.getRandomAlphabets(uppercaseCharacterCount, true), PasswordUtil.getRandomAlphabets(lowercaseCharacterCount, false)));
        List charList = pwdStream.collect(Collectors.toList());
        Collections.shuffle(charList);
        return charList.stream().collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
    }

    @Nonnull
    public String hashPlainTextToken(@Nonnull String plainTextToken) {
        String salt = BCrypt.gensalt();
        return BCrypt.hashpw((String)plainTextToken, (String)salt);
    }

    public boolean verifyToken(long validUntilMillis, @Nonnull String plainTextToken, @Nonnull String hashedPlainTextToken) {
        if (validUntilMillis > 0L && System.currentTimeMillis() > validUntilMillis) {
            return false;
        }
        return BCrypt.checkpw((String)plainTextToken, (String)hashedPlainTextToken);
    }

    @Nonnull
    public String generateRandomTokenKey() {
        Stream<Character> tokenKeyStream = Stream.concat(PasswordUtil.getRandomAlphabets(2, false), Stream.concat(PasswordUtil.getRandomAlphabets(2, true), Stream.concat(PasswordUtil.getRandomAlphabets(2, false), PasswordUtil.getRandomAlphabets(2, true))));
        List charList = tokenKeyStream.collect(Collectors.toList());
        Collections.shuffle(charList);
        return charList.stream().collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
    }
}

