/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util;

import java.util.Collection;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(CollectionUtil.class);

    private CollectionUtil() {
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean containsSame(@Nullable Collection<String> collection1, @Nullable Collection<String> collection2) {
        if (collection1 == null && collection2 == null) {
            return true;
        }
        if (collection1 == null || collection2 == null) {
            return false;
        }
        if (collection1.size() != collection2.size()) {
            return false;
        }
        for (String element : collection1) {
            if (collection2.contains(element)) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesAny(@Nonnull String stringToMatch, @Nonnull Collection<String> patternCollection) {
        for (String pattern : patternCollection) {
            try {
                if (!stringToMatch.matches(pattern)) continue;
                return true;
            }
            catch (PatternSyntaxException e) {
                logger.warn("Could not parse Regex {}", (Object)pattern);
            }
        }
        return false;
    }

    public static String formatAsString(@Nonnull Collection<String> collection) {
        if (collection.isEmpty()) {
            return "";
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        String setString = collection.toString();
        return setString.substring(1, setString.length() - 1);
    }
}

