/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.license;

import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;

public class LicenseStatus {
    private final boolean licensed;
    private final String message;
    private final boolean evaluation;
    private final boolean warning;
    private final boolean enforced;
    private final String supportEntitlementNumber;

    public static LicenseStatusBuilder builder() {
        return new LicenseStatusBuilder();
    }

    public static LicenseStatusBuilder builder(PluginLicense pluginLicense) {
        return new LicenseStatusBuilder(pluginLicense);
    }

    private LicenseStatus(boolean licensed, boolean evaluation, boolean warning, boolean enforced, String message, String supportEntitlementNumber) {
        this.licensed = licensed;
        this.message = message;
        this.evaluation = evaluation;
        this.warning = warning;
        this.enforced = enforced;
        this.supportEntitlementNumber = supportEntitlementNumber;
    }

    public boolean isLicensed() {
        return this.licensed;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isEvaluation() {
        return this.evaluation;
    }

    public boolean isWarning() {
        return this.warning;
    }

    public boolean isEnforced() {
        return this.enforced;
    }

    public String getSupportEntitlementNumber() {
        return this.supportEntitlementNumber;
    }

    public static class LicenseStatusBuilder {
        private boolean licensed = false;
        private boolean evaluation = false;
        private boolean warning = false;
        private boolean enforced = true;
        private String message = "";
        private String supportEntitlementNumber = "UNDEFINED";

        public LicenseStatusBuilder() {
        }

        public LicenseStatusBuilder(PluginLicense pluginLicense) {
            this.licensed = pluginLicense.isValid();
            this.evaluation = pluginLicense.isEvaluation();
        }

        public LicenseStatusBuilder licensed(boolean licensed) {
            this.licensed = licensed;
            return this;
        }

        public LicenseStatusBuilder message(String message) {
            this.message = message;
            return this;
        }

        public LicenseStatusBuilder evaluation(boolean evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        public LicenseStatusBuilder warning(boolean warning) {
            this.warning = warning;
            return this;
        }

        public LicenseStatusBuilder enforced(boolean enforced) {
            this.enforced = enforced;
            return this;
        }

        public LicenseStatusBuilder supportEntitlementNumber(Option<String> supportEntitlementNumberOption) {
            if (supportEntitlementNumberOption.isDefined()) {
                this.supportEntitlementNumber = (String)supportEntitlementNumberOption.get();
            }
            return this;
        }

        public LicenseStatus build() {
            return new LicenseStatus(this.licensed, this.evaluation, this.warning, this.enforced, this.message, this.supportEntitlementNumber);
        }
    }
}

