/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.license;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseInstaller {
    private final PluginSettings pluginSettings;
    private static final Integer MAX_KEY_LENGTH = 100;
    private static final String LICENSED_APPS_LIST_STORAGE_KEY = LicenseInstaller.hashKey("com.atlassian.upm.license.internal.impl.PluginSettingsPluginLicenseRepository:licenses:all_stored_licenses");

    @Autowired
    public LicenseInstaller(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @Nonnull
    public List<String> getLicensedAppKeys() {
        ArrayList keys2 = (ArrayList)this.pluginSettings.get(LICENSED_APPS_LIST_STORAGE_KEY);
        if (keys2 == null) {
            keys2 = new ArrayList();
        }
        return keys2;
    }

    public void storeLicense(@Nonnull String appKey, @Nonnull String licenseKey) {
        this.pluginSettings.put(LicenseInstaller.getAppStorageKey(appKey), (Object)licenseKey);
        List<String> licensedAppKeys = this.getLicensedAppKeys();
        if (!licensedAppKeys.contains(appKey)) {
            licensedAppKeys.add(appKey);
        }
        this.pluginSettings.put(LICENSED_APPS_LIST_STORAGE_KEY, licensedAppKeys);
    }

    @Nonnull
    public static String getAppStorageKey(@Nonnull String appKey) {
        return LicenseInstaller.hashKey("com.atlassian.upm.license.internal.impl.PluginSettingsPluginLicenseRepository:licenses:" + appKey);
    }

    @Nonnull
    public static String hashKey(@Nonnull String key) {
        if (key.length() > MAX_KEY_LENGTH) {
            String keyHash = DigestUtils.md5Hex(key);
            String keptOriginalKey = key.substring(0, MAX_KEY_LENGTH - keyHash.length());
            return keptOriginalKey + keyHash;
        }
        return key;
    }
}

