/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.license;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import de.resolution.commons.license.LicenseStatus;
import de.resolution.commons.license.PluginProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="licenseChecker")
public class LicenseChecker {
    public static final Logger logger = LoggerFactory.getLogger(LicenseChecker.class);
    private final PluginLicenseManager pluginLicenseManager;
    private final HostLicenseInformation hostLicenseInformation;
    private final boolean enforceLicense;

    @Autowired
    public LicenseChecker(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport HostLicenseInformation hostLicenseInformation) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.hostLicenseInformation = hostLicenseInformation;
        if (Boolean.parseBoolean(PluginProperties.get("licensingEnabled"))) {
            this.enforceLicense = true;
            logger.info("License is enforced");
        } else {
            this.enforceLicense = false;
            logger.info("License is not enforced");
        }
    }

    public LicenseStatus checkLicense() {
        try {
            return this.doCheck();
        }
        catch (Exception e) {
            logger.error("Got an exception during license check", (Throwable)e);
            return LicenseStatus.builder().licensed(false).message("Encountered exception during license check:\n" + e.getMessage()).build();
        }
    }

    private LicenseStatus doCheck() {
        if (!this.enforceLicense) {
            return LicenseStatus.builder().enforced(false).message("License is not enforced").build();
        }
        if (!this.pluginLicenseManager.getLicense().isDefined()) {
            return LicenseStatus.builder().enforced(true).licensed(false).message("No License installed").build();
        }
        PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
        if (logger.isDebugEnabled()) {
            String errorString = this.hostLicenseInformation.getEdition().isDefined() ? ((Integer)this.hostLicenseInformation.getEdition().get()).toString() : "No Error";
            logger.debug("Host Datacenter: {}, valid: {}, validForDc: {}, DC: {}, Error: {}", new Object[]{this.hostLicenseInformation.isDataCenter(), license.isValid(), license.isValidForDc(), license.isDataCenter(), errorString});
        }
        if (!license.getError().isDefined()) {
            return LicenseStatus.builder().enforced(true).licensed(true).evaluation(license.isEvaluation()).message("License is valid").supportEntitlementNumber((Option<String>)license.getSupportEntitlementNumber()).build();
        }
        LicenseError error = (LicenseError)license.getError().get();
        if (error == LicenseError.EXPIRED) {
            if (license.isEvaluation()) {
                return LicenseStatus.builder().licensed(false).message("Evaluation License is expired").evaluation(true).supportEntitlementNumber((Option<String>)license.getSupportEntitlementNumber()).build();
            }
            if (this.hostLicenseInformation.isDataCenter()) {
                return LicenseStatus.builder().licensed(false).message("Data Center License is expired").supportEntitlementNumber((Option<String>)license.getSupportEntitlementNumber()).build();
            }
            return LicenseStatus.builder().licensed(true).warning(true).message("License is expired but still valid here").supportEntitlementNumber((Option<String>)license.getSupportEntitlementNumber()).build();
        }
        if (error == LicenseError.VERSION_MISMATCH) {
            return LicenseStatus.builder().licensed(false).message("This license is valid for older versions only. The App will not work.").supportEntitlementNumber((Option<String>)license.getSupportEntitlementNumber()).build();
        }
        return LicenseStatus.builder().licensed(false).message("License Error: " + error.name()).supportEntitlementNumber((Option<String>)license.getSupportEntitlementNumber()).build();
    }
}

