/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.confluence;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.Group;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
public class ConfluenceUtil {
    private final UserAccessor userAccessor;
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceUtil.class);

    @Autowired
    public ConfluenceUtil(@ConfluenceImport UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public ConfluenceUser findExecutionUser() {
        String executionUserName = this.findExecutionUserName();
        logger.debug("Using {} as execution user", (Object)executionUserName);
        return this.userAccessor.getUserByName(executionUserName);
    }

    public String findExecutionUserName() {
        Group adminGroup = this.userAccessor.getGroup("confluence-administrators");
        List membersOfAdminGroup = this.userAccessor.getMemberNamesAsList(adminGroup);
        Optional<String> adminUser = membersOfAdminGroup.stream().filter(username -> username.equalsIgnoreCase("admin")).findFirst();
        if (adminUser.isPresent()) {
            return adminUser.get();
        }
        adminUser = membersOfAdminGroup.stream().filter(username -> username.equalsIgnoreCase("administrator")).findFirst();
        if (adminUser.isPresent()) {
            return adminUser.get();
        }
        adminUser = membersOfAdminGroup.stream().filter(username -> username.toLowerCase().contains("admin")).findFirst();
        if (adminUser.isPresent()) {
            return adminUser.get();
        }
        String first = (String)membersOfAdminGroup.get(0);
        logger.debug("Returning first member of confluence-users {}", (Object)first);
        return first;
    }
}

