/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.atlasuser.api.CancelHandle;
import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.InvalidSearchFilterException;
import de.resolution.atlasuser.api.exception.UnexpectedAttributeValueException;
import de.resolution.atlasuser.api.user.ApplicationAccessAdapter;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserKeys;
import de.resolution.atlasuser.api.user.SearchFilter;
import de.resolution.atlasuser.api.user.SortBy;
import de.resolution.atlasuser.api.user.UserSearchResult;
import de.resolution.atlasuser.impl.user.ApplicationAttributeAdapter;
import de.resolution.atlasuser.impl.user.UserSearchResultEntry;
import de.resolution.atlasuser.impl.user.UserSearchResultImpl;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={UserSearcher.class})
public class UserSearcher {
    private static final Logger logger = LoggerFactory.getLogger(UserSearcher.class);
    private static final Logger performanceLogger = LoggerFactory.getLogger((String)"de.resolution.atlasuser.performance");
    private final DirectoryAdapter directoryAdapter;
    private final DirectoryManager directoryManager;
    private final ApplicationAccessAdapter applicationAccessAdapter;
    private final ApplicationAttributeAdapter applicationAttributeAdapter;
    private final CrowdService crowdService;
    public static final int DEFAULT_BATCH_SIZE = 1000;

    @Autowired
    public UserSearcher(DirectoryAdapter directoryAdapter, ApplicationAccessAdapter applicationAccessAdapter, ApplicationAttributeAdapter applicationAttributeAdapter, @ComponentImport DirectoryManager directoryManager, @ComponentImport CrowdService crowdService) {
        this.directoryAdapter = directoryAdapter;
        this.applicationAccessAdapter = applicationAccessAdapter;
        this.applicationAttributeAdapter = applicationAttributeAdapter;
        this.directoryManager = directoryManager;
        this.crowdService = crowdService;
    }

    public UserSearchResult search(@Nonnull SearchFilter searchFilter, @Nonnull SortBy sortBy, CancelHandle cancelHandle, AtlasUserAdapter atlasUserAdapter) throws AtlasUserOperationFailedException, de.resolution.atlasuser.api.exception.DirectoryNotFoundException, InvalidSearchFilterException {
        return this.search(searchFilter, sortBy, cancelHandle, atlasUserAdapter, 1000);
    }

    @Nonnull
    public UserSearchResult search(@Nonnull SearchFilter searchFilter, @Nonnull SortBy sortBy, CancelHandle cancelHandle, AtlasUserAdapter atlasUserAdapter, int batchSize) throws AtlasUserOperationFailedException, de.resolution.atlasuser.api.exception.DirectoryNotFoundException, InvalidSearchFilterException {
        long tsStart = System.nanoTime();
        UserSearchResultImpl resultImpl = new UserSearchResultImpl(atlasUserAdapter, this.directoryManager, this.applicationAttributeAdapter, sortBy);
        long directoryId = searchFilter.getDirectoryId();
        if (directoryId == -3L) {
            logger.debug("Searching users in all directories");
            List<AtlasUserDirectory> directories = this.directoryAdapter.getDirectories();
            for (int i = 0; i < directories.size(); ++i) {
                AtlasUserDirectory directory = directories.get(i);
                if (directory.isActive()) {
                    logger.debug("Searching in directory {} ", (Object)directory.getId());
                    try {
                        resultImpl.addAll(this.doSearch(directory.getId(), i, searchFilter, sortBy, cancelHandle, batchSize, Collections.emptySet()));
                        continue;
                    }
                    catch (OperationFailedException e) {
                        throw new AtlasUserOperationFailedException(e);
                    }
                    catch (DirectoryNotFoundException e) {
                        throw new de.resolution.atlasuser.api.exception.DirectoryNotFoundException(directoryId);
                    }
                }
                logger.debug("Skipping inactive directory {}:{}", (Object)directory.getId(), (Object)directory.getName());
            }
        } else {
            try {
                resultImpl.addAll(this.doSearch(directoryId, 0, searchFilter, sortBy, cancelHandle, batchSize, Collections.emptySet()));
            }
            catch (OperationFailedException e) {
                throw new AtlasUserOperationFailedException(e);
            }
            catch (DirectoryNotFoundException e) {
                logger.warn("Directory not found", (Throwable)e);
                throw new de.resolution.atlasuser.api.exception.DirectoryNotFoundException(directoryId);
            }
        }
        if (cancelHandle.isCancelled()) {
            resultImpl.cancel();
            return resultImpl;
        }
        resultImpl.sort();
        if (cancelHandle.isCancelled()) {
            resultImpl.cancel();
        }
        if (performanceLogger.isDebugEnabled()) {
            long tsEnd = System.nanoTime();
            performanceLogger.debug("## {} Search took {}us", (Object)directoryId, (Object)((tsEnd - tsStart) / 1000L));
        }
        return resultImpl;
    }

    private void findUsersInAnyDirectory(SearchFilter searchFilter, int batchSize, SortBy sortBy, List<UserSearchResultEntry> resultList, CancelHandle cancelHandle) {
        int resultCount;
        int batchCount = 1;
        int startIndex = 0;
        BooleanRestriction restriction = null;
        if (searchFilter.getBaseAttributesContain() != null) {
            restriction = Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchFilter.getBaseAttributesContain()), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchFilter.getBaseAttributesContain()), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchFilter.getBaseAttributesContain())});
        }
        do {
            if (cancelHandle.isCancelled()) {
                logger.warn("Cancelled while searching in any directory");
                return;
            }
            EntityQuery userQuery = restriction != null ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(this.createRestriction(searchFilter)).startingAt(startIndex).returningAtMost(batchSize) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(startIndex).returningAtMost(batchSize);
            Iterable currentBatchUserList = this.crowdService.search((Query)userQuery);
            logger.debug("Executed batch {} starting at {} ", (Object)batchCount, (Object)startIndex);
            resultCount = 0;
            for (User crowdUser : currentBatchUserList) {
                if (searchFilter.getActivityState() == null || Boolean.TRUE.equals(searchFilter.getActivityState()) && crowdUser.isActive() || Boolean.FALSE.equals(searchFilter.getActivityState()) && !crowdUser.isActive()) {
                    ++resultCount;
                    resultList.add(new UserSearchResultEntry(crowdUser, 0, sortBy));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Skipping {} with active state {} not matching the activity state filter {}", new Object[]{crowdUser.getName(), crowdUser.isActive(), searchFilter.getActivityState()});
            }
            if (cancelHandle.isCancelled()) {
                logger.warn("Cancelled while searching in any directory");
                return;
            }
            startIndex += batchSize;
            ++batchCount;
        } while (resultCount >= batchSize);
    }

    private void findUsersInAnyDirectorySequentially(SearchFilter searchFilter, int batchSize, int directoryOrder, SortBy sortBy, List<UserSearchResultEntry> resultList, CancelHandle cancelHandle) throws DirectoryNotFoundException, OperationFailedException {
        HashSet<String> seenUsernames = new HashSet<String>();
        List<AtlasUserDirectory> directories = this.directoryAdapter.getDirectories();
        Iterator<AtlasUserDirectory> directoryIterator = directories.iterator();
        while (directoryIterator.hasNext()) {
            if (cancelHandle.isCancelled()) {
                logger.warn("Cancelled while searching in any directory sequentially");
                return;
            }
            AtlasUserDirectory directory = directoryIterator.next();
            if (directory.isActive()) {
                logger.debug("Searching directory {}:{}", (Object)directory.getId(), (Object)directory.getName());
                this.findUsersInSpecificDirectory(directory.getId(), searchFilter, batchSize, directoryOrder, sortBy, resultList, seenUsernames, cancelHandle);
                if (!directoryIterator.hasNext()) continue;
                seenUsernames.addAll(this.getAllUsernamesInDirectory(directory.getId(), batchSize));
                continue;
            }
            logger.debug("Skipping inactive directory {}:{}", (Object)directory.getId(), (Object)directory.getName());
        }
    }

    private void findUsersInSpecificDirectory(long directoryId, @Nonnull SearchFilter searchFilter, int batchSize, int directoryOrder, @Nonnull SortBy sortBy, @Nonnull List<UserSearchResultEntry> resultList, @Nonnull Set<String> seenUsernames, @Nonnull CancelHandle cancelHandle) throws DirectoryNotFoundException, OperationFailedException {
        List currentBatchUserList;
        if (this.checkSearchByGroupMemberships(searchFilter, sortBy)) {
            logger.debug("Searching based on group memberships instead of doing a directory search");
            List<String> groupMembers = this.searchGroupMemberships(directoryId, searchFilter.getInGroups());
            for (String memberName : groupMembers) {
                resultList.add(new UserSearchResultEntry(memberName, directoryId, directoryOrder));
            }
            return;
        }
        int batchCount = 1;
        int startIndex = 0;
        do {
            if (cancelHandle.isCancelled()) {
                logger.warn("Cancelled while searching directory {}", (Object)directoryId);
                return;
            }
            SearchRestriction restriction = this.createRestriction(searchFilter);
            EntityQuery userQuery = restriction != null ? QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).with(this.createRestriction(searchFilter)).startingAt(startIndex).returningAtMost(batchSize) : QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(startIndex).returningAtMost(batchSize);
            currentBatchUserList = this.directoryManager.searchUsers(directoryId, userQuery);
            logger.debug("Executed batch {} starting at {} returning {} users", new Object[]{batchCount, startIndex, currentBatchUserList.size()});
            for (com.atlassian.crowd.model.user.User crowdUser : currentBatchUserList) {
                if (!seenUsernames.contains(crowdUser.getName())) {
                    resultList.add(new UserSearchResultEntry(crowdUser, directoryOrder, sortBy));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Skipping {} seen in higher directory", (Object)crowdUser.getName());
            }
            if (cancelHandle.isCancelled()) {
                logger.warn("Cancelled while searching directory {}", (Object)directoryId);
                return;
            }
            startIndex += batchSize;
            ++batchCount;
        } while (currentBatchUserList.size() >= batchSize);
    }

    private boolean checkSearchByGroupMemberships(@Nonnull SearchFilter searchFilter, @Nonnull SortBy sortBy) {
        if (!searchFilter.isSearchByGroupMemberships()) {
            return false;
        }
        if (searchFilter.getBaseAttributesContain() == null && sortBy.isByName() && !searchFilter.getInGroups().isEmpty() && searchFilter.getActivityState() == null) {
            return true;
        }
        logger.warn("searchByGroupMemberships is selected but not supported with this search filter.");
        return false;
    }

    private List<UserSearchResultEntry> filterByApplicationAccess(SearchFilter searchFilter, List<UserSearchResultEntry> resultList, long directoryId) throws InvalidSearchFilterException, DirectoryNotFoundException, OperationFailedException {
        List<String> usersWithAccess;
        if (searchFilter.getApplicationAccess() == null || searchFilter.getApplicationAccess().isEmpty()) {
            return resultList;
        }
        ArrayList<String> groupList = new ArrayList<String>();
        if (searchFilter.getApplicationAccess().contains("NO_APPLICATION")) {
            if (searchFilter.getApplicationAccess().size() > 1) {
                throw new InvalidSearchFilterException("NO_APPLICATION must be the only applicationKey if used for filtering");
            }
            Set<String> groupsWithApplicationAccess = this.applicationAccessAdapter.getGroupsGivingAccess("ANY_APPLICATION");
            List<String> usernamesWithApplicationAccess = this.searchGroupMemberships(directoryId, groupsWithApplicationAccess);
            usernamesWithApplicationAccess.addAll(this.applicationAccessAdapter.getUsersWithDirectAccess("ANY_APPLICATION"));
            return resultList.stream().filter(entry -> !usernamesWithApplicationAccess.contains(entry.getUsername())).collect(Collectors.toList());
        }
        if (searchFilter.getApplicationAccess().contains("ANY_APPLICATION")) {
            if (searchFilter.getApplicationAccess().size() > 1) {
                throw new InvalidSearchFilterException("ANY_APPLICATION must be the only applicationKey if used for filtering");
            }
            Set<String> groupsWithApplicationAccess = this.applicationAccessAdapter.getGroupsGivingAccess("ANY_APPLICATION");
            List<String> usernamesWithApplicationAccess = this.searchGroupMemberships(directoryId, groupsWithApplicationAccess);
            usernamesWithApplicationAccess.addAll(this.applicationAccessAdapter.getUsersWithDirectAccess("ANY_APPLICATION"));
            return resultList.stream().filter(entry -> usernamesWithApplicationAccess.contains(entry.getUsername())).collect(Collectors.toList());
        }
        searchFilter.getApplicationAccess().forEach(applicationKey -> groupList.addAll(this.applicationAccessAdapter.getGroupsGivingAccess((String)applicationKey)));
        if (groupList.isEmpty()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Group list for application access {} is empty in directory {}", (Object)String.join((CharSequence)",", searchFilter.getApplicationAccess()), (Object)directoryId);
            }
            usersWithAccess = new ArrayList<String>();
        } else {
            usersWithAccess = this.searchGroupMemberships(directoryId, groupList);
        }
        searchFilter.getApplicationAccess().forEach(applicationKey -> usersWithAccess.addAll(this.applicationAccessAdapter.getUsersWithDirectAccess((String)applicationKey)));
        return resultList.stream().filter(entry -> usersWithAccess.contains(entry.getUsername())).collect(Collectors.toList());
    }

    private List<UserSearchResultEntry> filterByAttributeFilterOrLastKnownActivity(@Nonnull SearchFilter searchFilter, @Nonnull List<UserSearchResultEntry> resultList) throws DirectoryNotFoundException, OperationFailedException, InvalidSearchFilterException {
        if (!searchFilter.hasAttributeFilter() && !searchFilter.hasLastKnownActivity()) {
            return resultList;
        }
        ArrayList<UserSearchResultEntry> filtered = new ArrayList<UserSearchResultEntry>();
        for (UserSearchResultEntry entry : resultList) {
            try {
                UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(entry.getDirectoryId(), entry.getUsername());
                boolean matchedAttributeFilter = searchFilter.hasAttributeFilter() && searchFilter.getAttributeFilters().stream().allMatch(attributeFilter -> {
                    HashMap<String, Set> attributeMap = new HashMap<String, Set>();
                    for (String filterAttributeName : attributeFilter.getAttributeNames()) {
                        if (filterAttributeName.equals("ATTR_EMAIL")) {
                            attributeMap.put(filterAttributeName, Collections.singleton(userWithAttributes.getEmailAddress()));
                            continue;
                        }
                        if (filterAttributeName.equals("ATTR_NAME")) {
                            attributeMap.put(filterAttributeName, Collections.singleton(userWithAttributes.getName()));
                            continue;
                        }
                        Set values2 = userWithAttributes.getValues(filterAttributeName);
                        if (values2 == null || values2.isEmpty()) continue;
                        attributeMap.put(filterAttributeName, values2);
                    }
                    return attributeFilter.getAttributeNames().stream().anyMatch(attributeName -> attributeFilter.test(attributeMap));
                });
                boolean matchedLastKnownActivityPresent = false;
                boolean matchedLastKnownActivityBefore = false;
                boolean matchedLastKnownActivityOnOrAfter = false;
                if (searchFilter.hasLastKnownActivity()) {
                    long lastKnownActivityFromAttribute = this.getLastKnownActivityFromAttribute(userWithAttributes, searchFilter);
                    if (lastKnownActivityFromAttribute > 0L) {
                        matchedLastKnownActivityPresent = searchFilter.getLastKnownActivityPresent() != null && searchFilter.getLastKnownActivityPresent() != false;
                        matchedLastKnownActivityBefore = searchFilter.getLastKnownActivityBefore() != null && lastKnownActivityFromAttribute < searchFilter.getLastKnownActivityBefore();
                        matchedLastKnownActivityOnOrAfter = searchFilter.getLastKnownActivityOnOrAfter() != null && lastKnownActivityFromAttribute >= searchFilter.getLastKnownActivityOnOrAfter();
                    } else {
                        long lastActivityFromApplication = this.applicationAttributeAdapter.getLastAuthenticatedFromApplicationLevel((com.atlassian.crowd.model.user.User)userWithAttributes);
                        if (lastActivityFromApplication > 0L) {
                            matchedLastKnownActivityPresent = searchFilter.getLastKnownActivityPresent() != null && searchFilter.getLastKnownActivityPresent() != false;
                            matchedLastKnownActivityBefore = searchFilter.getLastKnownActivityBefore() != null && lastActivityFromApplication < searchFilter.getLastKnownActivityBefore();
                            matchedLastKnownActivityOnOrAfter = searchFilter.getLastKnownActivityOnOrAfter() != null && lastActivityFromApplication >= searchFilter.getLastKnownActivityOnOrAfter();
                        } else {
                            boolean bl = matchedLastKnownActivityPresent = searchFilter.getLastKnownActivityPresent() != null && searchFilter.getLastKnownActivityPresent() == false;
                        }
                    }
                }
                if (searchFilter.hasAttributeFilter() && !matchedAttributeFilter || searchFilter.getLastKnownActivityPresent() != null && !matchedLastKnownActivityPresent || searchFilter.getLastKnownActivityBefore() != null && !matchedLastKnownActivityBefore || searchFilter.getLastKnownActivityOnOrAfter() != null && !matchedLastKnownActivityOnOrAfter) continue;
                filtered.add(entry);
            }
            catch (UserNotFoundException e) {
                logger.warn("User {} was not found in directory {} and is filtered out of the result.", (Object)entry.getUsername(), (Object)entry.getDirectoryId());
            }
        }
        return filtered;
    }

    @Nullable
    private List<UserSearchResultEntry> doSearch(long directoryId, int directoryOrder, @Nonnull SearchFilter searchFilter, @Nonnull SortBy sortBy, CancelHandle cancelHandle, int batchSize, Set<String> seenUsernames) throws OperationFailedException, DirectoryNotFoundException, InvalidSearchFilterException {
        List<String> groupMembers;
        List<UserSearchResultEntry> resultList = new ArrayList<UserSearchResultEntry>();
        if (directoryId == -1L) {
            logger.debug("Searching in directory {} only", (Object)directoryId);
            this.findUsersInAnyDirectory(searchFilter, batchSize, sortBy, resultList, cancelHandle);
        } else if (directoryId == -4L) {
            logger.debug("Searching sequentially in all directories");
            this.findUsersInAnyDirectorySequentially(searchFilter, batchSize, directoryOrder, sortBy, resultList, cancelHandle);
        } else {
            this.findUsersInSpecificDirectory(directoryId, searchFilter, batchSize, directoryOrder, sortBy, resultList, seenUsernames, cancelHandle);
        }
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled during search");
            return null;
        }
        if (searchFilter.getIncludedUsernames() != null && !searchFilter.getIncludedUsernames().isEmpty()) {
            resultList = resultList.stream().filter(result -> searchFilter.getIncludedUsernames().contains(result.getUsername())).collect(Collectors.toList());
        }
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled before filtering by application access");
            return null;
        }
        logger.debug("Finished loading basic users, filtering by application access now");
        resultList = this.filterByApplicationAccess(searchFilter, resultList, directoryId);
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled before filtering by groups in directory {}", (Object)directoryId);
            return null;
        }
        if (searchFilter.getInGroups() != null && !searchFilter.getInGroups().isEmpty()) {
            groupMembers = this.searchGroupMemberships(directoryId, searchFilter.getInGroups());
            resultList = resultList.stream().filter(entry -> groupMembers.contains(entry.getUsername())).collect(Collectors.toList());
        }
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled before filtering by not-in-group in directory {}", (Object)directoryId);
            return null;
        }
        if (searchFilter.getNotInGroups() != null && !searchFilter.getNotInGroups().isEmpty()) {
            groupMembers = this.searchGroupMemberships(directoryId, searchFilter.getNotInGroups());
            resultList = resultList.stream().filter(entry -> !groupMembers.contains(entry.getUsername())).collect(Collectors.toList());
        }
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled before filtering by notTheseIds in directory {}", (Object)directoryId);
            return null;
        }
        if (searchFilter.getExcludedUsernames() != null && !searchFilter.getExcludedUsernames().isEmpty()) {
            resultList = resultList.stream().filter(entry -> !searchFilter.getExcludedUsernames().contains(entry.getUsername())).collect(Collectors.toList());
        }
        if (cancelHandle.isCancelled()) {
            logger.warn("Cancelled before filtering by attribute in directory {}", (Object)directoryId);
            return null;
        }
        return this.filterByAttributeFilterOrLastKnownActivity(searchFilter, resultList);
    }

    @Nonnull
    public Set<String> getAllUsernamesInDirectory(long directoryId, int batchSize) throws DirectoryNotFoundException, OperationFailedException {
        int lastBatchResultSize;
        HashSet<String> userNameList = new HashSet<String>();
        int startIndex = 0;
        do {
            EntityQuery userQuery = QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(startIndex).returningAtMost(batchSize);
            List userList = this.directoryManager.searchUsers(directoryId, userQuery);
            Set listFromBatch = userList.stream().map(Principal::getName).collect(Collectors.toSet());
            userNameList.addAll(listFromBatch);
            lastBatchResultSize = listFromBatch.size();
            startIndex += lastBatchResultSize;
        } while (lastBatchResultSize == batchSize);
        return userNameList;
    }

    @Nullable
    private SearchRestriction createRestriction(SearchFilter searchFilter) {
        ArrayList<Object> searchRestrictions = new ArrayList<Object>();
        if (searchFilter.getBaseAttributesContain() != null) {
            searchRestrictions.add(Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchFilter.getBaseAttributesContain()), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchFilter.getBaseAttributesContain()), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchFilter.getBaseAttributesContain())}));
        }
        if (searchFilter.getActivityState() != null) {
            searchRestrictions.add(Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)searchFilter.getActivityState()));
        }
        if (searchRestrictions.isEmpty()) {
            return null;
        }
        return Combine.allOf(searchRestrictions);
    }

    private List<String> searchGroupMemberships(long directoryId, Collection<String> groupNames) throws DirectoryNotFoundException, OperationFailedException {
        if (this.applicationAttributeAdapter.canSearchMembershipsForMultipleGroups()) {
            return this.searchGroupMembershipsWithSingleQuery(directoryId, groupNames);
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String groupName : groupNames) {
            logger.debug("Loading members of group {}", (Object)groupName);
            List<String> currentMembers = this.searchGroupMembershipsWithSingleQuery(directoryId, Collections.singleton(groupName));
            for (String member : currentMembers) {
                if (ret.contains(member)) continue;
                ret.add(member);
            }
        }
        return ret;
    }

    private List<String> searchGroupMembershipsWithSingleQuery(long directoryId, Collection<String> groupNames) throws DirectoryNotFoundException, OperationFailedException {
        if (groupNames == null || groupNames.isEmpty()) {
            return new ArrayList<String>();
        }
        if (directoryId == -1L || directoryId == -4L) {
            ArrayList<String> resultList = new ArrayList<String>();
            for (Directory directory : this.directoryManager.findAllDirectories()) {
                resultList.addAll(this.searchGroupMembershipsWithSingleQuery(directory.getId(), groupNames));
            }
            return resultList;
        }
        String[] groupNameArray = new String[groupNames.size()];
        groupNames.toArray(groupNameArray);
        MembershipQuery groupQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(groupNameArray).returningAtMost(Integer.MAX_VALUE);
        return this.directoryManager.searchDirectGroupRelationships(directoryId, groupQuery);
    }

    public long getLastKnownActivityFromAttribute(UserWithAttributes userWithAttributes, SearchFilter searchFilter) throws InvalidSearchFilterException {
        long retValue = AtlasUserKeys.NO_TIMESTAMP_AVAILABLE;
        for (String attribute : searchFilter.getAttributesForLastKnownActivity()) {
            retValue = Math.max(this.readLongAttribute(userWithAttributes, attribute), retValue);
        }
        return retValue;
    }

    private long readLongAttribute(UserWithAttributes userWithAttributes, String key) throws UnexpectedAttributeValueException {
        String stringValue = userWithAttributes.getValue(key);
        if (stringValue == null) {
            return AtlasUserKeys.NO_TIMESTAMP_AVAILABLE;
        }
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            throw new UnexpectedAttributeValueException("Could not parse long from " + stringValue + " read from key " + key + " on user " + userWithAttributes.getName() + " from directory " + userWithAttributes.getDirectoryId());
        }
    }
}

