/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.resolution.atlasuser.api.AtlasUserStatusObject;
import de.resolution.atlasuser.api.CancelHandle;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.LicenseCountProvider;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.atlasuser.api.exception.AtlasUserNotUniqueException;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.AtlasUserValidationFailedException;
import de.resolution.atlasuser.api.exception.AttributeNotSearchableException;
import de.resolution.atlasuser.api.exception.AttributeNotUniqueException;
import de.resolution.atlasuser.api.exception.DirectoryInactiveException;
import de.resolution.atlasuser.api.exception.InvalidSearchFilterException;
import de.resolution.atlasuser.api.exception.MissingAttributeException;
import de.resolution.atlasuser.api.exception.MissingResultingUserException;
import de.resolution.atlasuser.api.user.ApplicationAccessAdapter;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserFunction;
import de.resolution.atlasuser.api.user.AtlasUserKeys;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.api.user.AtlasUserValidator;
import de.resolution.atlasuser.api.user.SearchFilter;
import de.resolution.atlasuser.api.user.SortBy;
import de.resolution.atlasuser.api.user.UserSearchResult;
import de.resolution.atlasuser.impl.AttributeIndex;
import de.resolution.atlasuser.impl.ExceptionToResultBuilderMapper;
import de.resolution.atlasuser.impl.user.ApplicationAttributeAdapter;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.atlasuser.impl.user.PermissionChecker;
import de.resolution.atlasuser.impl.user.UserSearcher;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.JSONUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={AtlasUserAdapter.class, CrowdApiAtlasUserAdapter.class})
public class CrowdApiAtlasUserAdapter
implements AtlasUserAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CrowdApiAtlasUserAdapter.class);
    private static final int BATCH_SIZE = 500;
    private final DirectoryManager directoryManager;
    private final AtlasUserValidator atlasUserValidator;
    private final ApplicationAttributeAdapter applicationAttributeAdapter;
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final DirectoryAdapter directoryAdapter;
    private final PermissionChecker permissionChecker;
    private final TransactionTemplate transactionTemplate;
    private final ApplicationAccessAdapter applicationAccessAdapter;
    private final UserSearcher userSearcher;
    private final LicenseCountProvider licenseCountProvider;
    public static final List<String> SPECIAL_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("ATTR_EMAIL", "ATTR_FULLNAME", "ATTR_FIRSTNAME", "ATTR_LASTNAME", "ATTR_NAME", "ATTR_NEW_NAME", "ATTR_ID", "ATTR_USER_KEY", "ATTR_ACTIVE", "ATTR_GROUPS", "ATTR_GROUPS_TO_KEEP", "ATTR_IS_CREATE_GROUPS", "ATTR_IS_KEEP_GROUPS", "ATTR_PASSWORD", "ATLAS_USER_TIMESTAMP", "ATLAS_USER_SIMULATE_TIMESTAMP", "ATTR_IS_ADMIN", "ATTR_IS_SYSADMIN", "ATTR_LAST_KNOWN_ACTIVITY", "ATTR_LAST_AUTH_CONSOLIDATED", "ATTR_BITBUCKET_LAST_AUTHENTICATED", "ATTR_CONFLUENCE_LAST_AUTHENTICATED", "ATTR_PROFILE_PICTURE_DATA"));
    public static final List<String> NOT_SEARCHABLE_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("ATTR_ACTIVE", "lastAuthenticated", "login.count", "login.lastLoginMillis", "ATTR_PASSWORD", "ATLAS_USER_TIMESTAMP", "ATTR_LAST_KNOWN_ACTIVITY", "lastActivityMillis", "ATTR_LAST_AUTH_CONSOLIDATED", "ATTR_BITBUCKET_LAST_AUTHENTICATED", "ATTR_CONFLUENCE_LAST_AUTHENTICATED", "ATTR_PROFILE_PICTURE_DATA"));
    public static final List<String> ATTRIBUTES_NOT_TO_INCLUDE_IN_SIMULATED_CREATE_RESULT = Collections.unmodifiableList(Arrays.asList("ATTR_PROFILE_PICTURE_DATA", "ATTR_GROUPS_TO_KEEP", "ATTR_IS_KEEP_GROUPS", "ATTR_IS_CREATE_GROUPS", "ATTR_IS_ANONYMIZED", "ATTR_NEW_NAME"));
    private final List<String> keys;
    private static final String STRING_TRUE = "true";
    private static final String STRING_FALSE = "false";

    private static String createReadOnlyMessage(long directoryId, String name) {
        return "Directory <" + directoryId + "> seems to be read only, so the user <" + name + "> won't be updated, even though user update is enabled in settings.";
    }

    private static boolean isFailure(@Nullable AtlasUserResultBuilder atlasUserResultBuilder) {
        return atlasUserResultBuilder != null && atlasUserResultBuilder.getOperation() == AtlasUserResult.Operation.FAILED;
    }

    private static boolean isSuccesful(@Nullable AtlasUserResultBuilder atlasUserResultBuilder) {
        return atlasUserResultBuilder != null && atlasUserResultBuilder.getOperation() != AtlasUserResult.Operation.FAILED;
    }

    private static boolean isSuccessful(@Nullable AtlasUserResult atlasUserResult) {
        return atlasUserResult == null || atlasUserResult.getOperation() != AtlasUserResult.Operation.FAILED;
    }

    @Autowired
    public CrowdApiAtlasUserAdapter(@ComponentImport DirectoryManager directoryManager, AtlasUserValidator atlasUserValidator, ApplicationAttributeAdapter applicationAttributeAdapter, @ComponentImport CrowdService crowdService, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport DirectoryInstanceLoader directoryInstanceLoader, DirectoryAdapter directoryAdapter, PermissionChecker permissionChecker, @ComponentImport TransactionTemplate transactionTemplate, ApplicationAccessAdapter applicationAccessAdapter, UserSearcher userSearcher, LicenseCountProvider licenseCountProvider) {
        this.directoryManager = directoryManager;
        this.atlasUserValidator = atlasUserValidator;
        this.applicationAttributeAdapter = applicationAttributeAdapter;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.directoryInstanceLoader = directoryInstanceLoader;
        this.directoryAdapter = directoryAdapter;
        this.permissionChecker = permissionChecker;
        this.transactionTemplate = transactionTemplate;
        this.applicationAccessAdapter = applicationAccessAdapter;
        this.userSearcher = userSearcher;
        this.licenseCountProvider = licenseCountProvider;
        this.keys = new ArrayList<String>(SPECIAL_ATTRIBUTES);
        this.keys.addAll(applicationAttributeAdapter.getKeys());
    }

    @Override
    public Collection<String> getKeys() {
        return this.keys;
    }

    @Override
    @Nonnull
    public UserSearchResult search(@Nonnull SearchFilter searchFilter, @Nonnull SortBy sortBy, CancelHandle cancelHandle) throws AtlasUserOperationFailedException, de.resolution.atlasuser.api.exception.DirectoryNotFoundException, InvalidSearchFilterException {
        return this.userSearcher.search(searchFilter, sortBy, cancelHandle, this);
    }

    @Override
    @Nonnull
    public AtlasUserResultBuilder createAndReturnBuilder(@Nonnull AtlasUser userToCreate, long timestampValue, @Nullable AttributeIndex attributeIndex, @Nullable Collection<String> knownKeys, boolean simulate) {
        long directoryId = userToCreate.getReference().getDirectoryId();
        String username = userToCreate.get("ATTR_NAME").orElse(null);
        AtlasUserResultBuilder res = (AtlasUserResultBuilder)this.transactionTemplate.execute(() -> {
            AtlasUserResultBuilder resultBuilder = AtlasUserResult.builder(userToCreate.getReference()).inputUser(userToCreate).simulated(simulate);
            try {
                this.checkThatDirectoryIsActive(directoryId);
            }
            catch (DirectoryNotFoundException | DirectoryInactiveException e) {
                return resultBuilder.errorString(e.getMessage()).errorType(AtlasUserResult.ErrorType.OPERATION_FAILED);
            }
            try {
                this.atlasUserValidator.validateForCreate(userToCreate);
            }
            catch (AtlasUserValidationFailedException e) {
                return resultBuilder.errorType(AtlasUserResult.ErrorType.VALIDATION_FAILED).exceptionInfo(ExceptionInfo.from(e));
            }
            try {
                this.findUser(userToCreate.getReference(), attributeIndex);
                return resultBuilder.errorType(AtlasUserResult.ErrorType.NOT_UNIQUE).errorString(userToCreate.getReference() + " exists already");
            }
            catch (UserNotFoundException e) {
            }
            catch (Exception e) {
                return resultBuilder.exceptionInfo(ExceptionInfo.from(e)).errorString("Check for existing user failed: " + e.getMessage()).errorType(AtlasUserResult.ErrorType.OPERATION_FAILED);
            }
            if (CrowdApiAtlasUserAdapter.isFailure(this.applicationAttributeAdapter.prepareForCreate(userToCreate, resultBuilder, simulate))) {
                return resultBuilder;
            }
            if (simulate) {
                resultBuilder.operation(AtlasUserResult.Operation.ADDED);
                AtlasUserBuilder simulatedResultingUserBuilder = AtlasUser.builder().from(userToCreate);
                ATTRIBUTES_NOT_TO_INCLUDE_IN_SIMULATED_CREATE_RESULT.forEach(simulatedResultingUserBuilder::without);
                resultBuilder.resultingUser(simulatedResultingUserBuilder.build());
                resultBuilder.addMessage("This is a simulated result, the resulting user's attributes may not be accurate.");
                return resultBuilder;
            }
            try {
                UserWithAttributes createdUser;
                PasswordCredential passwordCredential;
                UserTemplateWithAttributes userTemplate = new UserTemplateWithAttributes((String)userToCreate.get("ATTR_NAME").orElse(null), directoryId);
                userTemplate.setAttribute("ATLAS_USER_TIMESTAMP", String.valueOf(timestampValue));
                userTemplate.setActive(userToCreate.isActive());
                userTemplate.setName(userToCreate.get("ATTR_NAME").orElseThrow(MissingAttributeException.username(userToCreate.getReference())));
                userTemplate.setEmailAddress(userToCreate.get("ATTR_EMAIL").orElseThrow(MissingAttributeException.email(userToCreate.getReference())));
                userTemplate.setDisplayName((String)userToCreate.get("ATTR_FULLNAME").orElse(null));
                userTemplate.setFirstName((String)userToCreate.get("ATTR_FIRSTNAME").orElse(null));
                userTemplate.setLastName((String)userToCreate.get("ATTR_LASTNAME").orElse(null));
                userTemplate.setDirectoryId(directoryId);
                PasswordCredential passwordCredential2 = passwordCredential = userToCreate.get("ATTR_PASSWORD").isPresent() ? new PasswordCredential(userToCreate.get("ATTR_PASSWORD").get()) : PasswordCredential.NONE;
                if (this.directoryAdapter.isAtlasUser(directoryId)) {
                    Directory directory = this.directoryManager.findDirectoryById(directoryId);
                    RemoteDirectory directoryInstance = this.directoryInstanceLoader.getDirectory(directory);
                    createdUser = directoryInstance.addUser(userTemplate, passwordCredential);
                } else {
                    createdUser = this.directoryManager.addUser(directoryId, userTemplate, passwordCredential);
                }
                this.directoryManager.storeUserAttributes(createdUser.getDirectoryId(), createdUser.getName(), Collections.singletonMap("ATLAS_USER_TIMESTAMP", Collections.singleton(String.valueOf(timestampValue))));
                resultBuilder.operation(AtlasUserResult.Operation.ADDED);
                boolean createGroups = Boolean.parseBoolean(userToCreate.get("ATTR_IS_CREATE_GROUPS").orElse(String.valueOf(true)));
                boolean keepGroups = Boolean.parseBoolean(userToCreate.get("ATTR_IS_KEEP_GROUPS").orElse(String.valueOf(false)));
                if (CrowdApiAtlasUserAdapter.isFailure(this.updateGroups((com.atlassian.crowd.model.user.User)createdUser, userToCreate.getAttributeValues("ATTR_GROUPS"), userToCreate.getAttributeValues("ATTR_GROUPS_TO_KEEP"), createGroups, keepGroups, resultBuilder, null))) {
                    return resultBuilder;
                }
                if (CrowdApiAtlasUserAdapter.isFailure(this.updateCrowdAttributes(createdUser, userToCreate, resultBuilder, null))) {
                    return resultBuilder;
                }
                if (CrowdApiAtlasUserAdapter.isFailure(this.applicationAttributeAdapter.updateApplicationAttributes((com.atlassian.crowd.model.user.User)createdUser, userToCreate, resultBuilder, null))) {
                    return resultBuilder;
                }
                return resultBuilder;
            }
            catch (Exception e) {
                return ExceptionToResultBuilderMapper.map(resultBuilder, e);
            }
        });
        if (simulate) {
            if (logger.isDebugEnabled()) {
                logger.debug("Simulate is enabled, just returning {}", (Object)JSONUtil.asJson(res));
            }
            return res;
        }
        try {
            Objects.requireNonNull(res);
            if (CrowdApiAtlasUserAdapter.isSuccesful(res)) {
                UserWithAttributes reloadedUser = this.directoryManager.findUserWithAttributesByName(directoryId, username);
                res.resultingUser(this.buildAtlasUser(reloadedUser, knownKeys));
            }
            return res;
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            return ExceptionToResultBuilderMapper.map(res, (Exception)e);
        }
    }

    @Override
    @Nonnull
    public AtlasUserResult readFirstUniqueUser(@Nonnull AtlasUserReference userToFind, @Nullable AttributeIndex attributeIndex, @Nullable Collection<String> knownKeys) {
        AtlasUserResultBuilder resultBuilder = AtlasUserResult.builder(userToFind);
        try {
            UserWithAttributes userWithAttributes = this.findUser(userToFind, attributeIndex);
            AtlasUser atlasUser = this.buildAtlasUser(userWithAttributes, knownKeys);
            return resultBuilder.resultingUser(atlasUser).build();
        }
        catch (Exception e) {
            return ExceptionToResultBuilderMapper.map(resultBuilder, e).build();
        }
    }

    private void storeSimulatedTimestamp(UserWithAttributes existingUser, long timestampValue) {
        try {
            this.directoryManager.storeUserAttributes(existingUser.getDirectoryId(), existingUser.getName(), Collections.singletonMap("ATLAS_USER_SIMULATE_TIMESTAMP", Collections.singleton(String.valueOf(timestampValue))));
        }
        catch (Exception e) {
            logger.warn("Failed to store simulated timestamp for {} in {}", new Object[]{existingUser.getName(), existingUser.getDirectoryId(), e});
        }
    }

    @Override
    @Nonnull
    public AtlasUserResultBuilder updateAndReturnBuilder(@Nonnull AtlasUser userToUpdate, long timestampValue, @Nullable AttributeIndex attributeIndex, @Nullable Collection<String> knownKeys, boolean simulate) {
        long directoryId;
        UserWithAttributes existingUserWithAttributes;
        AtlasUserResultBuilder resultBuilder = AtlasUserResult.builder(userToUpdate.getReference()).simulated(simulate).inputUser(userToUpdate).operation(AtlasUserResult.Operation.NOT_MODIFIED);
        try {
            existingUserWithAttributes = this.findUser(userToUpdate.getReference(), attributeIndex);
            directoryId = existingUserWithAttributes.getDirectoryId();
        }
        catch (Exception e) {
            return ExceptionToResultBuilderMapper.map(resultBuilder, e);
        }
        try {
            this.checkThatDirectoryIsActive(directoryId);
        }
        catch (Exception e) {
            return ExceptionToResultBuilderMapper.map(resultBuilder, e);
        }
        AtlasUserBuilder simulatedResultingUserBuilder = new AtlasUserBuilder();
        if (simulate) {
            try {
                simulatedResultingUserBuilder = this.createAtlasUserBuilderFromUser(existingUserWithAttributes, knownKeys);
                simulatedResultingUserBuilder.with("ATLAS_USER_TIMESTAMP", timestampValue);
                this.storeSimulatedTimestamp(existingUserWithAttributes, timestampValue);
            }
            catch (Exception e) {
                return ExceptionToResultBuilderMapper.map(resultBuilder, e);
            }
        }
        try {
            this.directoryManager.storeUserAttributes(existingUserWithAttributes.getDirectoryId(), existingUserWithAttributes.getName(), Collections.singletonMap("ATLAS_USER_TIMESTAMP", Collections.singleton(String.valueOf(timestampValue))));
        }
        catch (Exception e) {
            return ExceptionToResultBuilderMapper.map(resultBuilder, e);
        }
        try {
            this.atlasUserValidator.validateForUpdate(userToUpdate);
        }
        catch (AtlasUserValidationFailedException e) {
            return resultBuilder.errorType(AtlasUserResult.ErrorType.VALIDATION_FAILED).exceptionInfo(ExceptionInfo.from(e));
        }
        try {
            boolean ignoreActiveOnUpdate;
            resultBuilder.initialUser(this.buildAtlasUser(existingUserWithAttributes, knownKeys));
            String newName = userToUpdate.get("ATTR_NEW_NAME").orElse(userToUpdate.get("ATTR_NAME").orElse(null));
            String oldName = existingUserWithAttributes.getName();
            if (newName != null && !Objects.equals(newName, oldName)) {
                try {
                    this.atlasUserValidator.validateForRenaming(userToUpdate);
                }
                catch (AtlasUserValidationFailedException e) {
                    return resultBuilder.errorType(AtlasUserResult.ErrorType.VALIDATION_FAILED).exceptionInfo(ExceptionInfo.from(e));
                }
                try {
                    if (simulate) {
                        simulatedResultingUserBuilder.with("ATTR_NAME", newName);
                        resultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                    } else {
                        com.atlassian.crowd.model.user.User renamedUser = this.directoryManager.renameUser(directoryId, oldName, newName);
                        resultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                        existingUserWithAttributes = this.directoryManager.findUserWithAttributesByName(directoryId, renamedUser.getName());
                    }
                }
                catch (DirectoryPermissionException e) {
                    resultBuilder.addMessage(CrowdApiAtlasUserAdapter.createReadOnlyMessage(directoryId, oldName));
                }
            }
            UserTemplateWithAttributes userTemplate = new UserTemplateWithAttributes(existingUserWithAttributes);
            boolean runUpdateUser = false;
            if (userToUpdate.get("ATTR_FIRSTNAME").isPresent() && !Objects.equals(userToUpdate.get("ATTR_FIRSTNAME").orElse(null), userTemplate.getFirstName())) {
                userTemplate.setFirstName(userToUpdate.get("ATTR_FIRSTNAME").get());
                resultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                runUpdateUser = true;
                simulatedResultingUserBuilder.with("ATTR_FIRSTNAME", userToUpdate.getAttributeValues("ATTR_FIRSTNAME"));
            }
            if (userToUpdate.get("ATTR_LASTNAME").isPresent() && !Objects.equals(userToUpdate.get("ATTR_LASTNAME").orElse(null), userTemplate.getLastName())) {
                userTemplate.setLastName(userToUpdate.get("ATTR_LASTNAME").get());
                resultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                runUpdateUser = true;
                simulatedResultingUserBuilder.with("ATTR_LASTNAME", userToUpdate.getAttributeValues("ATTR_LASTNAME"));
            }
            if (userToUpdate.get("ATTR_FULLNAME").isPresent() && !Objects.equals(userToUpdate.get("ATTR_FULLNAME").orElse(null), userTemplate.getDisplayName())) {
                if (!userToUpdate.get("ATTR_FIRSTNAME").isPresent()) {
                    userTemplate.setFirstName(null);
                    simulatedResultingUserBuilder.without("ATTR_FIRSTNAME");
                }
                if (!userToUpdate.get("ATTR_LASTNAME").isPresent()) {
                    userTemplate.setLastName(null);
                    simulatedResultingUserBuilder.without("ATTR_LASTNAME");
                }
                userTemplate.setDisplayName(userToUpdate.get("ATTR_FULLNAME").get());
                resultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                runUpdateUser = true;
                simulatedResultingUserBuilder.with("ATTR_FULLNAME", userToUpdate.getAttributeValues("ATTR_FULLNAME"));
            }
            if (userToUpdate.get("ATTR_EMAIL").isPresent() && !Objects.equals(userToUpdate.get("ATTR_EMAIL").orElse(null), userTemplate.getEmailAddress())) {
                userTemplate.setEmailAddress(userToUpdate.get("ATTR_EMAIL").get());
                resultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                runUpdateUser = true;
                simulatedResultingUserBuilder.with("ATTR_EMAIL", userToUpdate.getAttributeValues("ATTR_EMAIL"));
            }
            if (!(ignoreActiveOnUpdate = Boolean.parseBoolean(userToUpdate.get("ATTR_IS_IGNORE_ACTIVE_ON_UPDATE").orElse(STRING_FALSE))) && userToUpdate.get("ATTR_ACTIVE").isPresent() && userToUpdate.isActive() != userTemplate.isActive()) {
                userTemplate.setActive(userToUpdate.isActive());
                resultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                runUpdateUser = true;
                simulatedResultingUserBuilder.with("ATTR_ACTIVE", userToUpdate.getAttributeValues("ATTR_ACTIVE"));
            }
            if (runUpdateUser && !simulate) {
                try {
                    this.directoryManager.updateUser(directoryId, (UserTemplate)userTemplate);
                }
                catch (DirectoryPermissionException e) {
                    resultBuilder.addMessage(CrowdApiAtlasUserAdapter.createReadOnlyMessage(directoryId, existingUserWithAttributes.getName()));
                }
            }
            boolean createGroups = Boolean.parseBoolean(userToUpdate.get("ATTR_IS_CREATE_GROUPS").orElse(STRING_TRUE));
            boolean keepGroups = Boolean.parseBoolean(userToUpdate.get("ATTR_IS_KEEP_GROUPS").orElse(STRING_FALSE));
            if (userToUpdate.containsKey("ATTR_GROUPS") && CrowdApiAtlasUserAdapter.isFailure(this.updateGroups((com.atlassian.crowd.model.user.User)existingUserWithAttributes, userToUpdate.getAttributeValues("ATTR_GROUPS"), userToUpdate.getAttributeValues("ATTR_GROUPS_TO_KEEP"), createGroups, keepGroups, resultBuilder, simulate ? simulatedResultingUserBuilder : null))) {
                if (simulate) {
                    resultBuilder.resultingUser(simulatedResultingUserBuilder.build());
                }
                return resultBuilder;
            }
            if (CrowdApiAtlasUserAdapter.isFailure(this.updatePassword(userToUpdate, existingUserWithAttributes, resultBuilder, simulate))) {
                if (simulate) {
                    resultBuilder.resultingUser(simulatedResultingUserBuilder.build());
                }
                return resultBuilder;
            }
            if (CrowdApiAtlasUserAdapter.isFailure(this.updateCrowdAttributes(existingUserWithAttributes, userToUpdate, resultBuilder, simulate ? simulatedResultingUserBuilder : null))) {
                if (simulate) {
                    resultBuilder.resultingUser(simulatedResultingUserBuilder.build());
                }
                return resultBuilder;
            }
            if (CrowdApiAtlasUserAdapter.isFailure(this.applicationAttributeAdapter.updateApplicationAttributes((com.atlassian.crowd.model.user.User)existingUserWithAttributes, userToUpdate, resultBuilder, simulate ? simulatedResultingUserBuilder : null))) {
                if (simulate) {
                    resultBuilder.resultingUser(simulatedResultingUserBuilder.build());
                }
                return resultBuilder;
            }
            if (simulate) {
                resultBuilder.resultingUser(simulatedResultingUserBuilder.build());
                return resultBuilder;
            }
            UserWithAttributes reloadedUser = this.directoryManager.findUserWithAttributesByName(directoryId, existingUserWithAttributes.getName());
            resultBuilder.resultingUser(this.buildAtlasUser(reloadedUser, knownKeys));
            return resultBuilder;
        }
        catch (Exception e) {
            return ExceptionToResultBuilderMapper.map(resultBuilder, e);
        }
    }

    @Override
    @Nonnull
    public AtlasUserResult delete(@Nonnull AtlasUserReference userToDelete, @Nullable AttributeIndex attributeIndex, @Nullable Collection<String> knownKeys, boolean simulate) {
        AtlasUserResultBuilder resultBuilder = AtlasUserResult.builder(userToDelete);
        resultBuilder.simulated(simulate);
        try {
            UserWithAttributes initialUserWithAttributes = this.findUser(userToDelete, attributeIndex);
            resultBuilder.initialUser(this.buildAtlasUser(initialUserWithAttributes, knownKeys));
            if (simulate) {
                resultBuilder.operation(AtlasUserResult.Operation.DELETED);
                resultBuilder.addMessage("This is a simulated result indicating that a user to delete is present- real deletion may fail (e.g. if tickets are assigned");
                return resultBuilder.build();
            }
            this.directoryManager.removeUser(userToDelete.getDirectoryId(), initialUserWithAttributes.getName());
            try {
                UserWithAttributes reloadedUserWithAttributes = this.findUser(userToDelete, attributeIndex);
                return resultBuilder.resultingUser(this.buildAtlasUser(reloadedUserWithAttributes, knownKeys)).errorString("Deleting user failed. The user is still present, most likely because of assigned assets.").errorType(AtlasUserResult.ErrorType.OPERATION_FAILED).build();
            }
            catch (UserNotFoundException e) {
                resultBuilder.operation(AtlasUserResult.Operation.DELETED);
                return resultBuilder.build();
            }
        }
        catch (Exception e) {
            return ExceptionToResultBuilderMapper.map(resultBuilder, e).build();
        }
    }

    @Override
    @Nonnull
    public AtlasUserResultBuilder createOrUpdateAndReturnBuilder(@Nonnull AtlasUser userToCreateOrUpdate, AtlasUserAdapter.CopyBehaviour copyBehaviour, long timestampValue, @Nullable AttributeIndex attributeIndex, @Nullable Collection<String> knownKeys, boolean simulate) {
        AtlasUserResultBuilder resultBuilder = AtlasUserResult.builder(userToCreateOrUpdate.getReference()).inputUser(userToCreateOrUpdate);
        try {
            try {
                this.findUser(userToCreateOrUpdate.getReference(), attributeIndex);
                return this.updateAndReturnBuilder(userToCreateOrUpdate, timestampValue, attributeIndex, knownKeys, simulate);
            }
            catch (UserNotFoundException e) {
                if (copyBehaviour == AtlasUserAdapter.CopyBehaviour.COPY || copyBehaviour == AtlasUserAdapter.CopyBehaviour.MOVE) {
                    AtlasUserReference fromAny = AtlasUserReference.create("ATTR_NAME", userToCreateOrUpdate.get("ATTR_NAME").orElseThrow(MissingAttributeException.username(userToCreateOrUpdate.getReference())), -1L);
                    AtlasUserResult userResultFromOtherDirectory = this.readFirstUniqueUser(fromAny, null);
                    if (CrowdApiAtlasUserAdapter.isSuccessful(userResultFromOtherDirectory)) {
                        AtlasUser userFromOther = userResultFromOtherDirectory.getResultingUser().orElseThrow(MissingResultingUserException.supplier());
                        resultBuilder.initialUser(userFromOther);
                        AtlasUserBuilder userBuilder = AtlasUser.builder().from(userFromOther).in(userToCreateOrUpdate.getReference().getDirectoryId());
                        HashSet<String> groups2 = new HashSet<String>(userToCreateOrUpdate.getAttributeValues("ATTR_GROUPS"));
                        if (Boolean.parseBoolean(userToCreateOrUpdate.get("ATTR_IS_KEEP_GROUPS").orElse(STRING_FALSE))) {
                            groups2.addAll(userFromOther.getAttributeValues("ATTR_GROUPS"));
                        } else {
                            Set<String> groupsToKeep = userToCreateOrUpdate.getAttributeValues("ATTR_GROUPS_TO_KEEP");
                            for (String group : userFromOther.getAttributeValues("ATTR_GROUPS")) {
                                if (!CollectionUtil.matchesAny(group, (Collection<String>)groupsToKeep)) continue;
                                groups2.add(group);
                            }
                        }
                        for (String key : userToCreateOrUpdate.getAttributeKeys()) {
                            userBuilder.with(key, userToCreateOrUpdate.getAttributeValues(key));
                        }
                        userBuilder.with("ATTR_GROUPS", groups2);
                        AtlasUserResultBuilder createResultBuilder = this.createAndReturnBuilder(userBuilder.build(), timestampValue, attributeIndex, knownKeys, simulate);
                        createResultBuilder.initialUser(userFromOther);
                        if (CrowdApiAtlasUserAdapter.isSuccesful(createResultBuilder) && copyBehaviour == AtlasUserAdapter.CopyBehaviour.MOVE) {
                            if (userFromOther.isAdminOrSysAdmin()) {
                                return createResultBuilder.removeInOtherResult(AtlasUserResult.builder(userResultFromOtherDirectory.getReference()).operation(AtlasUserResult.Operation.NOT_MODIFIED).build());
                            }
                            return createResultBuilder.removeInOtherResult(this.delete(userFromOther.getReference(), simulate));
                        }
                        return createResultBuilder;
                    }
                    if (userResultFromOtherDirectory.getErrorType() == AtlasUserResult.ErrorType.NOT_FOUND) {
                        return this.createAndReturnBuilder(userToCreateOrUpdate, timestampValue, attributeIndex, knownKeys, simulate);
                    }
                    AtlasUser userFromOther = userResultFromOtherDirectory.getResultingUser().orElse(null);
                    return AtlasUserResult.builder(userToCreateOrUpdate.getReference()).initialUser(userFromOther).errorString("Loading user from other directory failed");
                }
                return this.createAndReturnBuilder(userToCreateOrUpdate, timestampValue, attributeIndex, knownKeys, simulate);
            }
        }
        catch (Exception e) {
            return ExceptionToResultBuilderMapper.map(resultBuilder, e);
        }
    }

    @Override
    @Nullable
    public AttributeIndex buildIndex(long directoryId, @Nonnull String attributeName, @Nonnull AtlasUserStatusObject statusObject) throws AttributeNotSearchableException, AttributeNotUniqueException, AtlasUserOperationFailedException {
        if (SPECIAL_ATTRIBUTES.contains(attributeName)) {
            logger.debug("{} is a default attribute, returning null", (Object)attributeName);
            return null;
        }
        if (AtlasUserKeys.APPLICATION_PREFIXES.stream().anyMatch(attributeName::startsWith)) {
            throw new AttributeNotSearchableException(attributeName);
        }
        int batchCount = 1;
        HashMap<String, String> indexMap = new HashMap<String, String>();
        HashMap<String, Set<String>> duplicateMap = new HashMap<String, Set<String>>();
        logger.debug("Building index for attribute name {}", (Object)attributeName);
        try {
            List currentBatchUserList;
            int startIndex = 0;
            do {
                if (statusObject.isCancelled()) {
                    logger.warn("Cancelled while building index");
                    return null;
                }
                EntityQuery userQuery = QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(startIndex).returningAtMost(500);
                currentBatchUserList = this.directoryManager.searchUsers(directoryId, userQuery);
                logger.debug("Executed batch {} starting at {} returning {} users", new Object[]{batchCount, startIndex, currentBatchUserList.size()});
                statusObject.setStatusMessage("Building index for batch " + batchCount + " (" + currentBatchUserList.size() + " users)");
                for (com.atlassian.crowd.model.user.User crowdUser : currentBatchUserList) {
                    try {
                        UserWithAttributes user = this.directoryManager.findUserWithAttributesByName(directoryId, crowdUser.getName());
                        Set attributeValues = user.getValues(attributeName);
                        if (attributeValues == null) continue;
                        for (String attributeValue : attributeValues) {
                            if (indexMap.containsKey(attributeValue)) {
                                throw new AttributeNotUniqueException(attributeName, attributeValue, user.getName(), (String)indexMap.get(attributeValue));
                            }
                            indexMap.put(attributeValue, user.getExternalId());
                        }
                    }
                    catch (UserNotFoundException e) {
                        logger.error("Could not load UserWithAttributes for {}", (Object)crowdUser.getName());
                    }
                }
                startIndex += 500;
                ++batchCount;
            } while (!currentBatchUserList.isEmpty());
            return new AttributeIndex(attributeName, indexMap, duplicateMap);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new AtlasUserOperationFailedException("Building index failed: " + e.getMessage(), e);
        }
    }

    @Override
    public void applyToAll(long directoryId, @Nonnull AtlasUserFunction functionToApply, @Nonnull AtlasUserStatusObject statusObject, @Nullable Collection<String> knownKeys, boolean simulate) throws AtlasUserOperationFailedException, de.resolution.atlasuser.api.exception.DirectoryNotFoundException {
        this.applyToAll(directoryId, functionToApply, statusObject, 500, knownKeys, simulate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyToAll(long directoryId, @Nonnull AtlasUserFunction functionToApply, @Nonnull AtlasUserStatusObject statusObject, int batchSize, @Nullable Collection<String> knownKeys, boolean simulate) throws AtlasUserOperationFailedException, de.resolution.atlasuser.api.exception.DirectoryNotFoundException {
        try {
            List currentBatchUserList;
            int batchCount = 1;
            int startIndex = 0;
            do {
                if (statusObject.isCancelled()) {
                    logger.warn("Cancelled in applyToAll");
                    return;
                }
                EntityQuery userQuery = QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(startIndex).returningAtMost(batchSize);
                currentBatchUserList = this.directoryManager.searchUsers(directoryId, userQuery);
                logger.debug("Executed batch {} starting at {} returning {} users", new Object[]{batchCount, startIndex, currentBatchUserList.size()});
                int deletedUsers = 0;
                for (com.atlassian.crowd.model.user.User crowdUser : currentBatchUserList) {
                    AtlasUserResult readResult = this.readFirstUniqueUser(AtlasUserReference.create("ATTR_NAME", crowdUser.getName(), directoryId), knownKeys);
                    if (CrowdApiAtlasUserAdapter.isSuccessful(readResult)) {
                        if (!readResult.getResultingUser().isPresent()) throw new AtlasUserOperationFailedException("Resulting user is not present although isSuccess() returned true", null);
                        Optional<AtlasUserResult> funcResult = functionToApply.apply(readResult.getResultingUser().orElse(null), statusObject, simulate);
                        if (funcResult.isPresent() && funcResult.get().getOperation() == AtlasUserResult.Operation.DELETED) {
                            ++deletedUsers;
                        }
                    } else {
                        statusObject.add(readResult);
                    }
                    if (!statusObject.isCancelled()) continue;
                    logger.warn("Cancelled in applyToAll");
                    return;
                }
                startIndex = startIndex + batchSize - deletedUsers;
                if (deletedUsers > 0) {
                    logger.debug("{} users were deleted, so the next startindex is {}", (Object)deletedUsers, (Object)startIndex);
                }
                ++batchCount;
            } while (currentBatchUserList.size() >= batchSize);
            return;
        }
        catch (DirectoryNotFoundException e) {
            throw new de.resolution.atlasuser.api.exception.DirectoryNotFoundException(directoryId);
        }
        catch (OperationFailedException e) {
            throw new AtlasUserOperationFailedException("Applying function failed: " + e.getMessage(), e);
        }
    }

    private boolean groupExistsInOtherDirectory(String groupName) {
        return this.crowdService.getGroup(groupName) != null;
    }

    private boolean groupExistsInThisDirectory(@Nonnull String groupName, long directoryId) throws DirectoryNotFoundException, OperationFailedException {
        try {
            this.directoryManager.findGroupByName(directoryId, groupName);
            return true;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }

    private boolean createGroupIfRequired(String groupName, long directoryId, boolean createNonExisting, boolean simulate) throws DirectoryNotFoundException, OperationFailedException, InvalidGroupException, DirectoryPermissionException {
        if (this.groupExistsInThisDirectory(groupName, directoryId)) {
            return true;
        }
        if (this.groupExistsInOtherDirectory(groupName) || createNonExisting) {
            if (!simulate) {
                this.directoryManager.addGroup(directoryId, new GroupTemplate(groupName, directoryId));
            }
            return true;
        }
        return false;
    }

    private void addGroups(Collection<String> groupNamesToUpdate, Set<String> currentGroups, boolean createGroups, com.atlassian.crowd.model.user.User user, AtlasUserResultBuilder resultBuilder, @Nullable AtlasUserBuilder simulatedResultingUserBuilder) {
        boolean simulate = simulatedResultingUserBuilder != null;
        HashSet<String> groupsForSimulatedResult = new HashSet<String>(currentGroups);
        if (!new HashSet<String>(currentGroups).containsAll(groupNamesToUpdate)) {
            for (String groupName : groupNamesToUpdate) {
                if (currentGroups.stream().noneMatch(groupName::equalsIgnoreCase)) {
                    try {
                        if (this.createGroupIfRequired(groupName, user.getDirectoryId(), createGroups, simulate)) {
                            if (simulate) {
                                groupsForSimulatedResult.add(groupName);
                            } else {
                                this.applyGroup(user, groupName, resultBuilder);
                            }
                        }
                    }
                    catch (DirectoryNotFoundException | GroupNotFoundException | InvalidGroupException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
                        resultBuilder.exceptionInfo(ExceptionInfo.from(e)).errorType(AtlasUserResult.ErrorType.OPERATION_FAILED).errorString("Failed to add  " + groupName + " to  " + user.getName() + ": " + e.getMessage());
                        return;
                    }
                }
                resultBuilder.updatedIfNotAdded();
            }
        }
        if (simulate) {
            simulatedResultingUserBuilder.with("ATTR_GROUPS", groupsForSimulatedResult);
        }
    }

    private void removeGroups(Collection<String> groupNamesToUpdate, Set<String> currentGroups, boolean keepGroups, Collection<String> groupsToKeep, com.atlassian.crowd.model.user.User user, AtlasUserResultBuilder resultBuilder, @Nullable AtlasUserBuilder simulatedResultingUserBuilder) {
        boolean simulate = simulatedResultingUserBuilder != null;
        HashSet<String> groupsForSimulatedResult = simulate ? new HashSet(simulatedResultingUserBuilder.get("ATTR_GROUPS").orElse(currentGroups)) : new HashSet<String>(currentGroups);
        if (keepGroups || groupNamesToUpdate.containsAll(currentGroups)) {
            if (simulate) {
                simulatedResultingUserBuilder.with("ATTR_GROUPS", groupsForSimulatedResult);
            }
            return;
        }
        for (String groupName : currentGroups) {
            if (!groupNamesToUpdate.stream().noneMatch(groupName::equalsIgnoreCase) || CollectionUtil.matchesAny(groupName, groupsToKeep)) continue;
            try {
                if (simulate) {
                    groupsForSimulatedResult.remove(groupName);
                } else {
                    this.directoryManager.removeUserFromGroup(user.getDirectoryId(), user.getName(), groupName);
                }
            }
            catch (DirectoryNotFoundException | GroupNotFoundException | MembershipNotFoundException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
                resultBuilder.exceptionInfo(ExceptionInfo.from(e)).errorType(AtlasUserResult.ErrorType.OPERATION_FAILED).errorString("Failed to remove  " + groupName + " from  " + user.getName() + ": " + e.getMessage());
                return;
            }
            resultBuilder.updatedIfNotAdded();
        }
        if (simulate) {
            simulatedResultingUserBuilder.with("ATTR_GROUPS", groupsForSimulatedResult);
        }
    }

    private AtlasUserResultBuilder updateGroups(@Nonnull com.atlassian.crowd.model.user.User user, @Nonnull Collection<String> groupNames, @Nonnull Collection<String> groupsToKeep, boolean createGroups, boolean keepGroups, @Nonnull AtlasUserResultBuilder resultBuilder, @Nullable AtlasUserBuilder simulatedResultingUserBuilder) {
        Set<String> currentGroups;
        TreeSet checkedGroups = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        Collection groupNamesToUpdate = groupNames.stream().filter(Objects::nonNull).map(String::trim).filter(groupName -> {
            if (!checkedGroups.add(groupName)) {
                resultBuilder.addMessage("Skipped duplicate group <" + groupName + "> from inputUser.");
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        try {
            currentGroups = this.getGroupNamesForUser(user);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            resultBuilder.exceptionInfo(ExceptionInfo.from(e)).errorType(AtlasUserResult.ErrorType.OPERATION_FAILED).errorString("Failed to read existing groups for " + user.getName() + ": " + e.getMessage());
            return resultBuilder;
        }
        this.addGroups(groupNamesToUpdate, currentGroups, createGroups, user, resultBuilder, simulatedResultingUserBuilder);
        this.removeGroups(groupNamesToUpdate, currentGroups, keepGroups, groupsToKeep, user, resultBuilder, simulatedResultingUserBuilder);
        return resultBuilder;
    }

    public void applyGroup(com.atlassian.crowd.model.user.User user, String groupName, AtlasUserResultBuilder resultBuilder) throws UserNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException, GroupNotFoundException {
        try {
            this.directoryManager.addUserToGroup(user.getDirectoryId(), user.getName(), groupName);
            resultBuilder.updatedIfNotAdded();
        }
        catch (MembershipAlreadyExistsException mex) {
            resultBuilder.addMessage("Failed to add user " + user.getName() + " to group " + groupName + ", membership already exists.");
        }
    }

    private Set<String> getGroupNamesForUser(com.atlassian.crowd.model.user.User crowdUser) throws DirectoryNotFoundException, OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(crowdUser.getName()).returningAtMost(Integer.MAX_VALUE);
        List groups2 = this.directoryManager.searchDirectGroupRelationships(crowdUser.getDirectoryId(), query);
        return groups2.stream().map(DirectoryEntity::getName).collect(Collectors.toSet());
    }

    private AtlasUserResultBuilder updateCrowdAttributes(UserWithAttributes crowdUser, AtlasUser atlasUser, AtlasUserResultBuilder resultBuilder, @Nullable AtlasUserBuilder simulatedResultingUserBuilder) {
        boolean simulated = simulatedResultingUserBuilder != null;
        try {
            Set attributeNames = atlasUser.getAttributeKeys().stream().filter(key -> !SPECIAL_ATTRIBUTES.contains(key)).filter(key -> AtlasUserKeys.APPLICATION_PREFIXES.stream().noneMatch(key::startsWith)).collect(Collectors.toSet());
            Set crowdUserKeys = crowdUser.getKeys();
            Set keysToRemove = crowdUserKeys.stream().filter(key -> attributeNames.contains(key) && atlasUser.getAttributeValues((String)key).isEmpty()).collect(Collectors.toSet());
            Set keysToAdd = attributeNames.stream().filter(key -> !atlasUser.getAttributeValues((String)key).isEmpty() && !crowdUserKeys.contains(key)).collect(Collectors.toSet());
            HashMap<String, Set> attributesToAdd = new HashMap<String, Set>();
            for (String key2 : keysToAdd) {
                attributesToAdd.put(key2, atlasUser.getAttributeValues(key2));
            }
            Set keysToUpdate = attributeNames.stream().filter(key -> !atlasUser.getAttributeValues((String)key).isEmpty() && crowdUserKeys.contains(key) && !CollectionUtil.containsSame(atlasUser.getAttributeValues((String)key), crowdUser.getValues(key))).collect(Collectors.toSet());
            boolean updated = false;
            for (String key3 : keysToRemove) {
                if (simulated) {
                    logger.warn("Removing {}", (Object)key3);
                    simulatedResultingUserBuilder.without(key3);
                } else {
                    this.directoryManager.removeUserAttributes(crowdUser.getDirectoryId(), crowdUser.getName(), key3);
                }
                updated = true;
            }
            if (!attributesToAdd.isEmpty()) {
                if (simulated) {
                    attributesToAdd.forEach(simulatedResultingUserBuilder::with);
                } else {
                    this.directoryManager.storeUserAttributes(crowdUser.getDirectoryId(), crowdUser.getName(), attributesToAdd);
                }
                updated = true;
            }
            HashMap<String, Set<String>> attributesToUpdate = new HashMap<String, Set<String>>();
            for (String key4 : keysToUpdate) {
                if (simulated) {
                    simulatedResultingUserBuilder.with(key4, atlasUser.getAttributeValues(key4));
                    updated = true;
                    continue;
                }
                attributesToUpdate.put(key4, atlasUser.getAttributeValues(key4));
            }
            if (!simulated && !attributesToUpdate.isEmpty()) {
                this.directoryManager.storeUserAttributes(crowdUser.getDirectoryId(), crowdUser.getName(), attributesToUpdate);
                updated = true;
            }
            if (updated) {
                resultBuilder.operation(resultBuilder.getOperation() == AtlasUserResult.Operation.ADDED ? AtlasUserResult.Operation.ADDED : AtlasUserResult.Operation.UPDATED);
            }
            return resultBuilder;
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException | DirectoryPermissionException e) {
            return resultBuilder.errorType(AtlasUserResult.ErrorType.OPERATION_FAILED).exceptionInfo(ExceptionInfo.from(e)).errorString("Updating attributes for user " + crowdUser.getName() + " in directory " + crowdUser.getDirectoryId() + " failed");
        }
    }

    private AtlasUserResultBuilder updatePassword(AtlasUser atlasUser, UserWithAttributes userWithAttributes, AtlasUserResultBuilder resultBuilder, boolean simulate) {
        atlasUser.get("ATTR_PASSWORD").ifPresent(password -> {
            resultBuilder.operation(resultBuilder.getOperation() == AtlasUserResult.Operation.ADDED ? AtlasUserResult.Operation.ADDED : AtlasUserResult.Operation.UPDATED);
            if (!simulate) {
                try {
                    this.checkThatDirectoryIsActive(userWithAttributes.getDirectoryId());
                    this.directoryManager.updateUserCredential(userWithAttributes.getDirectoryId(), userWithAttributes.getName(), new PasswordCredential(password));
                }
                catch (Exception e) {
                    resultBuilder.exceptionInfo(ExceptionInfo.from(e));
                }
            }
        });
        return resultBuilder;
    }

    private AtlasUser buildAtlasUser(@Nonnull UserWithAttributes user, @Nullable Collection<String> knownKeys) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException {
        return this.createAtlasUserBuilderFromUser(user, knownKeys).build();
    }

    private AtlasUserBuilder createAtlasUserBuilderFromUser(@Nonnull UserWithAttributes user, @Nullable Collection<String> knownKeys) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException {
        String findByAttributeName = "ATTR_ID";
        String findByAttributeValue = user.getExternalId();
        if (findByAttributeValue == null || findByAttributeValue.isEmpty()) {
            findByAttributeName = "ATTR_NAME";
            findByAttributeValue = user.getName();
        }
        AtlasUserBuilder userBuilder = AtlasUser.builder().findBy(findByAttributeName, findByAttributeValue).in(user.getDirectoryId()).active(user.isActive()).with("ATTR_NAME", user.getName()).with("ATTR_FULLNAME", user.getDisplayName()).with("ATTR_FIRSTNAME", user.getFirstName()).with("ATTR_LASTNAME", user.getLastName()).with("ATTR_EMAIL", user.getEmailAddress()).with("ATTR_GROUPS", this.getGroupNamesForUser((com.atlassian.crowd.model.user.User)user));
        if (findByAttributeName.equals("ATTR_ID")) {
            userBuilder = userBuilder.with("ATTR_ID", user.getExternalId());
        }
        for (String key : user.getKeys()) {
            Set values2 = user.getValues(key);
            if (values2 == null || values2.isEmpty()) continue;
            userBuilder.with(key, values2);
        }
        userBuilder.with("ATTR_IS_ADMIN", this.permissionChecker.isAdmin(user.getName()));
        userBuilder.with("ATTR_IS_SYSADMIN", this.permissionChecker.isSysAdmin(user.getName()));
        this.applicationAttributeAdapter.readApplicationAttributes((com.atlassian.crowd.model.user.User)user, userBuilder, knownKeys);
        this.consolidateLastAuthenticatedAndActivity(userBuilder);
        return userBuilder;
    }

    private void consolidateLastAuthenticatedAndActivity(AtlasUserBuilder userBuilder) {
        String lastActivity;
        long lastActivityLong;
        long biggestLastActivity;
        String lastAuthenticated = userBuilder.getFirstIfPresent("lastAuthenticated");
        long lastAuthenticatedLong = lastAuthenticated == null ? AtlasUserKeys.NO_TIMESTAMP_AVAILABLE : Long.parseLong(lastAuthenticated);
        String lastLoginInMillis = userBuilder.getFirstIfPresent("login.lastLoginMillis");
        long lastLoginInMillisLong = lastLoginInMillis == null ? AtlasUserKeys.NO_TIMESTAMP_AVAILABLE : Long.parseLong(lastLoginInMillis);
        String bitbucketLastLogin = userBuilder.getFirstIfPresent("ATTR_BITBUCKET_LAST_AUTHENTICATED");
        long bitbucketLastLoginLong = bitbucketLastLogin == null ? AtlasUserKeys.NO_TIMESTAMP_AVAILABLE : Long.parseLong(bitbucketLastLogin);
        String confluenceLastLogin = userBuilder.getFirstIfPresent("ATTR_CONFLUENCE_LAST_AUTHENTICATED");
        long confluenceLastLoginLong = confluenceLastLogin == null ? AtlasUserKeys.NO_TIMESTAMP_AVAILABLE : Long.parseLong(confluenceLastLogin);
        long biggestLastLogin = Math.max(Math.max(confluenceLastLoginLong, Math.max(lastAuthenticatedLong, lastLoginInMillisLong)), bitbucketLastLoginLong);
        if (biggestLastLogin > 0L) {
            userBuilder.with("ATTR_LAST_AUTH_CONSOLIDATED", String.valueOf(biggestLastLogin));
        }
        if ((biggestLastActivity = Math.max(lastActivityLong = (lastActivity = userBuilder.getFirstIfPresent("lastActivityMillis")) == null ? AtlasUserKeys.NO_TIMESTAMP_AVAILABLE : Long.parseLong(lastActivity), biggestLastLogin)) > 0L) {
            userBuilder.with("ATTR_LAST_KNOWN_ACTIVITY", String.valueOf(biggestLastActivity));
        }
    }

    @Nonnull
    private UserWithAttributes findUser(@Nonnull AtlasUserReference userReferenceToFind, @Nullable AttributeIndex attributeIndex) throws UserNotFoundException, DirectoryNotFoundException, DirectoryInactiveException, OperationFailedException, AtlasUserNotUniqueException, AttributeNotSearchableException {
        AtlasUserReference effectiveUserReference = this.replaceReferenceWithUserKey(userReferenceToFind);
        this.checkThatAttributeIsSearchable(effectiveUserReference);
        if (effectiveUserReference.getDirectoryId() == -1L) {
            return this.findUserInAnyDirectory(effectiveUserReference, attributeIndex);
        }
        this.checkThatDirectoryIsActive(effectiveUserReference.getDirectoryId());
        if (effectiveUserReference.isFindById()) {
            return this.directoryManager.findUserWithAttributesByExternalId(effectiveUserReference.getDirectoryId(), effectiveUserReference.getFindByAttributeValue());
        }
        if (effectiveUserReference.isFindByName()) {
            return this.directoryManager.findUserWithAttributesByName(effectiveUserReference.getDirectoryId(), effectiveUserReference.getFindByAttributeValue());
        }
        if (effectiveUserReference.isFindByEmail()) {
            return this.findUserByEmail(effectiveUserReference.getDirectoryId(), effectiveUserReference.getFindByAttributeValue());
        }
        if (attributeIndex != null && attributeIndex.getAttributeName().equals(effectiveUserReference.getFindByAttributeName())) {
            String id = attributeIndex.getIndexMap().get(effectiveUserReference.getFindByAttributeValue());
            if (id == null) {
                throw new UserNotFoundException(effectiveUserReference.getFindByAttributeValue());
            }
            return this.directoryManager.findUserWithAttributesByExternalId(effectiveUserReference.getDirectoryId(), id);
        }
        return this.findUserByOtherAttribute(effectiveUserReference);
    }

    private AtlasUserReference replaceReferenceWithUserKey(AtlasUserReference userReference) throws OperationFailedException, UserNotFoundException {
        if (Objects.equals("ATTR_USER_KEY", userReference.getFindByAttributeName())) {
            if (userReference.getDirectoryId() != -1L) {
                throw new OperationFailedException("Searching by ATTR_USER_KEY does not allow specifying a directory.");
            }
            String username = this.applicationAttributeAdapter.getUsernameForKey(userReference.getFindByAttributeValue());
            if (username == null) {
                throw new UserNotFoundException("User " + JSONUtil.asJson(userReference) + " was not found");
            }
            User user = this.crowdService.getUser(username);
            if (user == null) {
                throw new UserNotFoundException("User " + JSONUtil.asJson(userReference) + " was not found");
            }
            return AtlasUserReference.create("ATTR_NAME", user.getName(), user.getDirectoryId());
        }
        return userReference;
    }

    private UserWithAttributes findUserInAnyDirectory(AtlasUserReference reference, @Nullable AttributeIndex attributeIndex) throws UserNotFoundException, DirectoryNotFoundException, DirectoryInactiveException, OperationFailedException, AtlasUserNotUniqueException, AttributeNotSearchableException {
        if (AtlasUserKeys.isUnique(reference.getFindByAttributeName())) {
            logger.debug("calling findUserByUniqueIdentifier() with reference {}", (Object)reference);
            return this.findUserByUniqueIdentifierInAnyDirectory(reference, attributeIndex);
        }
        logger.debug("calling findUserByNonUniqueIdentifier() with reference {}", (Object)reference);
        return this.findUserByNonUniqueIdentifierInAnyDirectory(reference, attributeIndex);
    }

    @Nonnull
    private UserWithAttributes findUserByUniqueIdentifierInAnyDirectory(@Nonnull AtlasUserReference reference, @Nullable AttributeIndex attributeIndex) throws UserNotFoundException, OperationFailedException, AtlasUserNotUniqueException, DirectoryInactiveException, DirectoryNotFoundException, AttributeNotSearchableException {
        List directoryIds = (List)this.transactionTemplate.execute(() -> this.crowdDirectoryService.findAllDirectories().stream().filter(Directory::isActive).map(Directory::getId).collect(Collectors.toList()));
        Iterator iterator2 = directoryIds.iterator();
        while (iterator2.hasNext()) {
            long directory = (Long)iterator2.next();
            AtlasUserReference currentRef = AtlasUserReference.create(reference.getFindByAttributeName(), reference.getFindByAttributeValue(), directory);
            try {
                return this.findUser(currentRef, attributeIndex);
            }
            catch (UserNotFoundException e) {
                logger.debug("User {} was not found in directory {} ", (Object)currentRef, (Object)directory);
            }
        }
        throw new UserNotFoundException(reference.getFindByAttributeValue());
    }

    @Nonnull
    private UserWithAttributes findUserByNonUniqueIdentifierInAnyDirectory(@Nonnull AtlasUserReference reference, @Nullable AttributeIndex attributeIndex) throws UserNotFoundException, AtlasUserNotUniqueException, OperationFailedException, DirectoryInactiveException, DirectoryNotFoundException, AttributeNotSearchableException {
        ArrayList<UserWithAttributes> usersAcrossDirectories = new ArrayList<UserWithAttributes>();
        HashSet<String> seenUsernames = new HashSet<String>();
        for (Directory directory : this.directoryManager.findAllDirectories()) {
            if (!directory.isActive()) continue;
            AtlasUserReference currentRef = AtlasUserReference.create(reference.getFindByAttributeName(), reference.getFindByAttributeValue(), directory.getId());
            try {
                UserWithAttributes foundUser = this.findUser(currentRef, attributeIndex);
                if (seenUsernames.contains(foundUser.getName())) {
                    logger.debug("Skipping {} in directory {}, already seen in other directory", (Object)foundUser.getName(), (Object)directory.getId());
                    continue;
                }
                usersAcrossDirectories.add(foundUser);
                seenUsernames.add(foundUser.getName());
            }
            catch (UserNotFoundException e) {
                logger.debug("User {} was not found ", (Object)currentRef);
            }
        }
        if (usersAcrossDirectories.isEmpty()) {
            logger.debug("User {} was not found", (Object)reference);
            throw new UserNotFoundException(reference.getFindByAttributeValue());
        }
        return CrowdApiAtlasUserAdapter.getSingleActiveUser(usersAcrossDirectories);
    }

    public static UserWithAttributes getSingleActiveUser(@Nonnull List<UserWithAttributes> users) throws AtlasUserNotUniqueException {
        if (users.isEmpty()) {
            throw new IllegalArgumentException("User list must contain at least one user");
        }
        int activeCount = 0;
        for (UserWithAttributes user : users) {
            if (!user.isActive()) continue;
            ++activeCount;
        }
        if (activeCount > 1) {
            throw new AtlasUserNotUniqueException();
        }
        return users.stream().filter(User::isActive).findFirst().orElse(users.get(0));
    }

    private UserWithAttributes findUserByEmail(long directoryId, String email) throws UserNotFoundException, AtlasUserNotUniqueException, DirectoryNotFoundException, OperationFailedException {
        TermRestriction tr = new TermRestriction(UserTermKeys.EMAIL, MatchMode.EXACTLY_MATCHES, (Object)email);
        UserQuery eq = new UserQuery(com.atlassian.crowd.model.user.User.class, (SearchRestriction)tr, 0, 2);
        List foundUsers = this.directoryManager.searchUsers(directoryId, (EntityQuery)eq);
        if (foundUsers == null || foundUsers.isEmpty()) {
            throw new UserNotFoundException(email);
        }
        return this.getOnlyOrFirstActiveUser(foundUsers, directoryId);
    }

    private UserWithAttributes findUserByOtherAttribute(final AtlasUserReference atlasUserReference) throws AtlasUserNotUniqueException, UserNotFoundException, DirectoryNotFoundException, OperationFailedException {
        Property<String> property = new Property<String>(){

            public String getPropertyName() {
                return atlasUserReference.getFindByAttributeName();
            }

            public Class<String> getPropertyType() {
                return String.class;
            }
        };
        TermRestriction tr = new TermRestriction((Property)property, MatchMode.EXACTLY_MATCHES, (Object)atlasUserReference.getFindByAttributeValue());
        UserQuery eq = new UserQuery(com.atlassian.crowd.model.user.User.class, (SearchRestriction)tr, 0, 2);
        List resultList = this.directoryManager.searchUsers(atlasUserReference.getDirectoryId(), (EntityQuery)eq);
        if (resultList.isEmpty()) {
            throw new UserNotFoundException(atlasUserReference.getFindByAttributeValue());
        }
        return this.getOnlyOrFirstActiveUser(resultList, atlasUserReference.getDirectoryId());
    }

    private UserWithAttributes getOnlyOrFirstActiveUser(List<com.atlassian.crowd.model.user.User> foundUsers, long directoryId) throws UserNotFoundException, AtlasUserNotUniqueException, DirectoryNotFoundException, OperationFailedException {
        com.atlassian.crowd.model.user.User foundUser;
        if (foundUsers.size() > 1) {
            List activeUsers = foundUsers.stream().filter(User::isActive).collect(Collectors.toList());
            if (activeUsers.size() > 1) {
                throw new AtlasUserNotUniqueException();
            }
            foundUser = activeUsers.isEmpty() ? foundUsers.get(0) : (com.atlassian.crowd.model.user.User)activeUsers.get(0);
        } else {
            foundUser = foundUsers.get(0);
        }
        if (foundUser.getExternalId() != null) {
            return this.directoryManager.findUserWithAttributesByExternalId(directoryId, foundUser.getExternalId());
        }
        return this.directoryManager.findUserWithAttributesByName(directoryId, foundUser.getName());
    }

    private void checkThatAttributeIsSearchable(AtlasUserReference reference) throws AttributeNotSearchableException {
        if (AtlasUserKeys.APPLICATION_PREFIXES.stream().anyMatch(prefix -> reference.getFindByAttributeName().startsWith((String)prefix)) || NOT_SEARCHABLE_ATTRIBUTES.contains(reference.getFindByAttributeName())) {
            throw new AttributeNotSearchableException(reference.getFindByAttributeName());
        }
    }

    private void checkThatDirectoryIsActive(long direcoryId) throws DirectoryInactiveException, DirectoryNotFoundException {
        Directory dirToSearch = this.directoryManager.findDirectoryById(direcoryId);
        if (!dirToSearch.isActive()) {
            throw new DirectoryInactiveException(dirToSearch);
        }
    }

    @Override
    public Set<String> getAvailableApplicationKeys() {
        return this.applicationAccessAdapter.getAvailableApplicationKeys();
    }

    @Override
    public Set<String> getGroupsForApplicationAccess(String applicationAccessKey) {
        return this.applicationAccessAdapter.getGroupsGivingAccess(applicationAccessKey);
    }

    @Override
    public int getAvailableConfluenceUserLicenses() {
        return this.licenseCountProvider.getAvailableConfluenceUserLicenses();
    }

    @Override
    public int getAvailableBitbucketUserLicenses() {
        return this.licenseCountProvider.getAvailableBitbucketUserLicenses();
    }

    @Override
    public int getAvailableJiraCoreUserLicenses() {
        return this.licenseCountProvider.getAvailableJiraCoreUserLicenses();
    }

    @Override
    public int getAvailableJiraSoftwareUserLicenses() {
        return this.licenseCountProvider.getAvailableJiraSoftwareUserLicenses();
    }

    @Override
    public int getAvailableJSMUserLicenses() {
        return this.licenseCountProvider.getAvailableJSMUserLicenses();
    }
}

