/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import de.resolution.atlasuser.api.exception.AtlasUserValidationFailedException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.impl.user.DefaultAtlasUserValidator;
import java.util.Objects;
import java.util.regex.Pattern;

@BambooComponent
public class BambooAtlasUserValidator
extends DefaultAtlasUserValidator {
    private static final int MAX_NAME_LENGTH = 255;
    private static final Pattern illegalCharactersPattern = Pattern.compile("[\"'<>/\\\\]+");

    @Override
    public void validateForCreate(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        super.validateForCreate(atlasUser);
        this.validateUsername(atlasUser);
    }

    @Override
    public void validateForRenaming(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        this.validateUsername(atlasUser);
    }

    private void validateUsername(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        String username = atlasUser.get("ATTR_NEW_NAME").orElse(atlasUser.get("ATTR_NAME").orElse(null));
        if (username == null) {
            return;
        }
        if (!Objects.equals(username.trim(), username)) {
            throw new AtlasUserValidationFailedException(atlasUser.getReference(), "ATTR_NAME", username, " must not have trailing or leading spaces.");
        }
        if (username.length() > 255) {
            throw new AtlasUserValidationFailedException(atlasUser.getReference(), "ATTR_NAME", username, " must not exceed 255 characters.");
        }
        if (illegalCharactersPattern.matcher(username).find()) {
            throw new AtlasUserValidationFailedException(atlasUser.getReference(), "ATTR_NAME", username, " contains illegal characters. The following characters are invalid in usernames: '\\', `/`, '<', '>', ', or \".");
        }
    }
}

