/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.group;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.exception.AtlasUserRuntimeException;
import de.resolution.atlasuser.api.group.AtlasGroup;
import de.resolution.atlasuser.api.group.AtlasGroupReference;
import de.resolution.atlasuser.api.group.AtlasGroupResult;
import de.resolution.atlasuser.impl.ExceptionInfoImpl;
import de.resolution.atlasuser.impl.group.ImmutableAtlasGroup;
import de.resolution.atlasuser.impl.group.ImmutableAtlasGroupReference;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class ImmutableAtlasGroupResult
implements AtlasGroupResult {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final AtlasGroupReference reference;
    private final boolean success;
    private final boolean modified;
    private final long timestamp;
    private final AtlasGroupResult.Operation operation;
    private final AtlasGroup inputGroup;
    private final AtlasGroup initialGroup;
    private final AtlasGroup resultingGroup;
    private final AtlasGroupResult.ErrorType errorType;
    private final List<String> messages;
    private final ExceptionInfo exceptionInfo;

    ImmutableAtlasGroupResult(@Nonnull AtlasGroupReference reference, boolean success, @Nullable AtlasGroupResult.Operation operation, @Nullable AtlasGroup inputGroup, @Nullable AtlasGroup initialGroup, @Nullable AtlasGroup resultingGroup, @Nullable AtlasGroupResult.ErrorType errorType, @Nullable List<String> messages, @Nullable ExceptionInfo exceptionInfo) {
        this.reference = reference;
        this.success = success;
        this.operation = operation;
        this.inputGroup = inputGroup;
        this.initialGroup = initialGroup;
        this.resultingGroup = resultingGroup;
        this.errorType = errorType;
        this.messages = messages;
        this.exceptionInfo = exceptionInfo;
        this.timestamp = System.currentTimeMillis();
        this.modified = operation == AtlasGroupResult.Operation.ADDED || operation == AtlasGroupResult.Operation.DELETED || operation == AtlasGroupResult.Operation.UPDATED || operation == AtlasGroupResult.Operation.MEMBER_ADDED || operation == AtlasGroupResult.Operation.MEMBER_REMOVED;
    }

    @JsonCreator
    public ImmutableAtlasGroupResult(@JsonProperty(value="reference") @Nonnull ImmutableAtlasGroupReference reference, @JsonProperty(value="success") boolean success, @JsonProperty(value="operation") @Nullable AtlasGroupResult.Operation operation, @JsonProperty(value="inputGroup") @Nullable ImmutableAtlasGroup inputGroup, @JsonProperty(value="initialGroup") @Nullable ImmutableAtlasGroup initialGroup, @JsonProperty(value="resultingGroup") @Nullable ImmutableAtlasGroup resultingGroup, @JsonProperty(value="errorType") @Nullable AtlasGroupResult.ErrorType errorType, @JsonProperty(value="messages") @Nullable List<String> messages, @JsonProperty(value="exceptionInfo") @Nullable ExceptionInfoImpl exceptionInfo, @JsonProperty(value="modified") boolean modified, @JsonProperty(value="timestamp") long timestamp) {
        this.reference = reference;
        this.success = success;
        this.operation = operation;
        this.inputGroup = inputGroup;
        this.initialGroup = initialGroup;
        this.resultingGroup = resultingGroup;
        this.errorType = errorType;
        this.messages = messages;
        this.exceptionInfo = exceptionInfo;
        this.modified = modified;
        this.timestamp = timestamp;
    }

    static ImmutableAtlasGroupResult from(AtlasGroupResult other) {
        if (other == null) {
            return null;
        }
        if (other instanceof ImmutableAtlasGroupResult) {
            return (ImmutableAtlasGroupResult)other;
        }
        return new ImmutableAtlasGroupResult(other.getReference(), other.isSuccess(), other.getOperation().orElse(null), other.getInputGroup().orElse(null), other.getInitialGroup().orElse(null), other.getResultingGroup().orElse(null), other.getErrorType().orElse(null), other.getMessages().orElse(null), other.getExceptionInfo().orElse(null));
    }

    public static ImmutableAtlasGroupResult fromJson(String json) {
        try {
            return objectMapper.readValue(json, ImmutableAtlasGroupResult.class);
        }
        catch (IOException e) {
            throw new AtlasUserRuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public AtlasGroupReference getReference() {
        return this.reference;
    }

    @Override
    @Nonnull
    public Optional<AtlasGroupResult.Operation> getOperation() {
        return Optional.ofNullable(this.operation);
    }

    @Override
    @Nonnull
    public Optional<AtlasGroup> getInputGroup() {
        return Optional.ofNullable(this.inputGroup);
    }

    @Override
    @Nonnull
    public Optional<AtlasGroup> getInitialGroup() {
        return Optional.ofNullable(this.initialGroup);
    }

    @Override
    @Nonnull
    public Optional<AtlasGroup> getResultingGroup() {
        return Optional.ofNullable(this.resultingGroup);
    }

    @Override
    @Nonnull
    public Optional<ExceptionInfo> getExceptionInfo() {
        return Optional.ofNullable(this.exceptionInfo);
    }

    @Override
    @Nonnull
    public Optional<List<String>> getMessages() {
        return Optional.ofNullable(this.messages);
    }

    @Override
    @Nonnull
    public Optional<AtlasGroupResult.ErrorType> getErrorType() {
        return Optional.ofNullable(this.errorType);
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }
}

