/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.api.user;

import de.resolution.atlasuser.impl.user.AbstractAttributeFilter;
import de.resolution.atlasuser.impl.user.LongAttributeFilter;
import de.resolution.atlasuser.impl.user.StringAttributeFilter;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface AttributeFilter {
    public List<String> getAttributeNames();

    public boolean test(Map<String, Set<String>> var1);

    public static AttributeFilter present(String ... attributeNames) {
        return new AbstractAttributeFilter.PresentAttributeFilter(attributeNames);
    }

    public static AttributeFilter notPresent(String ... attributeNames) {
        return new AbstractAttributeFilter.NotPresentAttributeFilter(attributeNames);
    }

    public static AttributeFilter notEmpty(String ... attributeNames) {
        return new AbstractAttributeFilter.NotEmptyAttributeFilter(attributeNames);
    }

    public static AttributeFilter equalTo(long compareTo, String ... attributeNames) {
        return new LongAttributeFilter.EqualLongAttributeFilter(compareTo, attributeNames);
    }

    public static AttributeFilter greater(long compareTo, String ... attributeNames) {
        return new LongAttributeFilter.GreaterLongAttributeFilter(compareTo, attributeNames);
    }

    public static AttributeFilter greaterOrEqual(long compareTo, String ... attributeNames) {
        return new LongAttributeFilter.GreaterOrEqualLongAttributeFilter(compareTo, attributeNames);
    }

    public static AttributeFilter lower(long compareTo, String ... attributeNames) {
        return new LongAttributeFilter.LowerLongAttributeFilter(compareTo, attributeNames);
    }

    public static AttributeFilter lowerOrEqual(long compareTo, String ... attributeNames) {
        return new LongAttributeFilter.LowerOrEqualLongAttributeFilter(compareTo, attributeNames);
    }

    public static AttributeFilter equalTo(String compareTo, String ... attributeNames) {
        return new StringAttributeFilter.EqualsStringAttributeFilter(compareTo, attributeNames);
    }
}

