/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.api.user;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.atlasuser.impl.user.ImmutableAtlasUserResult;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@JsonDeserialize(as=ImmutableAtlasUserResult.class)
@Immutable
public interface AtlasUserResult {
    public static AtlasUserResultBuilder builder(AtlasUserReference reference) {
        return new AtlasUserResultBuilder(reference);
    }

    public static AtlasUserResult fromJson(String json) {
        return ImmutableAtlasUserResult.fromJson(json);
    }

    @Nonnull
    public AtlasUserReference getReference();

    @Nonnull
    public Operation getOperation();

    @Nonnull
    public Optional<AtlasUser> getInputUser();

    @Nonnull
    public Optional<AtlasUser> getInitialUser();

    @Nonnull
    public Optional<AtlasUser> getResultingUser();

    @Nonnull
    public Optional<ExceptionInfo> getExceptionInfo();

    @Nonnull
    public Optional<List<String>> getMessages();

    @Nonnull
    public ErrorType getErrorType();

    @Nonnull
    public Optional<AtlasUserResult> getRemoveInOtherResult();

    @Nonnull
    public Optional<JsonNode> getDiff();

    public long getTimestamp();

    public boolean isModified();

    public boolean isNotFound();

    public boolean isSimulated();

    public boolean isSuccess();

    public static boolean isModified(Operation operation) {
        return operation == Operation.ADDED || operation == Operation.DELETED || operation == Operation.UPDATED;
    }

    public static enum Operation {
        ADDED,
        DELETED,
        UPDATED,
        NOT_MODIFIED,
        NONE,
        FILTERED,
        FAILED;

    }

    public static enum ErrorType {
        NOT_FOUND,
        NOT_UNIQUE,
        OPERATION_FAILED,
        DIRECTORY_NOT_FOUND,
        INVALID_SEARCH_ATTRIBUTE,
        VALIDATION_FAILED,
        NONE;

    }
}

