/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.api.group;

import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.group.AtlasGroup;
import de.resolution.atlasuser.api.group.AtlasGroupReference;
import de.resolution.atlasuser.impl.group.AtlasGroupResultBuilder;
import de.resolution.atlasuser.impl.group.ImmutableAtlasGroupResult;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface AtlasGroupResult {
    public static AtlasGroupResultBuilder builder(AtlasGroupReference reference) {
        return new AtlasGroupResultBuilder(reference);
    }

    public static AtlasGroupResult fromJson(String json) {
        return ImmutableAtlasGroupResult.fromJson(json);
    }

    @Nonnull
    public AtlasGroupReference getReference();

    @Nonnull
    public Optional<Operation> getOperation();

    @Nonnull
    public Optional<AtlasGroup> getInputGroup();

    @Nonnull
    public Optional<AtlasGroup> getInitialGroup();

    @Nonnull
    public Optional<AtlasGroup> getResultingGroup();

    @Nonnull
    public Optional<ExceptionInfo> getExceptionInfo();

    @Nonnull
    public Optional<List<String>> getMessages();

    @Nonnull
    public Optional<ErrorType> getErrorType();

    public long getTimestamp();

    public boolean isModified();

    public boolean isSuccess();

    public static enum Operation {
        ADDED,
        DELETED,
        UPDATED,
        NOT_MODIFIED,
        NONE,
        FILTERED,
        MEMBER_ADDED,
        MEMBER_REMOVED;

    }

    public static enum ErrorType {
        NOT_FOUND,
        NOT_UNIQUE,
        OPERATION_FAILED,
        DIRECTORY_NOT_FOUND,
        INVALID_SEARCH_ATTRIBUTE,
        VALIDATION_FAILED;

    }
}

