/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl;

import de.resolution.atlasauth.api.AuthenticationInformation;
import de.resolution.atlasauth.api.AuthenticationResult;
import de.resolution.atlasauth.impl.AuthenticationResultImpl;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthenticationResultBuilder {
    private String message;
    private AuthenticationResult.Outcome outcome;
    private boolean responseCommitted = false;
    private String userid;
    private AuthenticationInformation authenticationInformation = AuthenticationInformation.builder().username("NONE").build();

    public AuthenticationResultBuilder() {
    }

    public AuthenticationResultBuilder(AuthenticationResult other) {
        this.authenticationInformation = other.getAuthenticationInformation();
        this.userid = other.getUserid();
        this.message = other.getMessage();
        this.outcome = other.getOutcome();
        this.responseCommitted = other.isResponseCommitted();
    }

    public AuthenticationResultBuilder message(@Nullable String message) {
        this.message = message;
        return this;
    }

    public AuthenticationResultBuilder userid(@Nullable String userid) {
        this.userid = userid;
        return this;
    }

    public AuthenticationResultBuilder authenticationInformation(@Nonnull AuthenticationInformation authenticationInformation) {
        this.authenticationInformation = authenticationInformation;
        return this;
    }

    public AuthenticationResultBuilder outcome(@Nonnull AuthenticationResult.Outcome outcome) {
        this.outcome = outcome;
        return this;
    }

    public AuthenticationResultBuilder responseCommitted(boolean responseCommitted) {
        this.responseCommitted = responseCommitted;
        return this;
    }

    public AuthenticationResult build() {
        if (this.outcome == null) {
            throw new NullPointerException("outcome must not be null");
        }
        if (this.authenticationInformation == null) {
            throw new NullPointerException("authenticationInformation must not be null");
        }
        return new AuthenticationResultImpl(this.authenticationInformation, this.outcome, this.userid, this.message, this.responseCommitted);
    }
}

