/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl;

import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import de.resolution.atlasauth.impl.AuthenticationAttribute;
import de.resolution.atlasauth.impl.RemoteDirectoryAdapter;
import de.resolution.atlasauth.impl.SyncRequiredException;
import de.resolution.atlasauth.impl.UserAuthException;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteDirectoryAdapter
implements RemoteDirectoryAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRemoteDirectoryAdapter.class);
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final CrowdService crowdService;
    private final OkHttpClient okHttpClient;
    private static final int REQUEST_TIMEOUT = 30;

    public AbstractRemoteDirectoryAdapter(DirectoryInstanceLoader directoryInstanceLoader, CrowdService crowdService) {
        this.directoryInstanceLoader = directoryInstanceLoader;
        this.crowdService = crowdService;
        this.okHttpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }

    @Override
    public Principal findRemoteUser(@Nonnull AuthenticationAttribute authenticationAttribute, @Nonnull String authenticationAttributeValue, @Nonnull Directory directory, boolean fetchRemoteDirectories, boolean triggerUpdateInCrowd) throws SyncRequiredException {
        if (directory.getType() == DirectoryType.DELEGATING || directory.getType() == DirectoryType.CONNECTOR || directory.getType() == DirectoryType.CROWD) {
            if (!fetchRemoteDirectories) {
                logger.debug("fetchRemoteDirectories is disabled, not searching in the remote directory {}", (Object)directory.getName());
                return null;
            }
            if (triggerUpdateInCrowd) {
                if (authenticationAttribute == AuthenticationAttribute.USERNAME) {
                    this.triggerUpdateInCrowd(authenticationAttributeValue, directory);
                } else {
                    logger.debug("Trigger update in crowd is only available when using username as authentication attribute");
                }
            }
            try {
                com.atlassian.crowd.model.user.User remoteUser;
                RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getDirectory(directory);
                RemoteDirectory authoritativeDirectory = remoteDirectory.getAuthoritativeDirectory();
                if (authenticationAttribute == AuthenticationAttribute.USERNAME) {
                    remoteUser = authoritativeDirectory.findUserByName(authenticationAttributeValue);
                } else if (authenticationAttribute == AuthenticationAttribute.EMAIL) {
                    UserQuery eq = new UserQuery(com.atlassian.crowd.model.user.User.class, (SearchRestriction)new TermRestriction(UserTermKeys.EMAIL, MatchMode.EXACTLY_MATCHES, (Object)authenticationAttributeValue), 0, 2);
                    List users = authoritativeDirectory.searchUsers((EntityQuery)eq);
                    if (users.isEmpty()) {
                        throw new UserNotFoundException("Remote user with email address " + authenticationAttributeValue + " was not found in directory " + directory.getName() + ".");
                    }
                    if (users.size() > 1) {
                        throw new UserAuthException("Multiple users with email address " + authenticationAttributeValue + " found in directory " + remoteDirectory.getDescriptiveName() + ".");
                    }
                    remoteUser = (com.atlassian.crowd.model.user.User)users.get(0);
                } else if (authenticationAttribute == AuthenticationAttribute.ADDITIONALID) {
                    Property<String> property = new Property<String>(){

                        public String getPropertyName() {
                            return "ATTR_ADDITIONAL_ID";
                        }

                        public Class<String> getPropertyType() {
                            return String.class;
                        }
                    };
                    TermRestriction termRestriction = new TermRestriction((Property)property, MatchMode.EXACTLY_MATCHES, (Object)authenticationAttributeValue);
                    UserQuery eq = new UserQuery(com.atlassian.crowd.model.user.User.class, (SearchRestriction)termRestriction, 0, 2);
                    List users = authoritativeDirectory.searchUsers((EntityQuery)eq);
                    if (users.isEmpty()) {
                        throw new UserNotFoundException("Remote user with additionalId " + authenticationAttributeValue + " was not found in directory " + directory.getName() + ".");
                    }
                    if (users.size() > 1) {
                        throw new UserAuthException("Multiple users with additionalId " + authenticationAttributeValue + " found in directory " + remoteDirectory.getDescriptiveName() + ".");
                    }
                    remoteUser = (com.atlassian.crowd.model.user.User)users.get(0);
                } else {
                    logger.error("Authentication attribute {} is not supported.", (Object)authenticationAttribute);
                    return null;
                }
                logger.info("Found user in authorative directory: {}, {} ", (Object)remoteUser.getDisplayName(), (Object)remoteUser.getEmailAddress());
                this.updateRemoteUser(directory, remoteDirectory, remoteUser.getName(), remoteUser);
                return remoteUser;
            }
            catch (UserNotFoundException e) {
                logger.debug("Remote user with <{}:{}> was not found in directory {}", new Object[]{authenticationAttribute, authenticationAttributeValue, directory.getName()});
                return null;
            }
            catch (SyncRequiredException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Searching user <{}:{}> in remote directory {} failed", new Object[]{authenticationAttribute, authenticationAttributeValue, directory.getName(), e});
                return null;
            }
        }
        logger.debug("{} of type {} is not a directory type for remote search", (Object)directory.getName(), (Object)directory.getType().toString());
        return null;
    }

    private void updateRemoteUser(Directory directory, RemoteDirectory remoteDirectory, String userid, com.atlassian.crowd.model.user.User remoteUser) throws UserNotFoundException, OperationFailedException, SyncRequiredException {
        if (remoteDirectory instanceof DelegatedAuthenticationDirectory) {
            DelegatedAuthenticationDirectory delegatingDirectory = (DelegatedAuthenticationDirectory)remoteDirectory;
            delegatingDirectory.addOrUpdateLdapUser(userid);
            this.assignDirectoryDefaultGroups((Principal)remoteUser, directory, true);
        } else if (remoteDirectory instanceof DbCachingRemoteDirectory) {
            DbCachingRemoteDirectory dbCachingRemoteDirectory = (DbCachingRemoteDirectory)remoteDirectory;
            logger.debug("Calling updateUserFromRemoteDirectory for {}", (Object)remoteDirectory.toString());
            try {
                dbCachingRemoteDirectory.updateUserFromRemoteDirectory(remoteUser);
            }
            catch (NoSuchMethodError e) {
                throw new SyncRequiredException();
            }
            this.assignDirectoryDefaultGroups((Principal)remoteUser, directory, true);
        } else {
            logger.warn("Directory {} is of unexpected class {}, not triggering user copy or something like that", (Object)remoteDirectory.getDescriptiveName(), (Object)remoteDirectory.getClass().getName());
        }
    }

    @Override
    public void updateRemoteUser(@Nonnull String userid, @Nonnull Directory directory, boolean fetchRemoteDirectories, boolean triggerUpdateInCrowd) {
        block10: {
            logger.debug("updateRemoteUser is called");
            try {
                if (directory.getType() == DirectoryType.DELEGATING || directory.getType() == DirectoryType.CONNECTOR || directory.getType() == DirectoryType.CROWD) {
                    RemoteDirectory remoteDirectory;
                    if (!fetchRemoteDirectories) {
                        logger.info("fetchRemoteDirectories is disabled, not updating the user from the remote directory {}", (Object)directory.getName());
                        return;
                    }
                    if (triggerUpdateInCrowd) {
                        this.triggerUpdateInCrowd(userid, directory);
                    }
                    if ((remoteDirectory = this.directoryInstanceLoader.getDirectory(directory)) instanceof DelegatedAuthenticationDirectory) {
                        logger.debug("This is a DELEGATING directory, calling addOrUpdateLdapUser for {}", (Object)userid);
                        DelegatedAuthenticationDirectory delegatingDirectory = (DelegatedAuthenticationDirectory)remoteDirectory;
                        logger.debug("delegting directory type is {}", (Object)delegatingDirectory.getClass().getCanonicalName());
                        delegatingDirectory.addOrUpdateLdapUser(userid);
                        break block10;
                    }
                    com.atlassian.crowd.model.user.User user = remoteDirectory.findUserByName(userid);
                    if (user != null) {
                        try {
                            logger.debug("Calling updateUserFromRemoteDirectory for {}", (Object)user.toString());
                            remoteDirectory.updateUserFromRemoteDirectory(user);
                            break block10;
                        }
                        catch (NoSuchMethodError e) {
                            throw new SyncRequiredException();
                        }
                    }
                    logger.warn("Userid {} was not found in the remote directory", (Object)userid);
                    break block10;
                }
                logger.debug("Not updating the remote user from directory of type {}", (Object)directory.getType());
            }
            catch (UserNotFoundException e) {
                logger.warn("Userid {} was not found in the remote directory", (Object)userid);
            }
            catch (Exception e) {
                logger.warn("updateRemoteUser failed", (Throwable)e);
            }
        }
    }

    @Override
    public void assignDirectoryDefaultGroups(@Nonnull Principal principal, @Nonnull Directory directory) {
        this.assignDirectoryDefaultGroups(principal, directory, false);
    }

    private boolean isAssignDirectoryDefaultGroups(Principal principal, Directory directory) {
        boolean addEveryLogin;
        if (!directory.getType().equals((Object)DirectoryType.CONNECTOR)) {
            return false;
        }
        String syncConfig = directory.getValue("crowd.sync.group.membership.after.successful.user.auth.enabled");
        boolean bl = addEveryLogin = syncConfig != null && syncConfig.equals("true");
        if (addEveryLogin) {
            return true;
        }
        boolean addFirst = syncConfig == null || syncConfig.equals("only_when_first_created");
        return addFirst && this.isFirstLogin(principal);
    }

    private void assignDirectoryDefaultGroups(Principal principal, Directory directory, boolean always) {
        if (!directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            if (always || this.isAssignDirectoryDefaultGroups(principal, directory)) {
                String groups2 = directory.getValue("autoAddGroups");
                List<Object> groupList = Collections.emptyList();
                logger.debug("autoAddGroups for directory {} are {}", (Object)directory.getName(), (Object)groups2);
                if (groups2 != null && !groups2.trim().isEmpty()) {
                    groupList = groups2.contains("|") ? Arrays.asList(groups2.split("\\|")) : Arrays.asList(groups2.split(","));
                }
                try {
                    User user = this.crowdService.getUser(principal.getName());
                    if (user == null) {
                        logger.warn("User for principal {} is null, cannot add default directory groups", (Object)principal.getName());
                    }
                    for (String groupName : groupList) {
                        if (groupName.trim().isEmpty()) {
                            logger.warn("groupName is empty, skipping");
                            continue;
                        }
                        logger.trace("Checking whether user is member of {}", (Object)groupName);
                        Group group = this.crowdService.getGroup(groupName);
                        if (group == null || this.crowdService.isUserMemberOfGroup(user, group)) continue;
                        try {
                            if (!this.crowdService.addUserToGroup(user, group)) continue;
                            logger.debug("added {} to group {}", (Object)user.getName(), (Object)group.getName());
                        }
                        catch (Exception groupException) {
                            logger.error("Adding {} to group {} failed", new Object[]{user.getName(), group.getName(), groupException});
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("Adding default directory groups failed", (Throwable)e);
                }
            } else {
                logger.debug("No need to add this user to the directory default groups");
            }
        }
    }

    @Override
    public void triggerUpdateInCrowd(@Nonnull String userid, @Nonnull Directory directory) {
        if (directory.getType() == DirectoryType.CROWD) {
            logger.debug("This is a CROWD-directory, triggering update there...");
            String crowdServerUrl = (String)directory.getAttributes().get("crowd.server.url");
            if (!crowdServerUrl.endsWith("/")) {
                crowdServerUrl = crowdServerUrl + "/";
            }
            String triggerUrl = crowdServerUrl + "rest/de.resolution.updateuserfromremotedirectory/1.0/";
            logger.debug("URL for triggering update is {}", (Object)triggerUrl);
            MediaType textType = MediaType.parse("text/plain");
            RequestBody body = RequestBody.create(textType, userid);
            Request request = new Request.Builder().put(body).url(triggerUrl).build();
            try (Response response = this.okHttpClient.newCall(request).execute();){
                if (response.code() != 204 && logger.isWarnEnabled()) {
                    logger.warn("Unexpected response code: {}, message: {}", (Object)response.code(), (Object)response.message());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("HTTP response status is {}: {}", (Object)response.code(), (Object)response.message());
                }
            }
            catch (IOException ioexception) {
                logger.warn("HTTP request to Crowd failed: ", (Throwable)ioexception);
            }
        }
    }

    protected abstract boolean isFirstLogin(Principal var1);
}

