/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.resolution.albauth.AlbAuthenticationConfiguration;
import de.resolution.albauth.configloading.ConfigurationLoadException;
import de.resolution.albauth.configloading.ConfigurationMigrationException;
import java.io.IOException;

public class JsonConfigurationLoader {
    public static final int CURRENT_VERSION = 2;
    private static final String KEY_VERSION = "version";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JsonConfigurationLoader() {
    }

    private static int readVersion(JsonNode configNode) {
        JsonNode versionNode = configNode.get(KEY_VERSION);
        if (versionNode == null) {
            return 0;
        }
        return versionNode.asInt();
    }

    private static ObjectNode asObjectNode(JsonNode jsonNode) throws ConfigurationMigrationException {
        if (jsonNode == null) {
            throw new ConfigurationMigrationException("JsonNode must not be null");
        }
        if (!(jsonNode instanceof ObjectNode)) {
            throw new ConfigurationMigrationException("JsonNode must be an ObjectNode but is a " + jsonNode.getClass().getName());
        }
        return (ObjectNode)jsonNode;
    }

    private static void setVersion(ObjectNode configNode, int expectedValue, int newValue) throws ConfigurationMigrationException {
        int version = JsonConfigurationLoader.readVersion(configNode);
        if (version != expectedValue) {
            throw new ConfigurationMigrationException("Actual version does not match expected version");
        }
        configNode.remove(KEY_VERSION);
        configNode.put(KEY_VERSION, newValue);
    }

    private static boolean migrate(JsonNode jsonNode) throws ConfigurationMigrationException {
        int version = JsonConfigurationLoader.readVersion(jsonNode);
        if (version == 2) {
            return false;
        }
        ObjectNode configNode = JsonConfigurationLoader.asObjectNode(jsonNode);
        if (version == 0) {
            JsonConfigurationLoader.migrateV0ToV1(configNode);
            JsonConfigurationLoader.migrateV1ToV2(configNode);
            return true;
        }
        if (version == 1) {
            JsonConfigurationLoader.migrateV1ToV2(configNode);
            return true;
        }
        throw new ConfigurationMigrationException("Found unknown config version " + version + " or forgot return statement");
    }

    private static void migrateV0ToV1(ObjectNode node) throws ConfigurationMigrationException {
        JsonConfigurationLoader.setVersion(node, 0, 1);
    }

    private static void migrateV1ToV2(ObjectNode node) throws ConfigurationMigrationException {
        JsonConfigurationLoader.setVersion(node, 1, 2);
    }

    public static AlbAuthenticationConfiguration migrateAndLoadConfig(String jsonData) throws ConfigurationLoadException {
        try {
            JsonNode effectiveJsonNode = objectMapper.readTree(jsonData);
            JsonConfigurationLoader.migrate(effectiveJsonNode);
            return objectMapper.treeToValue((TreeNode)effectiveJsonNode, AlbAuthenticationConfiguration.class);
        }
        catch (ConfigurationMigrationException | IOException e) {
            throw new ConfigurationLoadException("Loading JSON-configuration failed", e);
        }
    }
}

