/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.unboundid.scim2.common.utils.CalendarDeserializer;
import com.unboundid.scim2.common.utils.CalendarSerializer;
import com.unboundid.scim2.common.utils.DateDeserializer;
import com.unboundid.scim2.common.utils.DateSerializer;
import com.unboundid.scim2.common.utils.ScimJsonFactory;
import com.unboundid.scim2.common.utils.ScimJsonNodeFactory;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class MapperFactory {
    private static Map<DeserializationFeature, Boolean> deserializationCustomFeatures = Collections.emptyMap();
    private static Map<JsonParser.Feature, Boolean> jsonParserCustomFeatures = Collections.emptyMap();
    private static Map<JsonGenerator.Feature, Boolean> jsonGeneratorCustomFeatures = Collections.emptyMap();
    private static Map<MapperFeature, Boolean> mapperCustomFeatures = Collections.emptyMap();
    private static Map<SerializationFeature, Boolean> serializationCustomFeatures = Collections.emptyMap();

    public MapperFactory setDeserializationCustomFeatures(Map<DeserializationFeature, Boolean> customFeatures) {
        deserializationCustomFeatures = customFeatures;
        return this;
    }

    public MapperFactory setJsonGeneratorCustomFeatures(Map<JsonGenerator.Feature, Boolean> customFeatures) {
        jsonGeneratorCustomFeatures = customFeatures;
        return this;
    }

    public MapperFactory setJsonParserCustomFeatures(Map<JsonParser.Feature, Boolean> customFeatures) {
        jsonParserCustomFeatures = customFeatures;
        return this;
    }

    public MapperFactory setMapperCustomFeatures(Map<MapperFeature, Boolean> customFeatures) {
        mapperCustomFeatures = customFeatures;
        return this;
    }

    public MapperFactory setSerializationCustomFeatures(Map<SerializationFeature, Boolean> customFeatures) {
        serializationCustomFeatures = customFeatures;
        return this;
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper(new ScimJsonFactory());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleModule dateTimeModule = new SimpleModule();
        dateTimeModule.addSerializer(Calendar.class, new CalendarSerializer());
        dateTimeModule.addDeserializer(Calendar.class, new CalendarDeserializer());
        dateTimeModule.addSerializer(Date.class, new DateSerializer());
        dateTimeModule.addDeserializer(Date.class, new DateDeserializer());
        mapper.registerModule(dateTimeModule);
        mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        mapper.setNodeFactory(new ScimJsonNodeFactory());
        for (DeserializationFeature deserializationFeature : deserializationCustomFeatures.keySet()) {
            mapper.configure(deserializationFeature, (boolean)deserializationCustomFeatures.get(deserializationFeature));
        }
        for (JsonGenerator.Feature feature : jsonGeneratorCustomFeatures.keySet()) {
            mapper.configure(feature, (boolean)jsonGeneratorCustomFeatures.get((Object)feature));
        }
        for (JsonParser.Feature feature : jsonParserCustomFeatures.keySet()) {
            mapper.configure(feature, (boolean)jsonParserCustomFeatures.get((Object)feature));
        }
        for (MapperFeature mapperFeature : mapperCustomFeatures.keySet()) {
            mapper.configure(mapperFeature, (boolean)mapperCustomFeatures.get(mapperFeature));
        }
        for (SerializationFeature serializationFeature : serializationCustomFeatures.keySet()) {
            mapper.configure(serializationFeature, (boolean)serializationCustomFeatures.get(serializationFeature));
        }
        return mapper;
    }
}

